/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageTraceable;

public class VariableFEDInstruction
extends FEDInstruction
implements LineageTraceable {
    private static final Log LOG = LogFactory.getLog((String)VariableFEDInstruction.class.getName());
    private final VariableCPInstruction _in;

    protected VariableFEDInstruction(VariableCPInstruction in) {
        super(null, in.getOperator(), in.getOpcode(), in.getInstructionString());
        this._in = in;
    }

    public static VariableFEDInstruction parseInstruction(VariableCPInstruction cpInstruction) {
        return new VariableFEDInstruction(cpInstruction);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        VariableCPInstruction.VariableOperationCode opcode = this._in.getVariableOpcode();
        switch (opcode) {
            case Write: {
                this.processWriteInstruction(ec);
                break;
            }
            case CastAsMatrixVariable: {
                this.processCastAsMatrixVariableInstruction(ec);
                break;
            }
            case CastAsFrameVariable: {
                this.processCastAsFrameVariableInstruction(ec);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported Opcode for federated Variable Instruction : " + (Object)((Object)opcode));
            }
        }
    }

    private void processWriteInstruction(ExecutionContext ec) {
        LOG.warn((Object)"Processing write command federated");
        this._in.processInstruction(ec);
    }

    private void processCastAsMatrixVariableInstruction(ExecutionContext ec) {
        FrameObject mo1 = ec.getFrameObject(this._in.getInput1());
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated Reorg: Federated input expected, but invoked w/ " + mo1.isFederated());
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this._in.getInstructionString(), this._in.getOutput(), new CPOperand[]{this._in.getInput1()}, new long[]{mo1.getFedMapping().getID()});
        mo1.getFedMapping().execute(this.getTID(), true, fr1);
        MatrixObject out = ec.getMatrixObject(this._in.getOutput());
        FederationMap outMap = mo1.getFedMapping().copyWithNewID(fr1.getID());
        ArrayList<Pair> newMap = new ArrayList<Pair>();
        for (Pair<FederatedRange, FederatedData> pair : outMap.getMap()) {
            FederatedData om = (FederatedData)pair.getValue();
            FederatedData nf = new FederatedData(Types.DataType.MATRIX, om.getAddress(), om.getFilepath(), om.getVarID());
            newMap.add(Pair.of((Object)pair.getKey(), (Object)nf));
        }
        out.setFedMapping(outMap);
    }

    private void processCastAsFrameVariableInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this._in.getInput1());
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated Reorg: Federated input expected, but invoked w/ " + mo1.isFederated());
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this._in.getInstructionString(), this._in.getOutput(), new CPOperand[]{this._in.getInput1()}, new long[]{mo1.getFedMapping().getID()});
        mo1.getFedMapping().execute(this.getTID(), true, fr1);
        FrameObject out = ec.getFrameObject(this._in.getOutput());
        out.getDataCharacteristics().set(mo1.getNumRows(), mo1.getNumColumns(), (int)mo1.getBlocksize(), mo1.getNnz());
        FederationMap outMap = mo1.getFedMapping().copyWithNewID(fr1.getID());
        ArrayList<Pair> newMap = new ArrayList<Pair>();
        for (Map.Entry entry : outMap.getMap()) {
            FederatedData om = (FederatedData)entry.getValue();
            FederatedData nf = new FederatedData(Types.DataType.FRAME, om.getAddress(), om.getFilepath(), om.getVarID());
            newMap.add(Pair.of(entry.getKey(), (Object)nf));
        }
        Types.ValueType[] schema = new Types.ValueType[(int)mo1.getDataCharacteristics().getCols()];
        Arrays.fill((Object[])schema, (Object)Types.ValueType.FP64);
        out.setSchema(schema);
        out.setFedMapping(outMap);
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return this._in.getLineageItem(ec);
    }
}

