/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandler;

public class FederatedLocalData
extends FederatedData {
    protected static final Logger log = Logger.getLogger(FederatedWorkerHandler.class);
    private static final ExecutionContextMap ecm = new ExecutionContextMap();
    private static final FederatedWorkerHandler fwh = new FederatedWorkerHandler(ecm);
    private final CacheableData<?> _data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedLocalData(long id, CacheableData<?> data) {
        super(data.getDataType(), null, data.getFileName());
        this._data = data;
        ExecutionContextMap executionContextMap = ecm;
        synchronized (executionContextMap) {
            ecm.get(-1L).setVariable(Long.toString(id), this._data);
        }
        this.setVarID(id);
    }

    @Override
    boolean equalAddress(FederatedData that) {
        return that.getClass().equals(this.getClass());
    }

    @Override
    public FederatedData copyWithNewID(long varID) {
        return new FederatedLocalData(varID, this._data);
    }

    @Override
    public synchronized Future<FederatedResponse> executeFederatedOperation(FederatedRequest ... request) {
        return CompletableFuture.completedFuture(fwh.createResponse((Object)request));
    }
}

