/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.List;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.Bitmap;
import org.apache.sysds.runtime.compress.bitmap.MultiColBitmap;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayIntListHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleIntListHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class BitmapEncoder {
    public static ABitmap extractBitmap(int[] colIndices, MatrixBlock rawBlock, boolean transposed, int estimatedNumberOfUniques) {
        int numRows;
        if (rawBlock == null || rawBlock.isEmpty()) {
            return null;
        }
        int n = numRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        if (colIndices.length == 1) {
            return BitmapEncoder.extractBitmapSingleColumn(colIndices[0], rawBlock, numRows, transposed);
        }
        DblArrayIntListHashMap map = new DblArrayIntListHashMap(Math.max(estimatedNumberOfUniques, 8));
        return BitmapEncoder.extractBitmapMultiColumns(colIndices, rawBlock, numRows, transposed, map);
    }

    private static ABitmap extractBitmapSingleColumn(int colIndex, MatrixBlock rawBlock, int numRows, boolean transposed) {
        if (rawBlock.isInSparseFormat() && transposed && rawBlock.getSparseBlock().isEmpty(colIndex)) {
            return new Bitmap(null, null, numRows);
        }
        DoubleIntListHashMap hashMap = transposed ? BitmapEncoder.extractHashMapTransposed(colIndex, rawBlock) : BitmapEncoder.extractHashMap(colIndex, rawBlock);
        return BitmapEncoder.makeBitmap(hashMap, transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows());
    }

    private static DoubleIntListHashMap extractHashMap(int colIndex, MatrixBlock rawBlock) {
        DoubleIntListHashMap distinctVals;
        block7: {
            int m;
            block6: {
                distinctVals = new DoubleIntListHashMap();
                m = rawBlock.getNumRows();
                if (rawBlock.getNumRows() != 1 && rawBlock.getNumColumns() != 1 || rawBlock.isInSparseFormat()) break block6;
                double[] values = rawBlock.getDenseBlockValues();
                if (values == null) break block7;
                for (int i = 0; i < values.length; ++i) {
                    double val = values[i];
                    if (val == 0.0) continue;
                    distinctVals.appendValue(val, i);
                }
                break block7;
            }
            if (!rawBlock.isInSparseFormat() && rawBlock.getDenseBlock().blockSize() == 1) {
                double[] values = rawBlock.getDenseBlockValues();
                int i = 0;
                for (int off = colIndex; off < rawBlock.getNumRows() * rawBlock.getNumColumns(); off += rawBlock.getNumColumns()) {
                    double val = values[off];
                    if (val != 0.0) {
                        distinctVals.appendValue(val, i);
                    }
                    ++i;
                }
            } else {
                for (int i = 0; i < m; ++i) {
                    double val = rawBlock.quickGetValue(i, colIndex);
                    if (val == 0.0) continue;
                    distinctVals.appendValue(val, i);
                }
            }
        }
        return distinctVals;
    }

    private static DoubleIntListHashMap extractHashMapTransposed(int colIndex, MatrixBlock rawBlock) {
        DoubleIntListHashMap distinctVals;
        block4: {
            int m;
            block5: {
                block3: {
                    distinctVals = new DoubleIntListHashMap();
                    m = rawBlock.getNumColumns();
                    if (!rawBlock.isInSparseFormat()) break block3;
                    SparseBlock a = rawBlock.getSparseBlock();
                    if (a == null || a.isEmpty(colIndex)) break block4;
                    int apos = a.pos(colIndex);
                    int alen = a.size(colIndex);
                    int[] aix = a.indexes(colIndex);
                    double[] avals = a.values(colIndex);
                    for (int j = apos; j < apos + alen; ++j) {
                        distinctVals.appendValue(avals[j], aix[j]);
                    }
                    break block4;
                }
                if (rawBlock.getNumRows() != 1 && rawBlock.getNumColumns() != 1 || rawBlock.isInSparseFormat()) break block5;
                double[] values = rawBlock.getDenseBlockValues();
                if (values == null) break block4;
                for (int i = 0; i < values.length; ++i) {
                    double val = values[i];
                    if (val == 0.0) continue;
                    distinctVals.appendValue(val, i);
                }
                break block4;
            }
            for (int i = 0; i < m; ++i) {
                double val = rawBlock.quickGetValue(colIndex, i);
                if (val == 0.0) continue;
                distinctVals.appendValue(val, i);
            }
        }
        return distinctVals;
    }

    private static ABitmap extractBitmapMultiColumns(int[] colIndices, MatrixBlock rawBlock, int numRows, boolean transposed, DblArrayIntListHashMap distinctVals) {
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(rawBlock, colIndices, transposed);
        DblArray cellVals = null;
        while ((cellVals = reader.nextRow()) != null) {
            distinctVals.appendValue(cellVals, reader.getCurrentRowIndex());
        }
        List<DblArrayIntListHashMap.DArrayIListEntry> mapEntries = distinctVals.extractValues();
        return BitmapEncoder.makeBitmap(mapEntries, numRows, colIndices.length);
    }

    private static ABitmap makeBitmap(List<DblArrayIntListHashMap.DArrayIListEntry> mapEntries, int numRows, int numCols) {
        if (!mapEntries.isEmpty()) {
            int numVals = mapEntries.size();
            double[][] values = new double[numVals][];
            IntArrayList[] offsetsLists = new IntArrayList[numVals];
            int bitmapIx = 0;
            for (DblArrayIntListHashMap.DArrayIListEntry val : mapEntries) {
                values[bitmapIx] = val.key.getData();
                offsetsLists[bitmapIx++] = val.value;
            }
            return new MultiColBitmap(offsetsLists, values, numRows);
        }
        return new MultiColBitmap(null, null, numRows);
    }

    private static Bitmap makeBitmap(DoubleIntListHashMap distinctVals, int numRows) {
        int numVals = distinctVals.size();
        if (numVals > 0) {
            double[] values = new double[numVals];
            IntArrayList[] offsetsLists = new IntArrayList[numVals];
            int bitmapIx = 0;
            for (DoubleIntListHashMap.DIListEntry val : distinctVals.extractValues()) {
                values[bitmapIx] = val.key;
                offsetsLists[bitmapIx++] = val.value;
            }
            return new Bitmap(offsetsLists, values, numRows);
        }
        return new Bitmap(null, null, numRows);
    }
}

