/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.utils.MemoryEstimates;

public abstract class ColGroupOffset
extends ColGroupValue {
    private static final long serialVersionUID = -4105103687174067602L;
    protected int[] _ptr;
    protected char[] _data;

    protected ColGroupOffset(int numRows) {
        super(numRows);
    }

    protected ColGroupOffset(int[] colIndices, int numRows, boolean zeros, ADictionary dict, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._zeros = zeros;
    }

    protected final int len(int k) {
        return this._ptr[k + 1] - this._ptr[k];
    }

    protected void createCompressedBitmaps(int numVals, int totalLen, char[][] lbitmaps) {
        this._ptr = new int[numVals + 1];
        this._data = new char[totalLen];
        int off = 0;
        for (int i = 0; i < numVals; ++i) {
            int len = lbitmaps[i].length;
            this._ptr[i] = off;
            System.arraycopy(lbitmaps[i], 0, this._data, off, len);
            off += len;
        }
        this._ptr[numVals] = totalLen;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._ptr.length));
        return size += MemoryEstimates.charArrayCost(this._data.length);
    }

    protected final void sumAllValues(double[] b, double[] c) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        double[] values = this.getValues();
        int i = 0;
        int off = 0;
        while (i < numCols) {
            LibMatrixMult.vectMultiplyAdd(b[i], values, c, off, 0, numVals);
            ++i;
            off += numVals;
        }
    }

    protected final double mxxValues(int bitmapIx, Builtin builtin, double[] values) {
        int numCols = this.getNumCols();
        int valOff = bitmapIx * numCols;
        double val = values[valOff];
        for (int i = 1; i < numCols; ++i) {
            val = builtin.execute(val, values[valOff + i]);
        }
        return val;
    }

    public char[] getBitmaps() {
        return this._data;
    }

    public int[] getBitmapOffsets() {
        return this._ptr;
    }

    public boolean hasZeros() {
        return this._zeros;
    }

    protected int[] computeOffsets(boolean[] ind) {
        int numOffsets = 0;
        for (int i = 0; i < ind.length; ++i) {
            numOffsets += ind[i] ? 1 : 0;
        }
        int[] ret = new int[numOffsets];
        int pos = 0;
        for (int i = 0; i < ind.length; ++i) {
            if (!ind[i]) continue;
            ret[pos++] = i;
        }
        return ret;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._ptr = new int[in.readInt()];
        for (int i = 0; i < this._ptr.length; ++i) {
            this._ptr[i] = in.readInt();
        }
        int totalLen = in.readInt();
        this._data = new char[totalLen];
        for (int i = 0; i < totalLen; ++i) {
            this._data[i] = in.readChar();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeInt(this._ptr.length);
        for (i = 0; i < this._ptr.length; ++i) {
            out.writeInt(this._ptr[i]);
        }
        out.writeInt(this._data.length);
        for (i = 0; i < this._data.length; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += 4L;
        ret += (long)(4 * this._ptr.length);
        ret += 4L;
        return ret += (long)(2 * this._data.length);
    }

    protected abstract boolean[] computeZeroIndicatorVector();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d ", "Pointers:", this._ptr.length));
        sb.append(Arrays.toString(this._ptr));
        return sb.toString();
    }

    protected static String charsToString(char[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int x = 0; x < data.length; ++x) {
            sb.append((int)data[x]);
            if (x == data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

