/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class MemoryCostEstimator
implements ICostEstimate {
    private static final long serialVersionUID = -1264988969161809465L;
    private final int nRows;
    private final double sparsity;

    public MemoryCostEstimator(int nRows, int nCols, double sparsity) {
        this.nRows = nRows;
        this.sparsity = sparsity;
    }

    @Override
    public double getUncompressedCost(CompressedSizeInfoColGroup g) {
        return MatrixBlock.estimateSizeInMemory(this.nRows, g.getColumns().length, this.sparsity);
    }

    @Override
    public double getCostOfColumnGroup(CompressedSizeInfoColGroup g) {
        if (g == null) {
            return Double.POSITIVE_INFINITY;
        }
        return g.getMinSize();
    }

    @Override
    public boolean shouldAnalyze(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        return true;
    }
}

