/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.spark_project.jetty.http.DateGenerator;
import org.spark_project.jetty.http.DateParser;
import org.spark_project.jetty.http.HttpField;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpHeaderValue;
import org.spark_project.jetty.util.ArrayTernaryTrie;
import org.spark_project.jetty.util.LazyList;
import org.spark_project.jetty.util.QuotedStringTokenizer;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.Trie;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private static final Pattern __splitter = Pattern.compile("\\s*,\\s*");
    public static final String __separators = ", \t";
    private final ArrayList<HttpField> _fields = new ArrayList(20);
    private static final Float __one = new Float("1.0");
    private static final Float __zero = new Float("0.0");
    private static final Trie<Float> __qualities = new ArrayTernaryTrie<Float>();

    public Collection<String> getFieldNamesCollection() {
        HashSet<String> list = new HashSet<String>(this._fields.size());
        for (HttpField f : this._fields) {
            if (f == null) continue;
            list.add(f.getName());
        }
        return list;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public int size() {
        return this._fields.size();
    }

    public HttpField getField(int i) {
        return this._fields.get(i);
    }

    @Override
    public Iterator<HttpField> iterator() {
        return this._fields.iterator();
    }

    public HttpField getField(HttpHeader header) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    public HttpField getField(String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public boolean contains(HttpHeader header, String value2) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != header || !this.contains(f, value2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name, String value2) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name) || !this.contains(f, value2)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(HttpField field, String value2) {
        String v = field.getValue();
        if (v == null) {
            return false;
        }
        if (value2.equalsIgnoreCase(v)) {
            return true;
        }
        String[] split = __splitter.split(v);
        for (int i = 0; split != null && i < split.length; ++i) {
            if (!value2.equals(split[i])) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getStringField(HttpHeader header) {
        return this.getStringField(header.asString());
    }

    public String get(HttpHeader header) {
        return this.getStringField(header.asString());
    }

    public String get(String header) {
        return this.getStringField(header);
    }

    public String getStringField(String name) {
        HttpField field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public List<String> getValuesList(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this._fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            list.add(f.getValue());
        }
        return list;
    }

    public Enumeration<String> getValues(final String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            final HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name) || f.getValue() == null) continue;
            final int first2 = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = f;
                    this.i = first2 + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._fields.size()) {
                            this.field = (HttpField)HttpFields.this._fields.get(this.i++);
                            if (!this.field.getName().equalsIgnoreCase(name) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() throws NoSuchElementException {
                    if (this.hasMoreElements()) {
                        String value2 = this.field.getValue();
                        this.field = null;
                        return value2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List empty2 = Collections.emptyList();
        return Collections.enumeration(empty2);
    }

    public Enumeration<String> getValues(String name, final String separators) {
        final Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value2 = (String)e.nextElement();
                    if (value2 == null) continue;
                    this.tok = new QuotedStringTokenizer(value2, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next2 = (String)this.tok.nextElement();
                if (next2 != null) {
                    next2 = next2.trim();
                }
                return next2;
            }
        };
    }

    public void put(HttpField field) {
        boolean put2 = false;
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (!f.isSame(field)) continue;
            if (put2) {
                this._fields.remove(i);
                continue;
            }
            this._fields.set(i, field);
            put2 = true;
        }
        if (!put2) {
            this._fields.add(field);
        }
    }

    public void put(String name, String value2) {
        if (value2 == null) {
            this.remove(name);
        } else {
            this.put(new HttpField(name, value2));
        }
    }

    public void put(HttpHeader header, HttpHeaderValue value2) {
        this.put(header, value2.toString());
    }

    public void put(HttpHeader header, String value2) {
        if (value2 == null) {
            this.remove(header);
        } else {
            this.put(new HttpField(header, value2));
        }
    }

    public void put(String name, List<String> list) {
        this.remove(name);
        for (String v : list) {
            if (v == null) continue;
            this.add(name, v);
        }
    }

    public void add(String name, String value2) throws IllegalArgumentException {
        if (value2 == null) {
            return;
        }
        HttpField field = new HttpField(name, value2);
        this._fields.add(field);
    }

    public void add(HttpHeader header, HttpHeaderValue value2) throws IllegalArgumentException {
        this.add(header, value2.toString());
    }

    public void add(HttpHeader header, String value2) throws IllegalArgumentException {
        if (value2 == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, value2);
        this._fields.add(field);
    }

    public HttpField remove(HttpHeader name) {
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (f.getHeader() != name) continue;
            return this._fields.remove(i);
        }
        return null;
    }

    public HttpField remove(String name) {
        int i = this._fields.size();
        while (i-- > 0) {
            HttpField f = this._fields.get(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return this._fields.remove(i);
        }
        return null;
    }

    public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : StringUtil.toLong(field.getValue());
    }

    public long getDateField(String name) {
        HttpField field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = DateParser.parseDate(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(HttpHeader name, long value2) {
        String v = Long.toString(value2);
        this.put(name, v);
    }

    public void putLongField(String name, long value2) {
        String v = Long.toString(value2);
        this.put(name, v);
    }

    public void putDateField(HttpHeader name, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name, d);
    }

    public void putDateField(String name, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name, d);
    }

    public void addDateField(String name, long date) {
        String d = DateGenerator.formatDate(date);
        this.add(name, d);
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this._fields) {
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn(e);
            return e.toString();
        }
    }

    public void clear() {
        this._fields.clear();
    }

    public void add(HttpField field) {
        this._fields.add(field);
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values2 = fields.getValues(name);
            while (values2.hasMoreElements()) {
                this.add(name, values2.nextElement());
            }
        }
    }

    public static String valueParameters(String value2, Map<String, String> parameters) {
        if (value2 == null) {
            return null;
        }
        int i = value2.indexOf(59);
        if (i < 0) {
            return value2;
        }
        if (parameters == null) {
            return value2.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value2.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value2.substring(0, i).trim();
    }

    public static Float getQuality(String value2) {
        Float q;
        Float q2;
        if (value2 == null) {
            return __zero;
        }
        int qe = value2.indexOf(";");
        if (qe++ < 0 || qe == value2.length()) {
            return __one;
        }
        if (value2.charAt(qe++) == 'q' && (q2 = __qualities.get(value2, ++qe, value2.length() - qe)) != null) {
            return q2;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        HttpFields.valueParameters(value2, params);
        String qs = (String)params.get("q");
        if (qs == null) {
            qs = "*";
        }
        if ((q = __qualities.get(qs)) == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List<String> qualityList(Enumeration<String> e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.emptyList();
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, v);
            qual = LazyList.add(qual, q);
        }
        List<String> vl = LazyList.getList(list, false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                String tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    static {
        __qualities.put("*", __one);
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", new Float("0.9"));
        __qualities.put("0.8", new Float("0.8"));
        __qualities.put("0.7", new Float("0.7"));
        __qualities.put("0.66", new Float("0.66"));
        __qualities.put("0.6", new Float("0.6"));
        __qualities.put("0.5", new Float("0.5"));
        __qualities.put("0.4", new Float("0.4"));
        __qualities.put("0.33", new Float("0.33"));
        __qualities.put("0.3", new Float("0.3"));
        __qualities.put("0.2", new Float("0.2"));
        __qualities.put("0.1", new Float("0.1"));
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
    }
}

