/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ComEstExact
extends AComEst {
    public ComEstExact(MatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
    }

    @Override
    public CompressedSizeInfoColGroup getColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        IEncode map = EncodingFactory.createFromMatrixBlock(this._data, this._cs.transposed, colIndexes);
        if (map instanceof EmptyEncoding) {
            return new CompressedSizeInfoColGroup(colIndexes, this.getNumRows(), AColGroup.CompressionType.EMPTY);
        }
        return this.getFacts(map, colIndexes);
    }

    @Override
    public CompressedSizeInfoColGroup getDeltaColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        IEncode map = EncodingFactory.createFromMatrixBlockDelta(this._data, this._cs.transposed, colIndexes);
        return this.getFacts(map, colIndexes);
    }

    @Override
    protected CompressedSizeInfoColGroup combine(IColIndex combinedColumns, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int maxDistinct) {
        IEncode map = g1.getMap().combine(g2.getMap());
        return this.getFacts(map, combinedColumns);
    }

    protected CompressedSizeInfoColGroup getFacts(IEncode map, IColIndex colIndexes) {
        int _numRows = this.getNumRows();
        EstimationFactors em = map.extractFacts(_numRows, this._data.getSparsity(), this._data.getSparsity(), this._cs);
        return new CompressedSizeInfoColGroup(colIndexes, em, this._cs.validCompressions, map);
    }

    @Override
    protected int worstCaseUpperBound(IColIndex columns) {
        return this.getNumRows();
    }
}

