/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.DMLCompressionException;

public class IntArrayList {
    private static final int INIT_CAPACITY = 4;
    private static final int RESIZE_FACTOR = 2;
    private int[] _data;
    private int _size;

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(int initialSize) {
        this._data = new int[initialSize];
        this._size = 0;
    }

    public IntArrayList(int[] values) {
        if (values == null) {
            throw new DMLCompressionException("Invalid initialization of IntArrayList");
        }
        this._data = values;
        this._size = values.length;
    }

    public int size() {
        return this._size;
    }

    public void appendValue(int value) {
        if (this._size + 1 > this._data.length) {
            this.resize();
        }
        this._data[this._size] = value;
        ++this._size;
    }

    public void appendValue(IntArrayList value) {
        if (this._size + value._size >= this._data.length) {
            this._data = Arrays.copyOf(this._data, this._size + value._size);
        }
        System.arraycopy(value._data, 0, this._data, this._size, value._size);
        this._size += value._size;
    }

    public int[] extractValues() {
        return this._data;
    }

    public int get(int index) {
        return this._data[index];
    }

    public int[] extractValues(boolean trim) {
        if (trim) {
            if (this._data.length == this._size) {
                return this._data;
            }
            return Arrays.copyOfRange(this._data, 0, this._size);
        }
        return this._data;
    }

    private void resize() {
        this._data = Arrays.copyOf(this._data, this._data.length * 2);
    }

    public void reset() {
        this._size = 0;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this._size == 0) {
            return "[]";
        }
        sb.append("[");
        for (i = 0; i < this._size - 1; ++i) {
            sb.append(this._data[i]).append(", ");
        }
        sb.append(this._data[i]);
        sb.append("]");
        return sb.toString();
    }
}

