/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.models;

import java.time.LocalDateTime;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseModel;

public class UtilizationModel
extends BaseModel {
    private static final long serialVersionUID = 6984053518916899551L;
    public Long workerId;
    public LocalDateTime timestamp;
    public double cpuUsage;
    public double memoryUsage;
    private static final String JsonFormat = "{\"timestamp\": \"%s\",\"cpuUsage\": %.2f,\"memoryUsage\": %.2f}";

    public UtilizationModel() {
        this(-1L);
    }

    private UtilizationModel(Long id) {
        this.id = id;
    }

    public UtilizationModel(double cpuUsage, double memoryUsage) {
        this(-1L, -1L, LocalDateTime.now(), cpuUsage, memoryUsage);
    }

    public UtilizationModel(Long workerId, double cpuUsage, double memoryUsage) {
        this(-1L, workerId, LocalDateTime.now(), cpuUsage, memoryUsage);
    }

    public UtilizationModel(Long id, Long workerId, LocalDateTime timestamp, double cpuUsage, double memoryUsage) {
        this.id = id;
        this.workerId = workerId;
        this.timestamp = timestamp;
        this.cpuUsage = cpuUsage;
        this.memoryUsage = memoryUsage;
    }

    public String toString() {
        return String.format(JsonFormat, this.timestamp, this.cpuUsage, this.memoryUsage);
    }
}

