/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.hops.fedplanner.PrivacyConstraintLoader;
import org.apache.sysds.hops.fedplanner.PrivacyConstraintLoaderMock;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.parser.DMLProgram;

public class IPAPassRewriteFederatedPlan
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        String planner = ConfigurationManager.getDMLConfig().getTextValue("sysds.federated.planner");
        return OptimizerUtils.FEDERATED_COMPILATION || FTypes.FederatedPlanner.isCompiled(planner);
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        String splanner = ConfigurationManager.getDMLConfig().getTextValue("sysds.federated.planner");
        this.loadPrivacyConstraints(prog, splanner);
        this.generatePlan(prog, fgraph, fcallSizes, splanner);
        return false;
    }

    private void loadPrivacyConstraints(DMLProgram prog, String splanner) {
        if (FTypes.FederatedPlanner.isCompiled(splanner)) {
            String privMock = ConfigurationManager.getDMLConfig().getTextValue("sysds.federated.priv_mock");
            if (privMock == null) {
                new PrivacyConstraintLoader().loadConstraints(prog);
            } else if (privMock.equals("mock_all")) {
                LOG.trace((Object)"Privacy Constraint retrieval mocked. Ignoring retrieval and propagation of constraints during compilation.");
            } else {
                LOG.trace((Object)("Mocking privacy constraints with privacy level " + privMock));
                new PrivacyConstraintLoaderMock(privMock).loadConstraints(prog);
            }
        }
    }

    private void generatePlan(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes, String splanner) {
        FTypes.FederatedPlanner planner = FTypes.FederatedPlanner.isCompiled(splanner) ? FTypes.FederatedPlanner.valueOf(splanner.toUpperCase()) : FTypes.FederatedPlanner.COMPILE_COST_BASED;
        planner.getPlanner().rewriteProgram(prog, fgraph, fcallSizes);
    }
}

