/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public class CheckedConstraintsLog {
    private static final Map<PrivacyConstraint.PrivacyLevel, LongAdder> loadedConstraintsTotal = new EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder>(PrivacyConstraint.PrivacyLevel.class);
    private static final Map<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraintsTotal;
    private static final BiFunction<LongAdder, LongAdder, LongAdder> mergeLongAdders;

    public static void addCheckedConstraints(Map<PrivacyConstraint.PrivacyLevel, LongAdder> checkedConstraints) {
        if (checkedConstraints != null) {
            checkedConstraints.forEach((key, value) -> checkedConstraintsTotal.merge((PrivacyConstraint.PrivacyLevel)((Object)key), (LongAdder)value, mergeLongAdders));
        }
    }

    public static void addLoadedConstraint(PrivacyConstraint.PrivacyLevel level) {
        if (level != null) {
            loadedConstraintsTotal.get((Object)level).increment();
        }
    }

    public static void reset() {
        checkedConstraintsTotal.clear();
        loadedConstraintsTotal.replaceAll((k, v) -> new LongAdder());
    }

    public static Map<PrivacyConstraint.PrivacyLevel, LongAdder> getCheckedConstraints() {
        return checkedConstraintsTotal;
    }

    public static Map<PrivacyConstraint.PrivacyLevel, LongAdder> getLoadedConstraints() {
        return loadedConstraintsTotal;
    }

    public static String display() {
        StringBuilder sb = new StringBuilder();
        sb.append("Checked Privacy Constraints:\n");
        checkedConstraintsTotal.forEach((k, v) -> sb.append(String.format("\t%s: %s\n", k, v)));
        sb.append("Loaded Privacy Constraints:\n");
        loadedConstraintsTotal.forEach((k, v) -> sb.append(String.format("\t%s: %s\n", k, v)));
        return sb.toString();
    }

    static {
        for (PrivacyConstraint.PrivacyLevel level : PrivacyConstraint.PrivacyLevel.values()) {
            loadedConstraintsTotal.put(level, new LongAdder());
        }
        checkedConstraintsTotal = new EnumMap<PrivacyConstraint.PrivacyLevel, LongAdder>(PrivacyConstraint.PrivacyLevel.class);
        mergeLongAdders = (v1, v2) -> {
            v1.add(v2.longValue());
            return v1;
        };
    }
}

