/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockDRB;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class DenseBlockFP64DEDUP
extends DenseBlockDRB {
    private static final long serialVersionUID = -4012376952006079198L;
    private double[][] _data;
    private int _distinct = 0;
    private int _emb_size = 0;
    private int _embPerRow = 0;

    public void setDistinct(int d) {
        this._distinct = d;
    }

    public void setEmbeddingSize(int s) {
        this._emb_size = s;
        if (this._odims[0] % this._emb_size != 0) {
            throw new RuntimeException("[Error] DedupDenseBlock: ncols[=" + this._odims[0] + "] % emb_size[=" + this._emb_size + "] != 0");
        }
        this._embPerRow = this._odims[0] / this._emb_size;
    }

    protected DenseBlockFP64DEDUP(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    public int getNrDistinctRows() {
        return this._distinct;
    }

    public int getNrEmbsPerRow() {
        return this._embPerRow;
    }

    public int getEmbSize() {
        return this._emb_size;
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new double[length][];
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        if (rlen > this._rlen) {
            this.allocateBlock(0, rlen);
        } else {
            if (this._data == null) {
                this.allocateBlock(0, rlen);
            }
            if (v == 0.0) {
                for (int i = 0; i < rlen; ++i) {
                    this._data[i] = null;
                }
            } else {
                throw new NotImplementedException("Reset of DedupBlock with constant value is supported");
            }
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public void resetNoFill(int rlen, int[] odims) {
        if (this._data == null || rlen > this._rlen) {
            this._data = new double[rlen][];
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    public void resetNoFillDedup(int rlen, int embsPerRow) {
        if (this._data == null || rlen > this._rlen) {
            this._data = new double[rlen * embsPerRow][];
        }
        this._embPerRow = embsPerRow;
        this._rlen = rlen;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.FP64 == vt;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length : -1L;
    }

    @Override
    public long countNonZeros() {
        long nnz = 0L;
        HashMap<double[], Long> cache = new HashMap<double[], Long>();
        for (int i = 0; i < this._rlen; ++i) {
            double[] row = this._data[i];
            if (row == null) continue;
            Long count = cache.getOrDefault(row, null);
            if (count == null) {
                count = this.countNonZeros(i);
                cache.put(row, count);
            }
            nnz += count.longValue();
        }
        this._distinct = cache.size();
        return nnz;
    }

    @Override
    public int countNonZeros(int r) {
        return this._data[r] == null ? 0 : UtilFunctions.computeNnz(this._data[r], 0, this._odims[0]);
    }

    @Override
    public long countNonZeros(int rl, int ru, int ol, int ou) {
        long nnz = 0L;
        HashMap<double[], Long> cache = new HashMap<double[], Long>();
        for (int i = rl; i < ru; ++i) {
            double[] row = this._data[i];
            if (row == null) continue;
            Long count = cache.getOrDefault(row, null);
            if (count == null) {
                count = UtilFunctions.computeNnz(this._data[i], ol, ou);
                cache.put(row, count);
            }
            nnz += count.longValue();
        }
        return nnz;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        int nnz = 0;
        int row_start = (int)Math.floor((double)start / (double)this._odims[0]);
        int col_start = start % this._odims[0];
        for (int i = 0; i < length; ++i) {
            if (this._data[row_start] == null) {
                i += this._odims[0] - 1 - col_start;
                col_start = 0;
                ++row_start;
                continue;
            }
            nnz += this._data[row_start][col_start] != 0.0 ? 1 : 0;
            if (++col_start != this._odims[0]) continue;
            col_start = 0;
            ++row_start;
        }
        return nnz;
    }

    @Override
    public int numBlocks() {
        int blocksize = this.blockSize();
        if (blocksize < this._rlen) {
            int numBlocks = this._rlen / blocksize;
            if (this._rlen % blocksize > 0) {
                ++numBlocks;
            }
            return numBlocks;
        }
        return 1;
    }

    @Override
    public int blockSize() {
        int blocksize = Integer.MAX_VALUE / this._odims[0];
        return Math.min(blocksize, this._rlen);
    }

    @Override
    public int blockSize(int bix) {
        int blocksize = this.blockSize();
        return Math.min(blocksize, this._rlen - bix * blocksize);
    }

    @Override
    public boolean isContiguous() {
        return this.numBlocks() == 1;
    }

    @Override
    public boolean isContiguous(int rl, int ru) {
        return this.index(rl) == this.index(ru);
    }

    @Override
    public int pos(int r) {
        return r % this.blockSize() * this._odims[0];
    }

    @Override
    public int pos(int r, int c) {
        return r % this.blockSize() * this._odims[0] + c;
    }

    @Override
    public int pos(int[] ix) {
        int pos = this.pos(ix[0]);
        pos += ix[ix.length - 1];
        for (int i = 1; i < ix.length - 1; ++i) {
            pos += ix[i] * this._odims[i];
        }
        return pos;
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(this.index(r));
    }

    @Override
    public double[] valuesAt(int bix) {
        int blocksize = this.blockSize(bix);
        int blocksizeOther = this.blockSize();
        double[] out = new double[this._odims[0] * blocksize];
        if (this._data != null) {
            for (int i = 0; i < blocksize; ++i) {
                for (int j = 0; j < this._embPerRow; ++j) {
                    int posInDedup = i * this._embPerRow + j;
                    int posInDense = posInDedup * this._emb_size;
                    if (this._data[posInDedup += bix * blocksizeOther * this._embPerRow] == null) continue;
                    System.arraycopy(this._data[posInDedup], 0, out, posInDense, this._emb_size);
                }
            }
        }
        return out;
    }

    @Override
    public int index(int r) {
        return r / this.blockSize();
    }

    @Override
    public int size(int bix) {
        return this.blockSize(bix) * this._odims[0];
    }

    @Override
    public void incr(int r, int c) {
        this.incr(r, c, 1.0);
    }

    public void createDeepCopyOfEmbedding(int pos) {
        if (this._data[pos] == null) {
            this._data[pos] = new double[this._emb_size];
        } else {
            double[] tmp = new double[this._emb_size];
            System.arraycopy(this._data[pos], 0, tmp, 0, this._emb_size);
            this._data[pos] = tmp;
        }
    }

    @Override
    public void incr(int r, int c, double delta) {
        int roffset = c / this._emb_size;
        int coffset = c % this._emb_size;
        this.createDeepCopyOfEmbedding(r * this._embPerRow + roffset);
        double[] dArray = this._data[r * this._embPerRow + roffset];
        int n = coffset;
        dArray[n] = dArray[n] + delta;
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        int roffset = fromIndex / this._emb_size;
        int coffset = fromIndex % this._emb_size;
        int r2offset = fromIndex / this._emb_size;
        int c2offset = fromIndex % this._emb_size;
        int blockoffset = bix * this.blockSize();
        int c = coffset;
        int cmax = this._emb_size;
        int rmax = r2offset;
        if (c2offset != 0) {
            ++rmax;
        }
        for (int r = roffset; r < rmax; ++r) {
            this.createDeepCopyOfEmbedding(blockoffset + roffset);
            if (r == r2offset) {
                cmax = c2offset;
            }
            while (c < cmax) {
                this._data[blockoffset + r][c] = v;
                ++c;
            }
            c = 0;
        }
    }

    @Override
    public void fillRow(int r, double v) {
        throw new NotImplementedException();
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this.set(bix, ix, v);
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        int roffset = c / this._emb_size;
        int coffset = c % this._emb_size;
        this.createDeepCopyOfEmbedding(r * this._embPerRow + roffset);
        this._data[r * this._embPerRow + roffset][coffset] = v;
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        if (this._embPerRow == 1) {
            this._data[r] = v;
        } else {
            for (int i = 0; i < this._embPerRow; ++i) {
                this.createDeepCopyOfEmbedding(r * this._embPerRow + i);
                System.arraycopy(v, i * this._emb_size, this._data[r * this._embPerRow + i], 0, this._emb_size);
            }
        }
        return this;
    }

    public DenseBlock setDedupDirectly(int r, double[] v) {
        this._data[r] = v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        throw new NotImplementedException();
    }

    @Override
    public DenseBlock set(int rl, int ru, int ol, int ou, DenseBlock db) {
        if (!(db instanceof DenseBlockFP64DEDUP)) {
            throw new NotImplementedException();
        }
        HashMap<double[], double[]> cache = new HashMap<double[], double[]>();
        int len = ou - ol;
        int i = rl;
        int ix1 = 0;
        while (i < ru) {
            double[] row = db.values(ix1);
            double[] newRow = (double[])cache.get(row);
            if (newRow == null) {
                newRow = new double[len];
                System.arraycopy(row, 0, newRow, 0, len);
                cache.put(row, newRow);
            }
            this.set(i, newRow);
            ++i;
            ++ix1;
        }
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        return this.set(ix[0], this.pos(ix), v);
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        return this.set(ix[0], this.pos(ix), v);
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        return this.set(ix[0], this.pos(ix), Double.parseDouble(v));
    }

    public double[] getDedupDirectly(int pos) {
        return this._data[pos];
    }

    @Override
    public double get(int r, int c) {
        if (this._embPerRow == 1) {
            return this._data[r][c];
        }
        int roffset = c / this._emb_size;
        int coffset = c % this._emb_size;
        if (this._data[r * this._embPerRow + roffset] == null) {
            return 0.0;
        }
        return this._data[r * this._embPerRow + roffset][coffset];
    }

    @Override
    public double get(int[] ix) {
        return this.get(ix[0], this.pos(ix));
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this.get(ix[0], this.pos(ix)));
    }

    @Override
    public long getLong(int[] ix) {
        return UtilFunctions.toLong(this.get(ix[0], this.pos(ix)));
    }

    public long estimateMemory() {
        return DenseBlockFP64DEDUP.estimateMemory(this._rlen, this._odims[0], this._distinct);
    }

    public static long estimateMemory(int rows, int cols, int duplicates) {
        return DenseBlockFP64DEDUP.estimateMemory((long)rows, (long)cols, (long)duplicates);
    }

    public static long estimateMemory(long rows, long cols, long duplicates) {
        return (long)DenseBlock.estimateMemory(rows, cols) + (long)MemoryEstimates.doubleArrayCost(cols) * duplicates + (long)MemoryEstimates.objectArrayCost(rows);
    }
}

