/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.util.SortUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class SparseBlockDCSR
extends SparseBlock {
    private static final long serialVersionUID = 456844244252549431L;
    private static final Log LOG = LogFactory.getLog((String)SparseBlockDCSR.class.getName());
    private int[] _rowidx = null;
    private int[] _rowptr = null;
    private int[] _colidx = null;
    private double[] _values = null;
    private int _size = 0;
    private int _rlen = 0;
    private int _nnzr = 0;

    public SparseBlockDCSR(int rlen) {
        this(rlen, 4);
    }

    public SparseBlockDCSR(int rlen, int capacity) {
        LOG.warn((Object)"Allocating a DCSR-block using row-length. This will lead to significant overhead!");
        LOG.warn((Object)"If you want to initialize a sparse block using rlen, choose SparseBlockCSR instead!");
        this._rowidx = new int[rlen];
        this._rowptr = new int[rlen + 1];
        this._colidx = new int[capacity];
        this._values = new double[capacity];
        this._rlen = rlen;
        this._size = 0;
        this._nnzr = 0;
    }

    public SparseBlockDCSR(int rlen, int capacity, int size, int nnzr) {
        LOG.warn((Object)"Allocating a DCSR-block using row-length. This will lead to significant overhead!");
        this._rowidx = new int[rlen];
        this._rowptr = new int[rlen + 1];
        this._colidx = new int[capacity];
        this._values = new double[capacity];
        this._rlen = rlen;
        this._size = size;
        this._nnzr = nnzr;
    }

    public SparseBlockDCSR(int[] rowIdx, int[] rowPtr, int[] colIdx, double[] values, int rlen, int nnz, int nnzr) {
        LOG.warn((Object)"Allocating a DCSR-block using row-length. This will lead to significant overhead!");
        this._rowidx = rowIdx;
        this._rowptr = rowPtr;
        this._colidx = colIdx;
        this._values = values;
        this._rlen = rlen;
        this._size = nnz;
        this._nnzr = nnzr;
    }

    public SparseBlockDCSR(SparseBlock sblock) {
        long size = sblock.size();
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("SparseBlockDCSR supports nnz<=Integer.MAX_VALUE but got " + size);
        }
        if (sblock instanceof SparseBlockDCSR) {
            SparseBlockDCSR ocsr = (SparseBlockDCSR)sblock;
            this._rowidx = Arrays.copyOf(ocsr._rowidx, ocsr._nnzr);
            this._rowptr = Arrays.copyOf(ocsr._rowptr, ocsr._nnzr + 1);
            this._colidx = Arrays.copyOf(ocsr._colidx, ocsr._size);
            this._values = Arrays.copyOf(ocsr._values, ocsr._size);
            this._rlen = ocsr._rlen;
            this._nnzr = ocsr._nnzr;
            this._size = ocsr._size;
        } else if (sblock instanceof SparseBlockCSR) {
            int rlen = sblock.numRows();
            SparseBlockCSR ocsr = (SparseBlockCSR)sblock;
            this._rowidx = IntStream.range(0, rlen).filter(rowIdx -> !sblock.isEmpty(rowIdx)).toArray();
            this._rowptr = new int[this._rowidx.length + 1];
            this._colidx = Arrays.copyOf(ocsr.indexes(), (int)ocsr.size());
            this._values = Arrays.copyOf(ocsr.values(), (int)ocsr.size());
            this._rlen = rlen;
            this._nnzr = this._rowidx.length;
            this._size = (int)ocsr.size();
            int vpos = 0;
            for (int i = 0; i < this._rowidx.length; ++i) {
                this._rowptr[i + 1] = vpos += sblock.size(this._rowidx[i]);
            }
        } else {
            int rlen = sblock.numRows();
            this._rowidx = IntStream.range(0, rlen).filter(rowIdx -> !sblock.isEmpty(rowIdx)).toArray();
            this._rowptr = new int[this._rowidx.length + 1];
            this._colidx = new int[(int)size];
            this._values = new double[(int)size];
            this._rlen = rlen;
            this._nnzr = this._rowidx.length;
            this._size = (int)size;
            int vpos = 0;
            int rpos = 1;
            for (int rowIdx2 : this._rowidx) {
                int apos = sblock.pos(rowIdx2);
                int alen = sblock.size(rowIdx2);
                int[] aix = sblock.indexes(rowIdx2);
                double[] avals = sblock.values(rowIdx2);
                System.arraycopy(aix, apos, this._colidx, vpos, alen);
                System.arraycopy(avals, apos, this._values, vpos, alen);
                this._rowptr[rpos++] = vpos += alen;
            }
        }
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        double lnnz = Math.max(4.0, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 16.0;
        size += 16.0;
        size += MemoryEstimates.intArrayCost(nrows);
        size += MemoryEstimates.intArrayCost(nrows + 1L);
        size += MemoryEstimates.intArrayCost((long)lnnz);
        return (long)Math.min(size += MemoryEstimates.doubleArrayCost((long)lnnz), 9.223372036854776E18);
    }

    @Override
    public long getExactSizeInMemory() {
        double size = 16.0;
        size += 16.0;
        size += MemoryEstimates.intArrayCost(this._rowidx.length);
        size += MemoryEstimates.intArrayCost(this._rowptr.length);
        size += MemoryEstimates.intArrayCost(this._colidx.length);
        return (long)Math.min(size += MemoryEstimates.doubleArrayCost(this._values.length), 9.223372036854776E18);
    }

    @Override
    public void allocate(int r) {
    }

    @Override
    public void allocate(int r, int nnz) {
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
    }

    @Override
    public void compact(int r) {
    }

    @Override
    public int numRows() {
        return this._rlen;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public boolean isAllocated(int r) {
        return true;
    }

    @Override
    public void reset() {
        if (this._size > 0) {
            this._size = 0;
            this._nnzr = 0;
            this._rlen = 0;
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        if (this._size > 0) {
            this._size = 0;
            this._nnzr = 0;
            this._rlen = 0;
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        this.deleteIndexRange(r, 0, Integer.MAX_VALUE);
    }

    @Override
    public long size() {
        return this._size;
    }

    @Override
    public int size(int r) {
        int idx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (idx < 0) {
            return 0;
        }
        return this._rowptr[idx + 1] - this._rowptr[idx];
    }

    @Override
    public long size(int rl, int ru) {
        int upperIdx;
        int lowerIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, rl);
        if (lowerIdx < 0) {
            lowerIdx = -lowerIdx - 1;
        }
        if ((upperIdx = Arrays.binarySearch(this._rowidx, lowerIdx, this._nnzr, ru)) < 0) {
            upperIdx = -upperIdx - 1;
        }
        return this._rowptr[upperIdx] - this._rowptr[lowerIdx];
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        int uRowIdx;
        long nnz = 0L;
        int lRowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, rl);
        if (lRowIdx < 0) {
            lRowIdx = -lRowIdx - 1;
        }
        if ((uRowIdx = Arrays.binarySearch(this._rowidx, lRowIdx, this._nnzr, ru)) < 0) {
            uRowIdx = -uRowIdx - 1;
        }
        for (int rowIdx = lRowIdx; rowIdx < uRowIdx; ++rowIdx) {
            int cuIdx;
            int clIdx = Arrays.binarySearch(this._colidx, this._rowptr[rowIdx], this._rowptr[rowIdx + 1], cl);
            if (clIdx < 0) {
                clIdx = -clIdx - 1;
            }
            if ((cuIdx = Arrays.binarySearch(this._colidx, clIdx, this._rowptr[rowIdx + 1], cu)) < 0) {
                cuIdx = -cuIdx - 1;
            }
            nnz += (long)(cuIdx - clIdx);
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        return this.size(r) == 0;
    }

    @Override
    public int[] indexes(int r) {
        return this._colidx;
    }

    @Override
    public double[] values(int r) {
        return this._values;
    }

    @Override
    public int pos(int r) {
        int idx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (idx < 0) {
            idx = Math.max(-idx - 2, 0);
        }
        return this._rowptr[idx];
    }

    @Override
    public boolean set(int r, int c, double v) {
        boolean colExists;
        boolean rowExists;
        int rowIndex = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        boolean bl = rowExists = rowIndex >= 0;
        if (!rowExists) {
            if (v == 0.0) {
                return false;
            }
            int rowInsertionIndex = -rowIndex - 1;
            int tmp = this._rowptr[rowInsertionIndex];
            this.insertRow(rowInsertionIndex, r, tmp);
            this.incrRowPtr(rowInsertionIndex + 1);
            this.insertCol(tmp, c, v);
            return true;
        }
        int pos = this._rowptr[rowIndex];
        int len = this._rowptr[rowIndex + 1] - pos;
        int index = Arrays.binarySearch(this._colidx, pos, pos + len, c);
        boolean bl2 = colExists = index >= 0;
        if (v != 0.0) {
            if (colExists) {
                this._values[index] = v;
                return false;
            }
            this.insertCol(-index - 1, c, v);
            this.incrRowPtr(rowIndex + 1);
            return true;
        }
        if (!colExists) {
            return false;
        }
        if (len == 1) {
            this.deleteRow(rowIndex);
            --rowIndex;
        }
        this.incrRowPtr(rowIndex + 1, -1);
        this.deleteCol(index);
        return true;
    }

    @Override
    public boolean add(int r, int c, double v) {
        double oldValue = this.get(r, c);
        if (v == 0.0) {
            return false;
        }
        return this.set(r, c, oldValue + v);
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        boolean rowExists;
        int newRowSize = row.size();
        int rowIndex = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        boolean bl = rowExists = rowIndex >= 0;
        if (!rowExists) {
            if (newRowSize == 0) {
                return;
            }
            int rowInsertionIndex = -rowIndex - 1;
            int tmp = this._rowptr[rowInsertionIndex];
            this.insertRow(rowInsertionIndex, r, tmp);
            this.incrRowPtr(rowInsertionIndex + 1, newRowSize);
            this.insertCols(tmp, row.indexes(), row.values(), 0, 0, newRowSize);
            return;
        }
        int pos = this._rowptr[rowIndex];
        int oldRowSize = this._rowptr[rowIndex + 1] - pos;
        if (newRowSize == 0) {
            this.deleteRow(rowIndex);
            this.incrRowPtr(rowIndex, -oldRowSize);
            this.deleteCols(pos, oldRowSize);
            return;
        }
        this.incrRowPtr(rowIndex + 1, newRowSize - oldRowSize);
        this.insertCols(pos, row.indexes(), row.values(), oldRowSize);
    }

    @Override
    public void append(int r, int c, double v) {
        this.set(r, c, v);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        int cuIdx;
        int rowEnd;
        int rowStart;
        int clIdx;
        int lnnz = UtilFunctions.computeNnz(v, vix, vlen);
        if (lnnz == 0) {
            this.deleteIndexRange(r, cl, cu);
            return;
        }
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            rowIdx = -rowIdx - 1;
            this.insertRow(rowIdx, r, this._rowptr[rowIdx]);
        }
        if ((clIdx = Arrays.binarySearch(this._colidx, rowStart = this._rowptr[rowIdx], rowEnd = this._rowptr[rowIdx + 1], cl)) < 0) {
            clIdx = -clIdx - 1;
        }
        if ((cuIdx = Arrays.binarySearch(this._colidx, clIdx, rowEnd, cu)) < 0) {
            cuIdx = -cuIdx - 1;
        }
        int oldnnz = cuIdx - clIdx;
        this.allocateCols(clIdx, lnnz, oldnnz);
        this.incrRowPtr(rowIdx + 1, lnnz - oldnnz);
        int insertionIndex = clIdx;
        for (int i = vix; i < vix + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this._colidx[insertionIndex] = cl + i - vix;
            this._values[insertionIndex] = v[i];
            ++insertionIndex;
        }
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        int cuIdx;
        int rowEnd;
        int rowStart;
        int clIdx;
        if (vlen == 0) {
            this.deleteIndexRange(r, cl, cu);
            return;
        }
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            rowIdx = -rowIdx - 1;
            this.insertRow(rowIdx, r, this._rowptr[rowIdx]);
        }
        if ((clIdx = Arrays.binarySearch(this._colidx, rowStart = this._rowptr[rowIdx], rowEnd = this._rowptr[rowIdx + 1], cl)) < 0) {
            clIdx = -clIdx - 1;
        }
        if ((cuIdx = Arrays.binarySearch(this._colidx, clIdx, rowEnd, cu)) < 0) {
            cuIdx = -cuIdx - 1;
        }
        int oldnnz = cuIdx - clIdx;
        this.allocateCols(clIdx, vlen, oldnnz);
        this.incrRowPtr(rowIdx + 1, vlen - oldnnz);
        int insertionIndex = clIdx;
        for (int i = vpos; i < vpos + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this._colidx[insertionIndex] = cl - vix[i];
            this._values[insertionIndex] = v[i];
            ++insertionIndex;
        }
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        int end;
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            return;
        }
        int nnz = this._rowptr[rowIdx + 1] - this._rowptr[rowIdx];
        int start = Arrays.binarySearch(this._colidx, this._rowptr[rowIdx], this._rowptr[rowIdx + 1], cl);
        if (start < 0) {
            start = -start - 1;
        }
        if ((end = Arrays.binarySearch(this._colidx, start, this._rowptr[rowIdx + 1], cu)) < 0) {
            end = -end - 1;
        }
        if (end - start <= 0) {
            return;
        }
        if (nnz == end - start) {
            this.deleteRow(rowIdx);
            --rowIdx;
        }
        System.arraycopy(this._colidx, end, this._colidx, start, this._size - end);
        System.arraycopy(this._values, end, this._values, start, this._size - end);
        this._size -= end - start;
        this.incrRowPtr(rowIdx + 1, start - end);
    }

    @Override
    public void sort() {
        for (int i = 0; i < this._rowidx.length; ++i) {
            this.sortFromRowIndex(i);
        }
    }

    @Override
    public void sort(int r) {
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx >= 0) {
            this.sortFromRowIndex(rowIdx);
        }
    }

    private void sortFromRowIndex(int rowIndex) {
        int pos = this._rowptr[rowIndex];
        int len = this._rowptr[rowIndex + 1] - pos;
        if (!SortUtils.isSorted(pos, pos + len, this._colidx)) {
            SortUtils.sortByIndex(pos, pos + len, this._colidx, this._values);
        }
    }

    @Override
    public double get(int r, int c) {
        int rowIndex = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIndex < 0) {
            return 0.0;
        }
        int pos = this._rowptr[rowIndex];
        int len = this._rowptr[rowIndex + 1] - pos;
        int index = Arrays.binarySearch(this._colidx, pos, pos + len, c);
        return index >= 0 ? this._values[index] : 0.0;
    }

    @Override
    public SparseRow get(int r) {
        if (this.isEmpty(r)) {
            return new SparseRowScalar();
        }
        int pos = this.pos(r);
        int len = this.size(r);
        SparseRowVector row = new SparseRowVector(len);
        System.arraycopy(this._colidx, pos, row.indexes(), 0, len);
        System.arraycopy(this._values, pos, row.values(), 0, len);
        row.setSize(len);
        return row;
    }

    @Override
    public Iterator<IJV> getIterator() {
        return super.getIterator();
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            return -1;
        }
        int colIdx = Arrays.binarySearch(this._colidx, this._rowptr[rowIdx], this._rowptr[rowIdx + 1], c);
        if (colIdx < 0) {
            colIdx = -colIdx - 2;
        }
        if (colIdx < this._rowptr[rowIdx]) {
            return -1;
        }
        return colIdx - this._rowptr[rowIdx];
    }

    @Override
    public final int posFIndexGTE(int r, int c) {
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            return -1;
        }
        int colIdx = Arrays.binarySearch(this._colidx, this._rowptr[rowIdx], this._rowptr[rowIdx + 1], c);
        if (colIdx < 0) {
            colIdx = -colIdx - 1;
        }
        if (colIdx >= this._rowptr[rowIdx + 1]) {
            return -1;
        }
        return colIdx - this._rowptr[rowIdx];
    }

    @Override
    public int posFIndexGT(int r, int c) {
        int rowIdx = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIdx < 0) {
            return -1;
        }
        int colIdx = Arrays.binarySearch(this._colidx, this._rowptr[rowIdx], this._rowptr[rowIdx + 1], c);
        colIdx = colIdx >= 0 ? ++colIdx : -colIdx - 1;
        if (colIdx >= this._rowptr[rowIdx + 1]) {
            return -1;
        }
        return colIdx - this._rowptr[rowIdx];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockCSR: rlen=");
        sb.append(this.numRows());
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        int rowDigits = (int)Math.max(Math.ceil(Math.log10(this.numRows())), 1.0);
        for (int rowIdx = 0; rowIdx < this._rowidx.length; ++rowIdx) {
            int row = this._rowidx[rowIdx];
            int pos = this._rowptr[rowIdx];
            int len = this._rowptr[rowIdx + 1] - pos;
            sb.append(String.format("%0" + rowDigits + "d ", row));
            for (int j = pos; j < pos + len; ++j) {
                if (this._values[j] == (double)((long)this._values[j])) {
                    sb.append(String.format("%" + rowDigits + "d:%d", this._colidx[j], (long)this._values[j]));
                } else {
                    sb.append(String.format("%" + rowDigits + "d:%s", this._colidx[j], Double.toString(this._values[j])));
                }
                if (j + 1 >= pos + len) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean checkValidity(int rlen, int clen, long nnz, boolean strict) {
        int i;
        if (rlen < 0 || clen < 0) {
            throw new RuntimeException("Invalid block dimensions: " + rlen + " " + clen);
        }
        if ((long)this._size != nnz && this._rowptr.length != this._rowidx.length + 1 && (long)this._values.length < nnz && (long)this._colidx.length < nnz) {
            throw new RuntimeException("Incorrect array lengths.");
        }
        for (i = 1; i < this._rowidx.length; ++i) {
            if (this._rowidx[i - 1] <= this._rowidx[i]) continue;
            throw new RuntimeException("Row indices are decreasing at row: " + i + ", with indices " + this._rowidx[i - 1] + " > " + this._rowidx[i]);
        }
        for (i = 1; i < this._rowptr.length; ++i) {
            if (this._rowptr[i - 1] <= this._rowptr[i]) continue;
            throw new RuntimeException("Row pointers are decreasing at row: " + i + ", with pointers " + this._rowptr[i - 1] + " > " + this._rowptr[i]);
        }
        for (int rowIdx = 0; rowIdx < this._rowidx.length; ++rowIdx) {
            int k;
            int apos = this._rowidx[rowIdx];
            int alen = this._rowidx[rowIdx + 1] - apos;
            for (k = apos + 1; k < apos + alen; ++k) {
                if (this._colidx[k - 1] < this._colidx[k]) continue;
                throw new RuntimeException("Wrong sparse row ordering: " + k + " " + this._colidx[k - 1] + " " + this._colidx[k]);
            }
            for (k = apos; k < apos + alen; ++k) {
                if (this._values[k] != 0.0) continue;
                throw new RuntimeException("Wrong sparse row: zero at " + k + " at col index " + this._colidx[k]);
            }
        }
        for (i = 0; i < this._size; ++i) {
            if (this._values[i] != 0.0) continue;
            throw new RuntimeException("The values array should not contain zeros. The " + i + "th value is " + this._values[i]);
        }
        int capacity = this._values.length;
        if ((double)capacity > (double)nnz * 2.0) {
            throw new RuntimeException("Capacity is larger than the nnz times a resize factor. Current size: " + capacity + ", while Expected size:" + (double)nnz * 2.0);
        }
        return true;
    }

    @Override
    public boolean contains(double pattern, int rl, int ru) {
        boolean NaNpattern = Double.isNaN(pattern);
        double[] vals = this._values;
        int prl = this.pos(rl);
        int pru = this.pos(ru);
        for (int i = prl; i < pru; ++i) {
            if (vals[i] != pattern && (!NaNpattern || !Double.isNaN(vals[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Integer> getNonEmptyRowsIterator(int rl, int ru) {
        return new NonEmptyRowsIteratorDCSR(rl, ru);
    }

    private int newCapacity(int minsize) {
        double tmpCap;
        for (tmpCap = (double)Math.max(this._values.length, 1); tmpCap < (double)minsize; tmpCap *= tmpCap <= 1024.0 ? 2.0 : 1.1) {
        }
        return (int)Math.min(tmpCap, 2.147483647E9);
    }

    private void deleteRow(int rowIdx) {
        System.arraycopy(this._rowidx, rowIdx + 1, this._rowidx, rowIdx, this._nnzr - rowIdx - 1);
        System.arraycopy(this._rowptr, rowIdx + 1, this._rowptr, rowIdx, this._nnzr - rowIdx);
        --this._nnzr;
    }

    private void insertRow(int ix, int row, int rowPtr) {
        if (this._nnzr >= this._rowidx.length) {
            this.resizeAndInsertRow(ix, row, rowPtr);
            return;
        }
        System.arraycopy(this._rowidx, ix, this._rowidx, ix + 1, this._nnzr - ix);
        System.arraycopy(this._rowptr, ix, this._rowptr, ix + 1, this._nnzr - ix + 1);
        this._rowidx[ix] = row;
        this._rowptr[ix] = rowPtr;
        ++this._nnzr;
    }

    private void resizeAndInsertRow(int ix, int row, int rowPtr) {
        int newCap = this.newCapacity(this._rowidx.length + 1);
        int[] oldrowidx = this._rowidx;
        int[] oldrowptr = this._rowptr;
        this._rowidx = new int[newCap];
        this._rowptr = new int[newCap + 1];
        System.arraycopy(oldrowidx, 0, this._rowidx, 0, ix);
        System.arraycopy(oldrowptr, 0, this._rowptr, 0, ix);
        System.arraycopy(oldrowidx, ix, this._rowidx, ix + 1, this._nnzr - ix);
        System.arraycopy(oldrowptr, ix, this._rowptr, ix + 1, this._nnzr - ix + 1);
        this._rowidx[ix] = row;
        this._rowptr[ix] = rowPtr;
        ++this._nnzr;
    }

    private void deleteCol(int ix) {
        System.arraycopy(this._colidx, ix + 1, this._colidx, ix, this._size - ix - 1);
        System.arraycopy(this._values, ix + 1, this._values, ix, this._size - ix - 1);
        --this._size;
    }

    private void insertCol(int ix, int c, double v) {
        if (this._size >= this._colidx.length) {
            this.resizeAndInsertCol(ix, c, v);
            return;
        }
        System.arraycopy(this._colidx, ix, this._colidx, ix + 1, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + 1, this._size - ix);
        this._colidx[ix] = c;
        this._values[ix] = v;
        ++this._size;
    }

    private void deleteCols(int ix, int len) {
        this.insertCols(ix, new int[0], new double[0], len, 0, 0);
    }

    private void insertCols(int ix, int[] cols, double[] vals, int overwriteNum) {
        this.insertCols(ix, cols, vals, overwriteNum, 0, vals.length);
    }

    private void insertCols(int ix, int[] cols, double[] vals, int overwriteNum, int vix, int vlen) {
        if (this._size + vlen - overwriteNum > this._colidx.length) {
            this.resizeAndInsertCols(ix, cols, vals, overwriteNum, vix, vlen);
            return;
        }
        this.allocateCols(ix, vlen, overwriteNum);
        System.arraycopy(cols, vix, this._colidx, ix, vlen);
        System.arraycopy(vals, vix, this._values, ix, vlen);
    }

    private void resizeAndInsertCols(int ix, int[] cols, double[] vals, int overwriteNum, int vix, int vlen) {
        this.resizeAndAllocateCols(ix, vlen, overwriteNum);
        System.arraycopy(cols, vix, this._colidx, ix, vlen);
        System.arraycopy(vals, vix, this._values, ix, vlen);
    }

    private void allocateCols(int ix, int numCols) {
        this.allocateCols(ix, numCols, 0);
    }

    private void allocateCols(int ix, int numCols, int overwriteNum) {
        if (numCols == 0) {
            return;
        }
        if (this._size + numCols - overwriteNum > this._colidx.length) {
            this.resizeAndAllocateCols(ix, numCols, overwriteNum);
            return;
        }
        System.arraycopy(this._colidx, ix + overwriteNum, this._colidx, ix + numCols, this._size - ix - overwriteNum);
        System.arraycopy(this._values, ix + overwriteNum, this._values, ix + numCols, this._size - ix - overwriteNum);
        this._size += numCols - overwriteNum;
    }

    private void resizeAndAllocateCols(int ix, int numCols, int overwriteNum) {
        int newCap = this.newCapacity(this._size + numCols - overwriteNum);
        int[] oldcolidx = this._colidx;
        double[] oldvalues = this._values;
        this._colidx = new int[newCap];
        this._values = new double[newCap];
        System.arraycopy(oldcolidx, 0, this._colidx, 0, ix);
        System.arraycopy(oldvalues, 0, this._values, 0, ix);
        System.arraycopy(oldcolidx, ix + overwriteNum, this._colidx, ix + numCols, this._size - ix - overwriteNum);
        System.arraycopy(oldvalues, ix + overwriteNum, this._values, ix + numCols, this._size - ix - overwriteNum);
        this._size += numCols - overwriteNum;
    }

    private void resizeAndInsertCol(int ix, int c, double v) {
        int newCap = this.newCapacity(this._values.length + 1);
        int[] oldcolidx = this._colidx;
        double[] oldvalues = this._values;
        this._colidx = new int[newCap];
        this._values = new double[newCap];
        System.arraycopy(oldcolidx, 0, this._colidx, 0, ix);
        System.arraycopy(oldvalues, 0, this._values, 0, ix);
        System.arraycopy(oldcolidx, ix, this._colidx, ix + 1, this._size - ix);
        System.arraycopy(oldvalues, ix, this._values, ix + 1, this._size - ix);
        this._colidx[ix] = c;
        this._values[ix] = v;
        ++this._size;
    }

    private void incrRowPtr(int rowIndex) {
        this.incrRowPtr(rowIndex, 1);
    }

    private void incrRowPtr(int rowIndex, int cnt) {
        int i = rowIndex;
        while (i < this._nnzr + 1) {
            int n = i++;
            this._rowptr[n] = this._rowptr[n] + cnt;
        }
    }

    private int posRowIndex(int r) {
        int rowIndex = Arrays.binarySearch(this._rowidx, 0, this._nnzr, r);
        if (rowIndex < 0) {
            rowIndex = -rowIndex - 1;
        }
        return rowIndex;
    }

    public class NonEmptyRowsIteratorDCSR
    implements Iterator<Integer> {
        private int _rpos;
        private final int _ru;

        public NonEmptyRowsIteratorDCSR(int rl, int ru) {
            this._rpos = rl == 0 ? 0 : SparseBlockDCSR.this.posRowIndex(rl);
            this._ru = ru;
        }

        @Override
        public boolean hasNext() {
            return this._rpos < SparseBlockDCSR.this._nnzr && SparseBlockDCSR.this._rowidx[this._rpos] < this._ru;
        }

        @Override
        public Integer next() {
            return SparseBlockDCSR.this._rowidx[this._rpos++];
        }
    }
}

