/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.utils.MemoryEstimates;

public class SparseBlockMCSC
extends SparseBlock {
    private static final long serialVersionUID = 112364695245614881L;
    private SparseRow[] _columns = null;
    private int _clenInferred = -1;
    private int _rlen = -1;

    public SparseBlockMCSC(SparseBlock sblock, int clen) {
        this._clenInferred = clen;
        this._rlen = sblock.numRows();
        this.initialize(sblock);
    }

    public SparseBlockMCSC(SparseBlock sblock) {
        this._rlen = sblock.numRows();
        this.initialize(sblock);
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(SparseBlock sblock) {
        int clen = 0;
        if (sblock instanceof SparseBlockMCSC) {
            SparseRow[] originalColumns = ((SparseBlockMCSC)sblock)._columns;
            this._columns = new SparseRow[originalColumns.length];
            for (int i = 0; i < this._columns.length; ++i) {
                if (originalColumns[i] == null) continue;
                this._columns[i] = originalColumns[i].copy(true);
            }
        } else if (sblock instanceof SparseBlockMCSR) {
            SparseRow[] originalRows = ((SparseBlockMCSR)sblock).getRows();
            HashMap<Integer, Integer> columnSizes = new HashMap<Integer, Integer>();
            if (this._clenInferred == -1) {
                for (SparseRow sparseRow : originalRows) {
                    if (sparseRow == null || sparseRow.isEmpty()) continue;
                    for (int i = 0; i < sparseRow.size(); ++i) {
                        int rowIndex = sparseRow.indexes()[i];
                        columnSizes.put(rowIndex, columnSizes.getOrDefault(rowIndex, 0) + 1);
                    }
                }
                clen = (Integer)columnSizes.keySet().stream().max(Integer::compare).orElseThrow(NoSuchElementException::new);
                this._columns = new SparseRow[clen + 1];
            } else {
                this._columns = new SparseRow[this._clenInferred];
            }
            for (int i = 0; i < this._columns.length; ++i) {
                int columnSize = columnSizes.getOrDefault(i, -1);
                if (columnSize == -1) continue;
                this._columns[i] = columnSize == 1 ? new SparseRowScalar() : new SparseRowVector(columnSize);
            }
            int[] rowIndexes = null;
            double[] values = null;
            int rowPosition = 0;
            for (SparseRow row : originalRows) {
                if (row != null && !row.isEmpty()) {
                    rowIndexes = row.indexes();
                    values = row.values();
                    for (int i = 0; i < row.size(); ++i) {
                        int rowIndex = rowIndexes[i];
                        double currentValue = values[i];
                        this._columns[rowIndex].set(rowPosition, currentValue);
                    }
                }
                ++rowPosition;
            }
        } else {
            void var8_25;
            int[] columnIndexes;
            HashMap<Integer, Integer> columnSizes = new HashMap<Integer, Integer>();
            for (int n : columnIndexes = sblock.indexes(0)) {
                columnSizes.put(n, columnSizes.getOrDefault(n, 0) + 1);
            }
            clen = (Integer)columnSizes.keySet().stream().max(Integer::compare).orElseThrow(NoSuchElementException::new);
            this._columns = this._clenInferred == -1 ? new SparseRow[clen + 1] : new SparseRow[this._clenInferred];
            for (int i = 0; i < this._columns.length; ++i) {
                int columnSize = columnSizes.getOrDefault(i, -1);
                if (columnSize == -1) continue;
                this._columns[i] = columnSize == 1 ? new SparseRowScalar() : new SparseRowVector(columnSize);
            }
            double[] vals = sblock.values(0);
            int[] cols = sblock.indexes(0);
            int row = 0;
            boolean bl = false;
            while (var8_25 < vals.length) {
                int rowSize = sblock.size(row);
                for (void j = var8_25; j < var8_25 + rowSize; ++j) {
                    this._columns[cols[j]].set(row, vals[j]);
                }
                var8_25 += rowSize;
                ++row;
            }
        }
    }

    public SparseBlockMCSC(SparseRow[] cols, boolean deep, int rlen) {
        this._rlen = rlen;
        if (deep) {
            this._columns = new SparseRow[cols.length];
            for (int i = 0; i < this._columns.length; ++i) {
                this._columns[i] = cols[i].size() == 1 ? new SparseRowScalar(cols[i].indexes()[0], cols[i].values()[0]) : new SparseRowVector(cols[i]);
            }
        } else {
            this._columns = cols;
        }
    }

    public SparseBlockMCSC(int clen) {
        this._columns = new SparseRow[clen];
    }

    public SparseBlockMCSC(int rlen, int clen) {
        this._rlen = rlen;
        this._columns = new SparseRow[clen];
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        double nnz = Math.ceil(sparsity * (double)nrows * (double)ncols);
        double clen = Math.min((double)nrows, nnz);
        double rnnz = Math.max(4.0, nnz / clen);
        double size = 16.0;
        size += MemoryEstimates.objectArrayCost(ncols);
        long sparseColSize = 16L;
        sparseColSize += 8L;
        sparseColSize = (long)((double)sparseColSize + MemoryEstimates.intArrayCost(0L));
        sparseColSize = (long)((double)sparseColSize + MemoryEstimates.doubleArrayCost(0L));
        sparseColSize = (long)((double)sparseColSize + 12.0 * Math.max(1.0, rnnz));
        return (long)Math.min(size += clen * (double)sparseColSize, 9.223372036854776E18);
    }

    @Override
    public long getExactSizeInMemory() {
        double size = 16.0;
        size += MemoryEstimates.objectArrayCost(this._columns.length);
        for (SparseRow sc : this._columns) {
            if (sc == null) continue;
            long sparseColSize = 16L;
            if (sc instanceof SparseRowScalar) {
                sparseColSize += 12L;
            } else {
                sparseColSize += 8L;
                sparseColSize = (long)((double)sparseColSize + MemoryEstimates.intArrayCost(0L));
                sparseColSize = (long)((double)sparseColSize + MemoryEstimates.doubleArrayCost(0L));
                sparseColSize += (long)(12 * ((SparseRowVector)sc).capacity());
            }
            size += (double)sparseColSize;
        }
        return (long)Math.min(size, 9.223372036854776E18);
    }

    @Override
    public void allocate(int r) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (this.isAllocatedCol(i)) continue;
            this._columns[i] = new SparseRowVector();
        }
    }

    public void allocateCol(int c) {
        if (!this.isAllocatedCol(c)) {
            this._columns[c] = new SparseRowVector();
        }
    }

    @Override
    public void allocate(int r, int nnz) {
        this.allocate(r);
    }

    public void allocateCol(int c, int nnz) {
        if (!this.isAllocated(c)) {
            this._columns[c] = nnz == 1 ? new SparseRowScalar() : new SparseRowVector(nnz);
        }
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
        this.allocate(r);
    }

    public void allocateCol(int c, int ennz, int maxnnz) {
        if (!this.isAllocated(c)) {
            this._columns[c] = ennz == 1 ? new SparseRowScalar() : new SparseRowVector(ennz, maxnnz);
        }
    }

    @Override
    public void compact(int r) {
        for (int i = 0; i < this._columns.length; ++i) {
            this.compactCol(i);
        }
    }

    public void compactCol(int c) {
        if (this.isAllocated(c)) {
            SparseRowScalar s;
            if (this._columns[c] instanceof SparseRowVector && this._columns[c].size() > 4 && (double)this._columns[c].size() * 2.0 < (double)((SparseRowVector)this._columns[c]).capacity()) {
                ((SparseRowVector)this._columns[c]).compact();
            } else if (this._columns[c] instanceof SparseRowScalar && (s = (SparseRowScalar)this._columns[c]).getValue() == 0.0) {
                this._columns[c] = null;
            }
        }
    }

    @Override
    public int numRows() {
        return this._rlen;
    }

    public int numCols() {
        return this._columns.length;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public boolean isAllocated(int r) {
        for (SparseRow col : this._columns) {
            if (col != null) continue;
            return false;
        }
        return true;
    }

    public boolean isAllocatedCol(int c) {
        return this._columns[c] != null;
    }

    @Override
    public void reset() {
        for (SparseRow col : this._columns) {
            if (col == null) continue;
            col.reset(col.size(), Integer.MAX_VALUE);
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        for (SparseRow col : this._columns) {
            if (col == null) continue;
            col.reset(ennz, maxnnz);
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i)) continue;
            if (this._columns[i] instanceof SparseRowScalar && this._columns[i].indexes()[0] == r) {
                this._columns[i].set(r, 0.0);
                continue;
            }
            if (!(this._columns[i] instanceof SparseRowVector)) continue;
            this._columns[i].set(r, 0.0);
        }
    }

    public void resetCol(int c, int ennz, int maxnnz) {
        if (this.isAllocatedCol(c)) {
            this._columns[c].reset(ennz, maxnnz);
        }
    }

    @Override
    public long size() {
        long nnz = 0L;
        for (SparseRow col : this._columns) {
            if (col == null) continue;
            nnz += (long)col.size();
        }
        return nnz;
    }

    @Override
    public int size(int r) {
        int nnz = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i)) continue;
            nnz += this._columns[i].get(r) != 0.0 ? 1 : 0;
        }
        return nnz;
    }

    public int sizeCol(int c) {
        return this.isAllocated(c) ? this._columns[c].size() : 0;
    }

    @Override
    public long size(int rl, int ru) {
        long nnz = 0L;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i)) continue;
            for (int j = rl; j < ru; ++j) {
                nnz += this._columns[i].get(j) != 0.0 ? 1L : 0L;
            }
        }
        return nnz;
    }

    public long sizeCol(int cl, int cu) {
        long nnz = 0L;
        for (int i = cl; i < cu; ++i) {
            nnz += this.isAllocated(i) ? (long)this._columns[i].size() : 0L;
        }
        return nnz;
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = cl; i < cu; ++i) {
            if (this.isEmptyCol(i)) continue;
            int start = this.posFIndexGTECol(rl, i);
            int end = this.posFIndexLTECol(ru - 1, i);
            nnz += start != -1 && end != -1 ? (long)(end - start + 1) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i) || this._columns[i].get(r) == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyCol(int c) {
        return this._columns[c] == null || this._columns[c].isEmpty();
    }

    @Override
    public boolean checkValidity(int rlen, int clen, long nnz, boolean strict) {
        int i;
        if (rlen < 0 || clen < 0) {
            throw new RuntimeException("Invalid block dimensions: (" + rlen + ", " + clen + ").");
        }
        if (this.size() < nnz) {
            throw new RuntimeException("Incorrect size: " + this.size() + " (expected: " + nnz + ").");
        }
        for (i = 0; i < clen; ++i) {
            if (this.isEmpty(i)) continue;
            int apos = this.pos(i);
            int alen = this.size(i);
            int[] aix = this.indexes(i);
            double[] avals = this.values(i);
            for (int k = apos + 1; k < apos + alen; ++k) {
                if (aix[k - 1] >= aix[k] | aix[k - 1] < 0) {
                    throw new RuntimeException("Wrong sparse column ordering, at column=" + i + ", pos=" + k + " with row indexes " + aix[k - 1] + ">=" + aix[k]);
                }
                if (avals[k] != 0.0) continue;
                throw new RuntimeException("The values are expected to be non zeros but zero at column: " + i + ", row pos: " + k);
            }
        }
        for (i = 0; i < clen; ++i) {
            long max_size = (long)Math.max((double)nnz * 2.0, 4.0);
            if (this.isEmpty(i) || (long)this.values(i).length <= max_size) continue;
            throw new RuntimeException("The capacity is larger than nnz times a resize factor(=2). Actual length = " + this.values(i).length + ", should not exceed " + max_size);
        }
        return true;
    }

    @Override
    public int[] indexes(int r) {
        int nnz = this.size(r);
        int[] idx = new int[nnz];
        int index = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i) || this._columns[i].get(r) == 0.0) continue;
            idx[index] = i;
            ++index;
        }
        return idx;
    }

    public int[] indexesCol(int c) {
        return this._columns[c].indexes();
    }

    @Override
    public double[] values(int r) {
        int nnz = this.size(r);
        double[] vals = new double[nnz];
        int index = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this.isAllocatedCol(i) || this._columns[i].get(r) == 0.0) continue;
            vals[index] = this._columns[i].get(r);
            ++index;
        }
        return vals;
    }

    public double[] valuesCol(int c) {
        return this._columns[c].values();
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    @Override
    public boolean set(int r, int c, double v) {
        if (!this.isAllocatedCol(c)) {
            this._columns[c] = new SparseRowScalar();
        } else if (this._columns[c] instanceof SparseRowScalar && !this._columns[c].isEmpty()) {
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        return this._columns[c].set(r, v);
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        this.reset(r, 1, 1);
        int nnz = row.size();
        for (int i = 0; i < nnz; ++i) {
            this.set(r, row.indexes()[i], row.values()[i]);
        }
    }

    public void setCol(int c, SparseRow col, boolean deep) {
        if (this.isAllocatedCol(c) && this._columns[c] instanceof SparseRowVector && ((SparseRowVector)this._columns[c]).capacity() >= col.size() && deep) {
            ((SparseRowVector)this._columns[c]).copy(col);
        } else {
            this._columns[c] = deep && col != null ? new SparseRowVector(col) : col;
        }
    }

    @Override
    public boolean add(int r, int c, double v) {
        if (!this.isAllocatedCol(c)) {
            this._columns[c] = new SparseRowScalar();
        } else if (this._columns[c] instanceof SparseRowScalar && !this._columns[c].isEmpty()) {
            SparseRowScalar s = (SparseRowScalar)this._columns[c];
            if (s.getIndex() == r) {
                return s.set(s.getIndex(), v + s.getValue());
            }
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        return this._columns[c].add(r, v);
    }

    @Override
    public void append(int r, int c, double v) {
        if (v == 0.0) {
            return;
        }
        this._columns[c] = this._columns[c] == null ? new SparseRowScalar(r, v) : this._columns[c].append(r, v);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        int idx = vix;
        for (int i = cl; i < cu; ++i) {
            this.set(r, i, v[idx]);
            ++idx;
        }
    }

    public void setIndexRangeCol(int c, int rl, int ru, double[] v, int vix, int vlen) {
        if (!this.isAllocatedCol(c)) {
            this._columns[c] = new SparseRowVector();
        } else if (this._columns[c] instanceof SparseRowScalar) {
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        ((SparseRowVector)this._columns[c]).setIndexRange(rl, ru - 1, v, vix, vlen);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        for (int i = vpos; i < vpos + vlen; ++i) {
            this.set(r, vix[i], v[i]);
        }
    }

    public void setIndexRangeCol(int c, int rl, int ru, double[] v, int[] vix, int vpos, int vlen) {
        if (!this.isAllocatedCol(c)) {
            this._columns[c] = new SparseRowVector();
        } else if (this._columns[c] instanceof SparseRowScalar) {
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        ((SparseRowVector)this._columns[c]).setIndexRange(rl, ru - 1, v, vix, vpos, vlen);
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        for (int i = cl; i < cu; ++i) {
            if (!this.isAllocatedCol(i)) continue;
            if (this._columns[i] instanceof SparseRowScalar && this._columns[i].indexes()[0] == r) {
                this._columns[i].set(r, 0.0);
                continue;
            }
            if (!(this._columns[i] instanceof SparseRowVector)) continue;
            this._columns[i].set(r, 0.0);
        }
    }

    public void deleteIndexRangeCol(int c, int rl, int ru) {
        if (this._columns[c] instanceof SparseRowScalar) {
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        ((SparseRowVector)this._columns[c]).deleteIndexRange(rl, ru - 1);
    }

    @Override
    public void sort() {
        for (SparseRow col : this._columns) {
            if (col == null || col.isEmpty()) continue;
            col.sort();
        }
    }

    @Override
    public void sort(int r) {
        this.sort();
    }

    public void sortCol(int c) {
        this._columns[c].sort();
    }

    @Override
    public double get(int r, int c) {
        if (!this.isAllocatedCol(c)) {
            return 0.0;
        }
        return this._columns[c].get(r);
    }

    @Override
    public SparseRow get(int r) {
        SparseRow row = this.size(r) == 1 ? new SparseRowScalar() : new SparseRowVector(this.size(r));
        double v = 0.0;
        for (int i = 0; i < this._columns.length; ++i) {
            v = this.get(r, i);
            if (v == 0.0) continue;
            row.set(i, v);
        }
        return row;
    }

    public SparseRow getCol(int c) {
        return this._columns[c];
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        SparseRow row = this.get(r);
        return ((SparseRowVector)row).searchIndexesFirstLTE(c);
    }

    public int posFIndexLTECol(int r, int c) {
        if (this._columns[c] instanceof SparseRowScalar) {
            this._columns[c] = new SparseRowVector(this._columns[c]);
        }
        return ((SparseRowVector)this._columns[c]).searchIndexesFirstLTE(r);
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        SparseRow row = this.get(r);
        return row.searchIndexesFirstGTE(c);
    }

    public int posFIndexGTECol(int r, int c) {
        return this._columns[c].searchIndexesFirstGTE(r);
    }

    @Override
    public int posFIndexGT(int r, int c) {
        SparseRow row = this.get(r);
        return row.searchIndexesFirstGT(c);
    }

    public int posFIndexGTCol(int r, int c) {
        return this._columns[c].searchIndexesFirstGT(r);
    }

    @Override
    public Iterator<Integer> getNonEmptyRowsIterator(int rl, int ru) {
        return new NonEmptyRowsIteratorMCSC(rl, ru);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.numCols();
        sb.append("SparseBlockMCSC: clen=");
        sb.append(nCol);
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        int colDigits = (int)Math.max(Math.ceil(Math.log10(nCol)), 1.0);
        for (int i = 0; i < nCol; ++i) {
            if (this.isEmptyCol(i)) continue;
            sb.append(String.format("%0" + colDigits + "d %s\n", i, this._columns[i].toString()));
        }
        return sb.toString();
    }

    public SparseRow[] getCols() {
        return this._columns;
    }

    public SparseRow[] getRows() {
        SparseRow[] rows = new SparseRow[this.numRows()];
        for (int i = 0; i < this.numRows(); ++i) {
            rows[i] = this.get(i);
        }
        return rows;
    }

    public Iterator<Integer> getNonEmptyColumnsIterator(int cl, int cu) {
        return new NonEmptyColumnsIteratorMCSC(cl, cu);
    }

    private class SparseNonEmptyColumnIterable
    implements Iterable<Integer> {
        private final int _cl;
        private final int _cu;

        protected SparseNonEmptyColumnIterable(int cl, int cu) {
            this._cl = cl;
            this._cu = cu;
        }

        @Override
        public Iterator<Integer> iterator() {
            return SparseBlockMCSC.this.getNonEmptyColumnsIterator(this._cl, this._cu);
        }
    }

    public class NonEmptyColumnsIteratorMCSC
    implements Iterator<Integer> {
        private int _cpos;
        private final int _cu;

        public NonEmptyColumnsIteratorMCSC(int cl, int cu) {
            this._cpos = cl;
            this._cu = cu;
        }

        @Override
        public boolean hasNext() {
            while (this._cpos < this._cu && SparseBlockMCSC.this.isEmptyCol(this._cpos)) {
                ++this._cpos;
            }
            return this._cpos < this._cu;
        }

        @Override
        public Integer next() {
            return this._cpos++;
        }
    }

    public class NonEmptyRowsIteratorMCSC
    implements Iterator<Integer> {
        private int _rpos;
        private final int _ru;

        public NonEmptyRowsIteratorMCSC(int rl, int ru) {
            this._rpos = rl;
            this._ru = ru;
        }

        @Override
        public boolean hasNext() {
            while (this._rpos < this._ru && SparseBlockMCSC.this.isEmpty(this._rpos)) {
                ++this._rpos;
            }
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            return this._rpos++;
        }
    }
}

