/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.common.Warnings;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockDRB;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockFP32
extends DenseBlockDRB {
    private static final long serialVersionUID = 1950471811056914020L;
    private float[] _data;

    public DenseBlockFP32(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new float[length];
    }

    public DenseBlockFP32(int[] dims, float[] data) {
        super(dims);
        this._data = data;
    }

    public float[] getData() {
        return this._data;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.FP32 == vt;
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new float[len];
            if (v != 0.0) {
                Arrays.fill(this._data, (float)v);
            }
        } else {
            Arrays.fill(this._data, 0, len, (float)v);
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public void resetNoFill(int rlen, int[] odims) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new float[len];
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._data, start, length);
    }

    @Override
    public double[] values(int r) {
        double[] ret = this.getReuseRow(false);
        int ix = this.pos(r);
        int ncol = this._odims[0];
        for (int j = 0; j < ncol; ++j) {
            ret[j] = this._data[ix + j];
        }
        return ret;
    }

    @Override
    public double[] valuesAt(int bix) {
        Warnings.warnFullFP64Conversion(this._data.length);
        return DataConverter.toDouble(this._data);
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public void incr(int r, int c) {
        int n = this.pos(r, c);
        this._data[n] = this._data[n] + 1.0f;
    }

    @Override
    public void incr(int r, int c, double delta) {
        int n = this.pos(r, c);
        this._data[n] = (float)((double)this._data[n] + delta);
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._data, fromIndex, toIndex, (float)v);
    }

    @Override
    public void fillRow(int r, double v) {
        int start = this.pos(r);
        int end = start + this.getDim(1);
        Arrays.fill(this._data, start, end, (float)v);
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._data[ix] = (float)v;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._data[this.pos((int)r, (int)c)] = (float)v;
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        double[] data = db.valuesAt(0);
        for (int i = 0; i < this._rlen * this._odims[0]; ++i) {
            this._data[i] = (float)data[i];
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        int row = this.pos(r);
        for (int i = 0; i < this._odims[0]; ++i) {
            this._data[row + i] = (float)v[i];
        }
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._data[this.pos((int[])ix)] = (float)v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._data[this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._data[this.pos((int[])ix)] = Float.parseFloat(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._data[this.pos(r, c)];
    }

    @Override
    public double get(int[] ix) {
        return this._data[this.pos(ix)];
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._data[this.pos(ix)]);
    }

    @Override
    public long getLong(int[] ix) {
        return UtilFunctions.toLong(this._data[this.pos(ix)]);
    }
}

