/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.BasicTensorBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockBool;
import org.apache.sysds.runtime.data.DenseBlockFP32;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.DenseBlockFactory;
import org.apache.sysds.runtime.data.DenseBlockInt32;
import org.apache.sysds.runtime.data.DenseBlockInt64;
import org.apache.sysds.runtime.data.DenseBlockString;
import org.apache.sysds.runtime.data.IndexedTensorBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class LibTensorReorg {
    private static final boolean SHALLOW_COPY_REORG = true;

    private LibTensorReorg() {
    }

    public static BasicTensorBlock reshape(BasicTensorBlock in, BasicTensorBlock out, int[] dims) {
        long length = 1L;
        for (int dim : dims) {
            length *= (long)dim;
        }
        int[] inDims = in.getDims();
        if (in.getLength() != length) {
            throw new DMLRuntimeException("Reshape tensor requires consistent numbers of input/output cells (" + Arrays.toString(inDims) + ", " + Arrays.toString(dims) + ").");
        }
        if (Arrays.equals(inDims, dims)) {
            out.copyShallow(in);
            return out;
        }
        out._sparse = false;
        out._dims = dims;
        out._nnz = in._nnz;
        if (in.isSparse() || out.isSparse()) {
            if (in.isSparse() && out.isSparse()) {
                throw new NotImplementedException();
            }
            if (in.isSparse()) {
                throw new NotImplementedException();
            }
            throw new NotImplementedException();
        }
        LibTensorReorg.reshapeDense(in, out, dims);
        return out;
    }

    private static void reshapeDense(BasicTensorBlock in, BasicTensorBlock out, int[] dims) {
        if (in._denseBlock == null) {
            return;
        }
        if (in._denseBlock.numBlocks() == 1) {
            DenseBlock denseBlock = in._denseBlock;
            if (denseBlock instanceof DenseBlockBool) {
                DenseBlockBool specificBlock = (DenseBlockBool)denseBlock;
                out._denseBlock = DenseBlockFactory.createDenseBlock(specificBlock.getData(), dims);
            } else if (denseBlock instanceof DenseBlockString) {
                DenseBlockString specificBlock = (DenseBlockString)denseBlock;
                out._denseBlock = DenseBlockFactory.createDenseBlock(specificBlock.getData(), dims);
            } else if (denseBlock instanceof DenseBlockFP64) {
                out._denseBlock = DenseBlockFactory.createDenseBlock(in._denseBlock.valuesAt(0), dims);
            } else if (denseBlock instanceof DenseBlockFP32) {
                DenseBlockFP32 specificBlock = (DenseBlockFP32)denseBlock;
                out._denseBlock = DenseBlockFactory.createDenseBlock(specificBlock.getData(), dims);
            } else if (denseBlock instanceof DenseBlockInt64) {
                DenseBlockInt64 specificBlock = (DenseBlockInt64)denseBlock;
                out._denseBlock = DenseBlockFactory.createDenseBlock(specificBlock.getData(), dims);
            } else if (denseBlock instanceof DenseBlockInt32) {
                DenseBlockInt32 specificBlock = (DenseBlockInt32)denseBlock;
                out._denseBlock = DenseBlockFactory.createDenseBlock(specificBlock.getData(), dims);
            }
            return;
        }
        out.set(in);
    }

    public static List<IndexedTensorBlock> reshape(IndexedTensorBlock in, DataCharacteristics mcIn, DataCharacteristics mcOut, boolean rowwise, boolean outputEmptyBlocks) {
        throw new DMLRuntimeException("Spark reshape not implemented for tensors.");
    }
}

