/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import org.apache.sysds.common.InstructionType;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.CPInstructionParser;
import org.apache.sysds.runtime.instructions.FEDInstructionParser;
import org.apache.sysds.runtime.instructions.GPUInstructionParser;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.SPInstructionParser;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;

public class InstructionParser {
    public static Instruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        Types.ExecType et = InstructionUtils.getExecType(str);
        switch (et) {
            case CP: 
            case CP_FILE: {
                InstructionType cptype = InstructionUtils.getCPType(str);
                if (cptype == null) {
                    throw new DMLRuntimeException("Unknown CP instruction: " + str);
                }
                return CPInstructionParser.parseSingleInstruction(cptype, str);
            }
            case SPARK: {
                InstructionType sptype = InstructionUtils.getSPType(str);
                if (sptype == null) {
                    throw new DMLRuntimeException("Unknown SPARK instruction: " + str);
                }
                return SPInstructionParser.parseSingleInstruction(sptype, str);
            }
            case GPU: {
                GPUInstruction.GPUINSTRUCTION_TYPE gputype = InstructionUtils.getGPUType(str);
                if (gputype == null) {
                    throw new DMLRuntimeException("Unknown GPU instruction: " + str);
                }
                return GPUInstructionParser.parseSingleInstruction(gputype, str);
            }
            case FED: {
                InstructionType fedtype = InstructionUtils.getFEDType(str);
                if (fedtype == null) {
                    throw new DMLRuntimeException("Unknown FEDERATED instruction: " + str);
                }
                return FEDInstructionParser.parseSingleInstruction(fedtype, str);
            }
        }
        throw new DMLRuntimeException("Unknown execution type in instruction: " + str);
    }

    public static Instruction[] parseMixedInstructions(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] strlist = str.split("\u2021");
        Instruction[] inst = new Instruction[strlist.length];
        for (int i = 0; i < inst.length; ++i) {
            inst[i] = InstructionParser.parseSingleInstruction(strlist[i]);
        }
        return inst;
    }
}

