/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.commons.ObjectProvider;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Value;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.SymbolSource;

public class ValueObjectProvider
implements ObjectProvider {
    private final SymbolSource symbolSource;
    private final TypeCoercer typeCoercer;

    public ValueObjectProvider(@Builtin SymbolSource symbolSource, @Builtin TypeCoercer typeCoercer) {
        this.symbolSource = symbolSource;
        this.typeCoercer = typeCoercer;
    }

    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        Value annotation = (Value)annotationProvider.getAnnotation(Value.class);
        if (annotation == null) {
            return null;
        }
        String value = annotation.value();
        Object expanded = this.symbolSource.expandSymbols(value);
        IntermediateType intermediate = (IntermediateType)annotationProvider.getAnnotation(IntermediateType.class);
        if (intermediate != null) {
            expanded = this.typeCoercer.coerce(expanded, intermediate.value());
        }
        return (T)this.typeCoercer.coerce(expanded, objectType);
    }
}

