/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import java.util.Optional;
import org.apache.tapestry5.EventContext;

public abstract class AbstractEventContext
implements EventContext {
    @Override
    public String[] toStrings() {
        int count = this.getCount();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.get(String.class, i);
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<EventContext");
        String[] values = this.toStrings();
        String sep = ": ";
        for (int i = 0; i < values.length; ++i) {
            builder.append(sep).append(values[i]);
            sep = ", ";
        }
        return builder.append('>').toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public <T> Optional<T> tryGet(Class<T> desiredType, int index) {
        if (index >= this.getCount()) {
            return Optional.empty();
        }
        try {
            T value = this.get(desiredType, index);
            return Optional.ofNullable(value);
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
    }
}

