/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.ioc.services.ClasspathMatcher;
import org.apache.tapestry5.ioc.services.ClasspathScanner;

public class ClassNameLocatorImpl
implements ClassNameLocator {
    private final ClasspathScanner scanner;
    private final Pattern CLASS_NAME_PATTERN = Pattern.compile("^\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}&&[^\\$]]*\\.class$", 2);
    private final ClasspathMatcher CLASS_NAME_MATCHER = new ClasspathMatcher(){

        @Override
        public boolean matches(String packagePath, String fileName) {
            if (!ClassNameLocatorImpl.this.CLASS_NAME_PATTERN.matcher(fileName).matches()) {
                return false;
            }
            return !fileName.contains("$") && !fileName.equals("package-info.class");
        }
    };
    private final Mapper<String, String> CLASS_NAME_MAPPER = new Mapper<String, String>(){

        public String map(String element) {
            return element.substring(0, element.length() - 6).replace('/', '.');
        }
    };

    public ClassNameLocatorImpl(ClasspathScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public synchronized Collection<String> locateClassNames(String packageName) {
        String packagePath = packageName.replace('.', '/') + "/";
        try {
            Set<String> matches = this.scanner.scan(packagePath, this.CLASS_NAME_MATCHER);
            return F.flow(matches).map(this.CLASS_NAME_MAPPER).toSet();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

