/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

abstract class AbstractUnit<Q extends Quantity<Q>>
implements Unit<Q>,
LenientComparable,
Serializable {
    private static final long serialVersionUID = -5559950920796714303L;
    static final char MULTIPLY = '\u22c5';
    static final char DIVIDE = '\u2215';
    private static final int MAX_OPERATIONS_IN_SYMBOL = 1;
    private final String symbol;
    final transient byte scope;
    final transient short epsg;

    AbstractUnit(String string, byte by, short s) {
        this.symbol = string;
        this.scope = by;
        this.epsg = s;
    }

    static boolean isPrefixable(Unit<?> unit) {
        return unit instanceof AbstractUnit && ((AbstractUnit)unit).isPrefixable();
    }

    final boolean isPrefixable() {
        return (this.scope & 1) != 0;
    }

    static boolean isSymbolChar(int n) {
        return Character.isLetter(n) || Characters.isSubScript(n) || "\u00b0'\u2032\u2019\"\u2033%\u2030\u2031-_".indexOf(n) >= 0;
    }

    private static boolean isValidSymbol(String string, boolean bl, boolean bl2) {
        return AbstractUnit.invalidCharForSymbol(string, bl2 ? 1 : 0, bl) == -1;
    }

    static int invalidCharForSymbol(String string, int n, boolean bl) {
        int n2;
        if (string == null || string.isEmpty()) {
            return -2;
        }
        for (int i = 0; i < string.length(); i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (AbstractUnit.isSymbolChar(n2) || !(n2 == 8901 ? --n < 0 : !bl || !Characters.isSuperScript(n2))) continue;
            return n2;
        }
        return -1;
    }

    final String inferSymbol(char c, Unit<?> unit) {
        String string = this.symbol;
        boolean bl = false;
        boolean bl2 = false;
        switch (c) {
            case '\u2215': {
                bl = string != null && string.isEmpty();
            }
            case '\u22c5': {
                bl2 = true;
            }
        }
        if (bl || AbstractUnit.isValidSymbol(string, bl2, bl2)) {
            if (unit != null) {
                String string2 = unit.getSymbol();
                if (AbstractUnit.isValidSymbol(string2, bl2, false)) {
                    if (bl) {
                        string = "1";
                    }
                    return (string + c + string2).intern();
                }
            } else if (!bl2) {
                assert (Characters.isSuperScript(c)) : c;
                return (string + c).intern();
            }
        }
        return null;
    }

    final <R extends Quantity<R>> Unit<R> inferSymbol(Unit<R> unit, char c, Unit<?> unit2) {
        String string;
        if (unit instanceof ConventionalUnit && unit.getSymbol() == null && (string = this.inferSymbol(c, unit2)) != null) {
            unit = ((ConventionalUnit)unit).forSymbol(string);
        }
        return unit;
    }

    @Override
    public final String getSymbol() {
        return this.symbol;
    }

    @Override
    public final String getName() {
        if (this.symbol != null) {
            try {
                return UnitFormat.getBundle(Locale.getDefault()).getString(this.symbol);
            }
            catch (MissingResourceException missingResourceException) {
                Logging.ignorableException(Logger.getLogger("org.apache.sis.measure"), AbstractUnit.class, "getName", missingResourceException);
            }
        }
        return null;
    }

    @Override
    public abstract SystemUnit<Q> getSystemUnit();

    @Override
    public abstract Map<SystemUnit<?>, Integer> getBaseUnits();

    abstract Map<SystemUnit<?>, Fraction> getBaseSystemUnits();

    @Override
    public final boolean isCompatible(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("that", unit);
        return this.getDimension().equals(unit.getDimension());
    }

    final String incompatible(Unit<?> unit) {
        return Errors.format((short)66, this, unit);
    }

    @Override
    public final Unit<Q> shift(double d) {
        if (d == 0.0) {
            return this;
        }
        double d2 = 1.0;
        double d3 = 1.0;
        do {
            double d4;
            double d5;
            if (!(Math.abs((d5 = d * d3) - (d4 = Math.rint(d5))) <= Math.ulp(d5))) continue;
            d = d4;
            d2 = d3;
            break;
        } while ((d3 *= 10.0) <= 1000000.0);
        return this.transform(LinearConverter.offset(d, d2));
    }

    @Override
    public final Unit<Q> multiply(double d) {
        if (d == 1.0) {
            return this;
        }
        double d2 = AbstractUnit.inverse(d);
        if (d2 != 1.0) {
            d = 1.0;
        } else {
            double d3 = 1.0;
            do {
                double d4;
                double d5;
                if (!(Math.abs((d5 = d * d3) - (d4 = Math.rint(d5))) <= Math.ulp(d5))) continue;
                d = d4;
                d2 = d3;
                break;
            } while ((d3 *= 10.0) <= 1000000.0);
        }
        return this.transform(LinearConverter.scale(d, d2));
    }

    @Override
    public final Unit<Q> divide(double d) {
        if (d == 1.0) {
            return this;
        }
        double d2 = AbstractUnit.inverse(d);
        if (d2 != 1.0) {
            d = 1.0;
        }
        return this.transform(LinearConverter.scale(d2, d));
    }

    private static double inverse(double d) {
        double d2;
        double d3;
        if (Math.abs(d) < 1.0 && AbstractConverter.epsilonEquals(d3 = 1.0 / d, d2 = Math.rint(d3))) {
            return d2;
        }
        return 1.0;
    }

    @Override
    public final Unit<?> inverse() {
        return this.pow(-1);
    }

    ConventionalUnit<Q>[] related() {
        return null;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (comparisonMode.isIgnoringMetadata()) {
            return true;
        }
        AbstractUnit abstractUnit = (AbstractUnit)object;
        return AbstractUnit.equals(this.epsg, abstractUnit.epsg) && AbstractUnit.equals(this.scope, abstractUnit.scope) && Objects.equals(this.symbol, abstractUnit.symbol);
    }

    private static boolean equals(short s, short s2) {
        return s == 0 || s2 == 0 || s == s2;
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.symbol);
    }

    @Override
    public final String toString() {
        if (this.symbol != null) {
            return this.symbol;
        }
        return UnitFormat.INSTANCE.format(this);
    }

    final Object readResolve() throws ObjectStreamException {
        Object object;
        if (this.symbol != null && Units.initialized && this.equals(object = UnitRegistry.putIfAbsent(this.symbol, this))) {
            return (Unit)object;
        }
        return this;
    }
}

