/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.referencing.CS_CoordinateSystem;
import org.apache.sis.internal.jaxb.referencing.SC_DerivedCRSType;
import org.apache.sis.internal.jaxb.referencing.SC_SingleCRS;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.crs.ExplicitParameters;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;

@XmlType(name="DerivedCRSType", propOrder={"baseCRS", "type", "coordinateSystem"})
@XmlRootElement(name="DerivedCRS")
public class DefaultDerivedCRS
extends AbstractDerivedCRS<Conversion>
implements DerivedCRS {
    private static final long serialVersionUID = -8149602276542469876L;

    protected DefaultDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, singleCRS, conversion, coordinateSystem);
    }

    protected DefaultDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        super(map, singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
    }

    protected DefaultDerivedCRS(DerivedCRS derivedCRS) {
        super(derivedCRS);
    }

    public static DefaultDerivedCRS create(Map<String, ?> map, SingleCRS singleCRS, Conversion conversion, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        String string;
        if (singleCRS != null && coordinateSystem != null && (string = DefaultDerivedCRS.getType(singleCRS, coordinateSystem)) != null) {
            switch (string) {
                case "GeodeticCRS": {
                    return new Geodetic(map, (GeodeticCRS)singleCRS, conversion, coordinateSystem);
                }
                case "VerticalCRS": {
                    return new Vertical(map, (VerticalCRS)singleCRS, conversion, (VerticalCS)coordinateSystem);
                }
                case "TimeCRS": {
                    return new Temporal(map, (TemporalCRS)singleCRS, conversion, (TimeCS)coordinateSystem);
                }
                case "ParametricCRS": {
                    return new Parametric(map, (ParametricCRS)singleCRS, conversion, (DefaultParametricCS)coordinateSystem);
                }
                case "EngineeringCRS": {
                    if (!(singleCRS instanceof EngineeringCRS)) break;
                    return new Engineering(map, (EngineeringCRS)singleCRS, conversion, coordinateSystem);
                }
            }
        }
        return new DefaultDerivedCRS(map, singleCRS, conversion, coordinateSystem);
    }

    public static DefaultDerivedCRS create(Map<String, ?> map, SingleCRS singleCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        String string;
        if (singleCRS != null && coordinateSystem != null && (string = DefaultDerivedCRS.getType(singleCRS, coordinateSystem)) != null) {
            switch (string) {
                case "GeodeticCRS": {
                    return new Geodetic(map, (GeodeticCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
                }
                case "VerticalCRS": {
                    return new Vertical(map, (VerticalCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (VerticalCS)coordinateSystem);
                }
                case "TimeCRS": {
                    return new Temporal(map, (TemporalCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (TimeCS)coordinateSystem);
                }
                case "ParametricCRS": {
                    return new Parametric(map, (ParametricCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, (DefaultParametricCS)coordinateSystem);
                }
                case "EngineeringCRS": {
                    if (!(singleCRS instanceof EngineeringCRS)) break;
                    return new Engineering(map, (EngineeringCRS)singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
                }
            }
        }
        return new DefaultDerivedCRS(map, singleCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
    }

    public static DefaultDerivedCRS castOrCopy(DerivedCRS derivedCRS) {
        if (derivedCRS == null || derivedCRS instanceof DefaultDerivedCRS) {
            return (DefaultDerivedCRS)derivedCRS;
        }
        String string = DefaultDerivedCRS.getType((SingleCRS)derivedCRS.getBaseCRS(), derivedCRS.getCoordinateSystem());
        if (string != null) {
            switch (string) {
                case "GeodeticCRS": {
                    return new Geodetic(derivedCRS);
                }
                case "VerticalCRS": {
                    return new Vertical(derivedCRS);
                }
                case "TimeCRS": {
                    return new Temporal(derivedCRS);
                }
                case "ParametricCRS": {
                    return new Parametric(derivedCRS);
                }
                case "EngineeringCRS": {
                    return new Engineering(derivedCRS);
                }
            }
        }
        return new DefaultDerivedCRS(derivedCRS);
    }

    @Override
    final Class<Conversion> getConversionType() {
        return Conversion.class;
    }

    @Override
    public Class<? extends DerivedCRS> getInterface() {
        return DerivedCRS.class;
    }

    @Override
    public Datum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    @Override
    @XmlElement(name="baseCRS", required=true)
    @XmlJavaTypeAdapter(value=SC_SingleCRS.class)
    public SingleCRS getBaseCRS() {
        return (SingleCRS)super.getConversionFromBase().getSourceCRS();
    }

    @Override
    public Conversion getConversionFromBase() {
        return super.getConversionFromBase();
    }

    @Override
    @XmlElement(name="coordinateSystem", required=true)
    @XmlJavaTypeAdapter(value=CS_CoordinateSystem.class)
    public CoordinateSystem getCoordinateSystem() {
        return super.getCoordinateSystem();
    }

    @Override
    public DefaultDerivedCRS forConvention(AxesConvention axesConvention) {
        return (DefaultDerivedCRS)super.forConvention(axesConvention);
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        Object c = super.getConversionFromBase();
        return new DefaultDerivedCRS(map, (SingleCRS)c.getSourceCRS(), (Conversion)c, coordinateSystem);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return super.equals(object, comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Object object;
        boolean bl;
        Conversion conversion = this.getConversionFromBase();
        if (conversion == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl2 = bl = convention.majorVersion() == 1;
        if (bl) {
            object = conversion.getMathTransform();
            try {
                object = object.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                formatter.setInvalidWKT(this, (Exception)noninvertibleTransformException);
                object = null;
            }
            formatter.newLine();
            formatter.append((MathTransform)object);
        }
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getBaseCRS()));
        if (bl) {
            return "Fitted_CS";
        }
        formatter.newLine();
        formatter.append(new ExplicitParameters(this, "DerivingConversion"));
        if (convention == Convention.INTERNAL || !DefaultDerivedCRS.isBaseCRS(formatter)) {
            object = this.getCoordinateSystem();
            this.formatCS(formatter, (CoordinateSystem)object, ReferencingUtilities.getUnit((CoordinateSystem)object), bl);
        }
        return this.keyword(formatter);
    }

    String keyword(Formatter formatter) {
        String string;
        String string2 = DefaultDerivedCRS.getType(this.getBaseCRS(), this.getCoordinateSystem());
        if (string2 == null) {
            return null;
        }
        switch (string2) {
            case "GeodeticCRS": {
                string = "GeodCRS";
                break;
            }
            case "VerticalCRS": {
                string = "VertCRS";
                break;
            }
            case "EngineeringCRS": {
                string = "EngCRS";
                break;
            }
            default: {
                return string2;
            }
        }
        return formatter.shortOrLong(string, string2);
    }

    static String getType(SingleCRS singleCRS, CoordinateSystem coordinateSystem) {
        Class<IdentifiedObject> clazz;
        if (singleCRS instanceof AbstractIdentifiedObject) {
            clazz = ((AbstractIdentifiedObject)((Object)singleCRS)).getInterface();
        } else if (singleCRS != null) {
            clazz = singleCRS.getClass();
        } else {
            return null;
        }
        if (GeodeticCRS.class.isAssignableFrom(clazz) && CoordinateSystems.isGeodetic(coordinateSystem)) {
            return "GeodeticCRS";
        }
        if (VerticalCRS.class.isAssignableFrom(clazz) && coordinateSystem instanceof VerticalCS) {
            return "VerticalCRS";
        }
        if (TemporalCRS.class.isAssignableFrom(clazz) && coordinateSystem instanceof TimeCS) {
            return "TimeCRS";
        }
        if (ParametricCRS.class.isAssignableFrom(clazz) && coordinateSystem instanceof DefaultParametricCS) {
            return "ParametricCRS";
        }
        if (ProjectedCRS.class.isAssignableFrom(clazz) || EngineeringCRS.class.isAssignableFrom(clazz)) {
            return "EngineeringCRS";
        }
        return null;
    }

    private DefaultDerivedCRS() {
    }

    @XmlElement(name="derivedCRSType", required=true)
    SC_DerivedCRSType getType() {
        return SC_DerivedCRSType.fromWKT(DefaultDerivedCRS.getType(this.getBaseCRS(), this.getCoordinateSystem()));
    }

    private void setBaseCRS(SingleCRS singleCRS) {
        this.setBaseCRS("baseCRS", singleCRS);
    }

    private void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.setCoordinateSystem("coordinateSystem", coordinateSystem);
    }

    @XmlTransient
    private static final class Geodetic
    extends DefaultDerivedCRS
    implements GeodeticCRS {
        private static final long serialVersionUID = -1263243517380302846L;

        Geodetic(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Geodetic(Map<String, ?> map, GeodeticCRS geodeticCRS, Conversion conversion, CoordinateSystem coordinateSystem) {
            super(map, geodeticCRS, conversion, coordinateSystem);
        }

        Geodetic(Map<String, ?> map, GeodeticCRS geodeticCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
            super(map, geodeticCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
        }

        @Override
        public GeodeticDatum getDatum() {
            return (GeodeticDatum)super.getDatum();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Geodetic(map, (GeodeticCRS)conversion.getSourceCRS(), conversion, coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("GeodCRS", "GeodeticCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("geodetic");
        }
    }

    @XmlTransient
    private static final class Vertical
    extends DefaultDerivedCRS
    implements VerticalCRS {
        private static final long serialVersionUID = -5599709829566076972L;

        Vertical(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Vertical(Map<String, ?> map, VerticalCRS verticalCRS, Conversion conversion, VerticalCS verticalCS) {
            super(map, verticalCRS, conversion, verticalCS);
        }

        Vertical(Map<String, ?> map, VerticalCRS verticalCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, VerticalCS verticalCS) {
            super(map, verticalCRS, coordinateReferenceSystem, operationMethod, mathTransform, verticalCS);
        }

        @Override
        public VerticalDatum getDatum() {
            return (VerticalDatum)super.getDatum();
        }

        @Override
        public VerticalCS getCoordinateSystem() {
            return (VerticalCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Vertical(map, (VerticalCRS)conversion.getSourceCRS(), conversion, (VerticalCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("VertCRS", "VerticalCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("vertical");
        }
    }

    @XmlTransient
    private static final class Temporal
    extends DefaultDerivedCRS
    implements TemporalCRS {
        private static final long serialVersionUID = -4721311735720248819L;

        Temporal(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Temporal(Map<String, ?> map, TemporalCRS temporalCRS, Conversion conversion, TimeCS timeCS) {
            super(map, temporalCRS, conversion, timeCS);
        }

        Temporal(Map<String, ?> map, TemporalCRS temporalCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, TimeCS timeCS) {
            super(map, temporalCRS, coordinateReferenceSystem, operationMethod, mathTransform, timeCS);
        }

        @Override
        public TemporalDatum getDatum() {
            return (TemporalDatum)super.getDatum();
        }

        @Override
        public TimeCS getCoordinateSystem() {
            return (TimeCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Temporal(map, (TemporalCRS)conversion.getSourceCRS(), conversion, (TimeCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return "TimeCRS";
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("time");
        }
    }

    @XmlTransient
    private static final class Parametric
    extends DefaultDerivedCRS
    implements ParametricCRS {
        private static final long serialVersionUID = 2344979923957294024L;

        Parametric(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Parametric(Map<String, ?> map, ParametricCRS parametricCRS, Conversion conversion, DefaultParametricCS defaultParametricCS) {
            super(map, parametricCRS, conversion, defaultParametricCS);
        }

        Parametric(Map<String, ?> map, ParametricCRS parametricCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, DefaultParametricCS defaultParametricCS) {
            super(map, parametricCRS, coordinateReferenceSystem, operationMethod, mathTransform, defaultParametricCS);
        }

        @Override
        public DefaultParametricDatum getDatum() {
            return (DefaultParametricDatum)super.getDatum();
        }

        @Override
        public DefaultParametricCS getCoordinateSystem() {
            return (DefaultParametricCS)super.getCoordinateSystem();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Parametric(map, (ParametricCRS)conversion.getSourceCRS(), conversion, (DefaultParametricCS)coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return "ParametricCRS";
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("parametric");
        }
    }

    @XmlTransient
    private static final class Engineering
    extends DefaultDerivedCRS
    implements EngineeringCRS {
        private static final long serialVersionUID = 42334975023270039L;

        Engineering(DerivedCRS derivedCRS) {
            super(derivedCRS);
        }

        Engineering(Map<String, ?> map, EngineeringCRS engineeringCRS, Conversion conversion, CoordinateSystem coordinateSystem) {
            super(map, engineeringCRS, conversion, coordinateSystem);
        }

        Engineering(Map<String, ?> map, EngineeringCRS engineeringCRS, CoordinateReferenceSystem coordinateReferenceSystem, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
            super(map, engineeringCRS, coordinateReferenceSystem, operationMethod, mathTransform, coordinateSystem);
        }

        @Override
        public EngineeringDatum getDatum() {
            return (EngineeringDatum)super.getDatum();
        }

        @Override
        AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
            Conversion conversion = this.getConversionFromBase();
            return new Engineering(map, (EngineeringCRS)conversion.getSourceCRS(), conversion, coordinateSystem);
        }

        @Override
        String keyword(Formatter formatter) {
            return formatter.shortOrLong("EngCRS", "EngineeringCRS");
        }

        @Override
        SC_DerivedCRSType getType() {
            return new SC_DerivedCRSType("engineering");
        }
    }
}

