/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import jakarta.ws.rs.core.Application;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Invoker;

public class JAXRSServerFactoryBean
extends AbstractJAXRSFactoryBean {
    protected Map<Class<?>, ResourceProvider> resourceProviders = new HashMap();
    private Server server;
    private boolean start = true;
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;
    private ResourceComparator rc;
    private ApplicationInfo appProvider;
    private String documentLocation;

    public JAXRSServerFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
        super(sf);
    }

    public void setApplication(Application app) {
        this.setApplicationInfo(new ApplicationInfo(app, this.getBus()));
    }

    public void setApplicationInfo(ApplicationInfo provider) {
        this.appProvider = provider;
        Set<String> appNameBindings = AnnotationUtils.getNameBindings(this.bus, ((Application)provider.getProvider()).getClass());
        for (ClassResourceInfo cri : this.getServiceFactory().getClassResourceInfo()) {
            LinkedHashSet<String> clsNameBindings = new LinkedHashSet<String>(appNameBindings);
            clsNameBindings.addAll(AnnotationUtils.getNameBindings(this.bus, cri.getServiceClass()));
            cri.setNameBindings(clsNameBindings);
        }
    }

    public void setResourceComparator(ResourceComparator rcomp) {
        this.rc = rcomp;
    }

    public void setStaticSubresourceResolution(boolean enableStatic) {
        this.serviceFactory.setEnableStaticResolution(enableStatic);
    }

    public void init() {
        if (this.server == null) {
            this.create();
        }
    }

    public Server create() {
        block15: {
            ClassLoaderUtils.ClassLoaderHolder origLoader = null;
            try {
                Bus bus = this.getBus();
                ClassLoader loader = bus.getExtension(ClassLoader.class);
                if (loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader(loader);
                }
                this.serviceFactory.setBus(bus);
                this.checkResources(true);
                if (this.serviceFactory.getService() == null) {
                    this.serviceFactory.create();
                }
                Endpoint ep = this.createEndpoint();
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.PRE_SERVER_CREATE, this.server);
                this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
                Invoker invoker = this.serviceFactory.getInvoker();
                if (invoker == null) {
                    ep.getService().setInvoker(this.createInvoker());
                } else {
                    ep.getService().setInvoker(invoker);
                }
                ServerProviderFactory factory = this.setupFactory(ep);
                ep.put(Application.class.getName(), this.appProvider);
                factory.setRequestPreprocessor(new RequestPreprocessor(this.languageMappings, this.extensionMappings));
                ep.put(Bus.class.getName(), this.getBus());
                if (this.documentLocation != null) {
                    ep.put("wadl.location", this.documentLocation);
                }
                if (this.rc != null) {
                    ep.put("org.apache.cxf.jaxrs.comparator", this.rc);
                }
                this.checkPrivateEndpoint(ep);
                this.applyBusFeatures(this.getBus());
                this.applyFeatures();
                this.updateClassResourceProviders(ep);
                this.injectContexts(factory, (ApplicationInfo)ep.get(Application.class.getName()));
                factory.applyDynamicFeatures(this.getServiceFactory().getClassResourceInfo());
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.SERVER_CREATED, this.server, null, null);
                if (!this.start) break block15;
                try {
                    this.server.start();
                }
                catch (RuntimeException re) {
                    if (!(re instanceof ServiceConstructionException) || !re.getMessage().startsWith("There is an endpoint already running on")) {
                        this.server.destroy();
                    }
                    throw re;
                }
            }
            catch (Exception e) {
                throw new ServiceConstructionException(e);
            }
            finally {
                if (origLoader != null) {
                    origLoader.reset();
                }
            }
        }
        return this.server;
    }

    public Server getServer() {
        return this.server;
    }

    protected ServerProviderFactory setupFactory(Endpoint ep) {
        ServerProviderFactory factory = ServerProviderFactory.createInstance(this.getBus());
        this.setBeanInfo(factory);
        factory.setApplicationProvider(this.appProvider);
        super.setupFactory(factory, ep);
        return factory;
    }

    protected void setBeanInfo(ServerProviderFactory factory) {
        List<ClassResourceInfo> cris = this.serviceFactory.getClassResourceInfo();
        for (ClassResourceInfo cri : cris) {
            cri.initBeanParamInfo(factory);
        }
    }

    protected void applyBusFeatures(Bus bus) {
        if (bus.getFeatures() != null) {
            for (Feature feature : bus.getFeatures()) {
                feature.initialize(this.server, bus);
            }
        }
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (Feature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected Invoker createInvoker() {
        return this.serviceFactory.createInvoker();
    }

    public void setLanguageMappings(Map<Object, Object> lMaps) {
        this.languageMappings = lMaps;
    }

    public void setExtensionMappings(Map<Object, Object> extMaps) {
        this.extensionMappings = extMaps;
    }

    public List<Class<?>> getResourceClasses() {
        return this.serviceFactory.getResourceClasses();
    }

    public void setServiceClass(Class<?> clazz) {
        this.serviceFactory.setResourceClasses(clazz);
    }

    public void setResourceClasses(List<Class<?>> classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setServiceBeanObjects(Object ... beans) {
        this.setServiceBeans(Arrays.asList(beans));
    }

    public void setServiceBean(Object bean) {
        this.setServiceBeans(Arrays.asList(bean));
    }

    public void setServiceBeans(List<Object> beans) {
        ArrayList<Object> newBeans = new ArrayList<Object>();
        JAXRSServerFactoryBean.addToBeans(newBeans, beans);
        this.serviceFactory.setResourceClassesFromBeans(newBeans);
    }

    public void setResourceProvider(Class<?> c, ResourceProvider rp) {
        this.resourceProviders.put(c, rp);
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.setResourceProviders(CastUtils.cast(Collections.singletonList(rp), ResourceProvider.class));
    }

    public void setResourceProviders(List<ResourceProvider> rps) {
        for (ResourceProvider rp : rps) {
            Class<?> c = rp.getResourceClass();
            this.setServiceClass(c);
            this.resourceProviders.put(c, rp);
        }
    }

    public void setInvoker(Invoker invoker) {
        this.serviceFactory.setInvoker(invoker);
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void injectContexts(ServerProviderFactory factory, ApplicationInfo fallback) {
        ApplicationInfo appInfoProvider = this.appProvider == null ? fallback : this.appProvider;
        Application application = appInfoProvider == null ? null : (Application)appInfoProvider.getProvider();
        for (ClassResourceInfo cri : this.serviceFactory.getClassResourceInfo()) {
            if (!cri.isSingleton()) continue;
            InjectionUtils.injectContextProxiesAndApplication(cri, cri.getResourceProvider().getInstance(null), application, factory);
        }
        if (application != null) {
            InjectionUtils.injectContextProxiesAndApplication(appInfoProvider, application, null, null);
        }
    }

    protected void updateClassResourceProviders(Endpoint ep) {
        for (ClassResourceInfo cri : this.serviceFactory.getClassResourceInfo()) {
            if (cri.getResourceProvider() == null) {
                ResourceProvider rp = this.resourceProviders.get(cri.getResourceClass());
                if (rp != null) {
                    cri.setResourceProvider(rp);
                } else {
                    this.setDefaultResourceProvider(cri);
                }
            }
            if (!(cri.getResourceProvider() instanceof SingletonResourceProvider)) continue;
            ((SingletonResourceProvider)cri.getResourceProvider()).init(ep);
        }
    }

    protected void setDefaultResourceProvider(ClassResourceInfo cri) {
        cri.setResourceProvider(new PerRequestResourceProvider(cri.getResourceClass()));
    }

    public void setDocLocation(String docLocation) {
        this.documentLocation = docLocation;
    }

    public String getDocLocation() {
        return this.documentLocation;
    }
}

