/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectBLOBDataDeclaration;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class ObjectGroupDeclarations
extends StreamObject {
    public List<ObjectGroupObjectDeclare> objectDeclarationList = new ArrayList<ObjectGroupObjectDeclare>();
    public List<ObjectGroupObjectBLOBDataDeclaration> objectGroupObjectBLOBDataDeclarationList = new ArrayList<ObjectGroupObjectBLOBDataDeclaration>();

    public ObjectGroupDeclarations() {
        super(StreamObjectTypeHeaderStart.ObjectGroupDeclarations);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        if (lengthOfItems != 0) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "ObjectGroupDeclarations", "Stream object over-parse error", null);
        }
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        int headerLength = 0;
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        this.objectDeclarationList = new ArrayList<ObjectGroupObjectDeclare>();
        this.objectGroupObjectBLOBDataDeclarationList = new ArrayList<ObjectGroupObjectBLOBDataDeclaration>();
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            if (header.get().type == StreamObjectTypeHeaderStart.ObjectGroupObjectDeclare) {
                index.addAndGet(headerLength);
                this.objectDeclarationList.add((ObjectGroupObjectDeclare)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            if (header.get().type == StreamObjectTypeHeaderStart.ObjectGroupObjectBLOBDataDeclaration) {
                index.addAndGet(headerLength);
                this.objectGroupObjectBLOBDataDeclarationList.add((ObjectGroupObjectBLOBDataDeclaration)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new StreamObjectParseErrorException(index.get(), "ObjectGroupDeclarations", "Failed to parse ObjectGroupDeclarations, expect the inner object type either ObjectGroupObjectDeclare or ObjectGroupObjectBLOBDataDeclaration, but actual type value is " + String.valueOf((Object)header.get().type), null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws TikaException, IOException {
        if (this.objectDeclarationList != null) {
            for (ObjectGroupObjectDeclare objectGroupObjectDeclare : this.objectDeclarationList) {
                byteList.addAll(objectGroupObjectDeclare.serializeToByteList());
            }
        }
        if (this.objectGroupObjectBLOBDataDeclarationList != null) {
            for (ObjectGroupObjectBLOBDataDeclaration objectGroupObjectBLOBDataDeclaration : this.objectGroupObjectBLOBDataDeclarationList) {
                byteList.addAll(objectGroupObjectBLOBDataDeclaration.serializeToByteList());
            }
        }
        return 0;
    }
}

