/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.LenientComparable;

public enum ComparisonMode {
    STRICT,
    BY_CONTRACT,
    IGNORE_METADATA,
    APPROXIMATE,
    ALLOW_VARIANT,
    DEBUG;


    public boolean isIgnoringMetadata() {
        return this.ordinal() >= IGNORE_METADATA.ordinal();
    }

    public boolean isApproximate() {
        return this.ordinal() >= APPROXIMATE.ordinal();
    }

    public static ComparisonMode equalityLevel(Object o1, Object o2) {
        if (o1 == o2) {
            return STRICT;
        }
        if (o1 != null && o2 != null) {
            LenientComparable cp;
            if (o1.equals(o2)) {
                return STRICT;
            }
            if (o1 instanceof LenientComparable) {
                cp = (LenientComparable)o1;
            } else if (o2 instanceof LenientComparable) {
                cp = (LenientComparable)o2;
                o2 = o1;
            } else {
                return null;
            }
            if (cp.equals(o2, BY_CONTRACT)) {
                return BY_CONTRACT;
            }
            if (cp.equals(o2, IGNORE_METADATA)) {
                return IGNORE_METADATA;
            }
            if (cp.equals(o2, APPROXIMATE)) {
                return APPROXIMATE;
            }
            if (cp.equals(o2, ALLOW_VARIANT)) {
                return ALLOW_VARIANT;
            }
        }
        return null;
    }
}

