/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.translator;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class DotNetTranslator
implements Translator.ScriptTranslator {
    private final String traversalSource;
    private final Translator.ScriptTranslator.TypeTranslator typeTranslator;
    private static final List<String> methodsWithArgsNotNeedingGeneric = Arrays.asList("group", "groupCount", "sack");

    private DotNetTranslator(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        this.traversalSource = traversalSource;
        this.typeTranslator = typeTranslator;
    }

    public static DotNetTranslator of(String traversalSource) {
        return DotNetTranslator.of(traversalSource, false);
    }

    public static DotNetTranslator of(String traversalSource, boolean withParameters) {
        return DotNetTranslator.of(traversalSource, new DefaultTypeTranslator(withParameters));
    }

    public static DotNetTranslator of(String traversalSource, Translator.ScriptTranslator.TypeTranslator typeTranslator) {
        return new DotNetTranslator(traversalSource, typeTranslator);
    }

    @Override
    public Script translate(Bytecode bytecode) {
        return (Script)this.typeTranslator.apply(this.traversalSource, bytecode);
    }

    @Override
    public String getTargetLanguage() {
        return "gremlin-dotnet";
    }

    public String toString() {
        return StringFactory.translatorString(this);
    }

    @Override
    public String getTraversalSource() {
        return this.traversalSource;
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_CS_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_CS_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toCSharp(String symbol) {
            return TO_CS_MAP.getOrDefault(symbol, symbol.substring(0, 1).toUpperCase() + symbol.substring(1));
        }

        public static String toJava(String symbol) {
            return FROM_CS_MAP.getOrDefault(symbol, symbol.substring(0, 1).toLowerCase() + symbol.substring(1));
        }

        static {
            TO_CS_MAP.put("branch", "Branch<object>");
            TO_CS_MAP.put("call", "Call<object>");
            TO_CS_MAP.put("cap", "Cap<object>");
            TO_CS_MAP.put("choose", "Choose<object>");
            TO_CS_MAP.put("coalesce", "Coalesce<object>");
            TO_CS_MAP.put("constant", "Constant<object>");
            TO_CS_MAP.put("elementMap", "ElementMap<object>");
            TO_CS_MAP.put("flatMap", "FlatMap<object>");
            TO_CS_MAP.put("fold", "Fold<object>");
            TO_CS_MAP.put("group", "Group<object,object>");
            TO_CS_MAP.put("groupCount", "GroupCount<object>");
            TO_CS_MAP.put("index", "Index<object>");
            TO_CS_MAP.put("inject", "Inject<object>");
            TO_CS_MAP.put("io", "Io<object>");
            TO_CS_MAP.put("limit", "Limit<object>");
            TO_CS_MAP.put("local", "Local<object>");
            TO_CS_MAP.put("match", "Match<object>");
            TO_CS_MAP.put("map", "Map<object>");
            TO_CS_MAP.put("max", "Max<object>");
            TO_CS_MAP.put("min", "Min<object>");
            TO_CS_MAP.put("mean", "Mean<object>");
            TO_CS_MAP.put("optional", "Optional<object>");
            TO_CS_MAP.put("project", "Project<object>");
            TO_CS_MAP.put("properties", "Properties<object>");
            TO_CS_MAP.put("range", "Range<object>");
            TO_CS_MAP.put("sack", "Sack<object>");
            TO_CS_MAP.put("select", "Select<object>");
            TO_CS_MAP.put("skip", "Skip<object>");
            TO_CS_MAP.put("sum", "Sum<object>");
            TO_CS_MAP.put("tail", "Tail<object>");
            TO_CS_MAP.put("unfold", "Unfold<object>");
            TO_CS_MAP.put("union", "Union<object>");
            TO_CS_MAP.put("value", "Value<object>");
            TO_CS_MAP.put("valueMap", "ValueMap<object,object>");
            TO_CS_MAP.put("values", "Values<object>");
            TO_CS_MAP.forEach((k, v) -> FROM_CS_MAP.put((String)v, (String)k));
        }
    }

    public static class DefaultTypeTranslator
    extends Translator.ScriptTranslator.AbstractTypeTranslator {
        public DefaultTypeTranslator(boolean withParameters) {
            super(withParameters);
        }

        @Override
        protected String getNullSyntax() {
            return "null";
        }

        @Override
        protected String getSyntax(String o) {
            return "\"" + StringEscapeUtils.escapeJava((String)o) + "\"";
        }

        @Override
        protected String getSyntax(Boolean o) {
            return o.toString();
        }

        @Override
        protected String getSyntax(Date o) {
            return "DateTimeOffset.FromUnixTimeMilliseconds(" + o.getTime() + ")";
        }

        @Override
        protected String getSyntax(Timestamp o) {
            return "DateTimeOffset.FromUnixTimeMilliseconds(" + o.getTime() + ")";
        }

        @Override
        protected String getSyntax(UUID o) {
            return "new Guid(\"" + o.toString() + "\")";
        }

        @Override
        protected String getSyntax(Lambda o) {
            return "Lambda.Groovy(\"" + StringEscapeUtils.escapeEcmaScript((String)o.getLambdaScript().trim()) + "\")";
        }

        @Override
        protected String getSyntax(SackFunctions.Barrier o) {
            return "Barrier." + SymbolHelper.toCSharp(o.toString());
        }

        @Override
        protected String getSyntax(VertexProperty.Cardinality o) {
            return "Cardinality." + SymbolHelper.toCSharp(o.toString());
        }

        @Override
        protected String getSyntax(Pick o) {
            return "Pick." + SymbolHelper.toCSharp(o.toString());
        }

        @Override
        protected String getSyntax(Number o) {
            if (o instanceof Float || o instanceof Double) {
                if (NumberHelper.isNaN(o)) {
                    return (o instanceof Float ? "Single" : "Double") + ".NaN";
                }
                if (NumberHelper.isPositiveInfinity(o)) {
                    return (o instanceof Float ? "Single" : "Double") + ".PositiveInfinity";
                }
                if (NumberHelper.isNegativeInfinity(o)) {
                    return (o instanceof Float ? "Single" : "Double") + ".NegativeInfinity";
                }
            }
            return o.toString();
        }

        @Override
        protected Script produceScript(Set<?> o) {
            return this.produceScriptForHashSet(o, "object");
        }

        private Script produceScriptForHashSet(Set<?> o, String generic) {
            Iterator<?> iterator = o.iterator();
            this.script.append("new HashSet<");
            this.script.append(generic);
            this.script.append("> {");
            while (iterator.hasNext()) {
                Object nextItem = iterator.next();
                this.convertToScript(nextItem);
                if (!iterator.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(List<?> o) {
            Iterator<?> iterator = o.iterator();
            this.script.append("new List<object> {");
            while (iterator.hasNext()) {
                Object nextItem = iterator.next();
                this.convertToScript(nextItem);
                if (!iterator.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(Map<?, ?> o) {
            this.script.append("new Dictionary<object,object> {");
            this.produceKeyValuesForMap(o);
            return this.script.append("}");
        }

        @Override
        protected Script produceScript(Class<?> o) {
            return this.script.append(o.getCanonicalName());
        }

        @Override
        protected Script produceScript(Enum<?> o) {
            String e = o instanceof Direction ? o.name().substring(0, 1).toUpperCase() + o.name().substring(1).toLowerCase() : o.name().substring(0, 1).toUpperCase() + o.name().substring(1);
            return this.script.append(o.getDeclaringClass().getSimpleName() + "." + e);
        }

        @Override
        protected Script produceScript(Vertex o) {
            this.script.append("new Vertex(");
            this.convertToScript(o.id());
            this.script.append(", ");
            this.convertToScript(o.label());
            return this.script.append(")");
        }

        @Override
        protected Script produceScript(Edge o) {
            this.script.append("new Edge(");
            this.convertToScript(o.id());
            this.script.append(", new Vertex(");
            this.convertToScript(o.outVertex().id());
            this.script.append(", ");
            this.convertToScript(o.outVertex().label());
            this.script.append("), ");
            this.convertToScript(o.label());
            this.script.append(", new Vertex(");
            this.convertToScript(o.inVertex().id());
            this.script.append(", ");
            this.convertToScript(o.inVertex().label());
            return this.script.append("))");
        }

        @Override
        protected Script produceScript(VertexProperty<?> o) {
            this.script.append("new VertexProperty(");
            this.convertToScript(o.id());
            this.script.append(", ");
            this.convertToScript(o.label());
            this.script.append(", ");
            this.convertToScript(o.value());
            this.script.append(", ");
            return this.script.append("null)");
        }

        @Override
        protected Script produceScript(TraversalStrategyProxy<?> o) {
            if (o.getConfiguration().isEmpty()) {
                return this.script.append("new " + o.getStrategyClass().getSimpleName() + "()");
            }
            this.script.append("new " + o.getStrategyClass().getSimpleName() + "(");
            Iterator keys = IteratorUtils.stream(o.getConfiguration().getKeys()).filter(e -> !e.equals("strategy")).iterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                this.script.append(k);
                this.script.append(": ");
                if (k.equals("readPartitions") && o.getStrategyClass().equals(PartitionStrategy.class)) {
                    this.produceScriptForHashSet((Set)o.getConfiguration().getProperty(k), "string");
                } else {
                    this.convertToScript(o.getConfiguration().getProperty(k));
                }
                if (!keys.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script.append(")");
        }

        private Script produceKeyValuesForMap(Map<?, ?> m) {
            Iterator<Map.Entry<?, ?>> itty = m.entrySet().iterator();
            while (itty.hasNext()) {
                Map.Entry<?, ?> entry = itty.next();
                this.script.append("{");
                this.convertToScript(entry.getKey());
                this.script.append(", ");
                this.convertToScript(entry.getValue());
                this.script.append("}");
                if (!itty.hasNext()) continue;
                this.script.append(", ");
            }
            return this.script;
        }

        @Override
        protected Script produceScript(String traversalSource, Bytecode o) {
            this.script.append(traversalSource);
            int instructionPosition = 0;
            for (Bytecode.Instruction instruction : o.getInstructions()) {
                String methodName = instruction.getOperator();
                if (0 == instruction.getArguments().length) {
                    if (methodName.equals("fold") && o.getSourceInstructions().size() + o.getStepInstructions().size() > 1 || methodName.equals("inject") && instructionPosition > 0) {
                        this.script.append(".").append(this.resolveSymbol(methodName).replace("<object>", "")).append("()");
                    } else {
                        this.script.append(".").append(this.resolveSymbol(methodName)).append("()");
                    }
                } else {
                    Object[] instArgs;
                    if (methodsWithArgsNotNeedingGeneric.contains(methodName) || methodName.equals("inject") && (Arrays.stream(instruction.getArguments()).noneMatch(Objects::isNull) || instructionPosition > 0)) {
                        this.script.append(".").append(this.resolveSymbol(methodName).replace("<object>", "").replace("<object,object>", "")).append("(");
                    } else {
                        this.script.append(".").append(this.resolveSymbol(methodName)).append("(");
                    }
                    if (methodName.equals("withSack") && instruction.getArguments().length == 2 && instruction.getArguments()[1] instanceof Lambda) {
                        String castSecondArgTo;
                        String castFirstArgTo = instruction.getArguments()[0] instanceof Lambda ? "ISupplier" : "";
                        Lambda secondArg = (Lambda)instruction.getArguments()[1];
                        String string = castSecondArgTo = secondArg.getLambdaArguments() == 1 ? "IUnaryOperator" : "IBinaryOperator";
                        if (!castFirstArgTo.isEmpty()) {
                            this.script.append(String.format("(%s) ", castFirstArgTo));
                        }
                        this.convertToScript(instruction.getArguments()[0]);
                        this.script.append(", (").append(castSecondArgTo).append(") ");
                        this.convertToScript(instruction.getArguments()[1]);
                        this.script.append(",");
                    } else if (methodName.equals("mergeE") || methodName.equals("mergeV")) {
                        Object instArg = instruction.getArguments()[0];
                        if (null == instArg) {
                            this.script.append("(IDictionary<object,object>) null");
                        } else {
                            if (instArg instanceof Traversal || instArg instanceof Bytecode) {
                                this.script.append("(ITraversal) ");
                            } else {
                                this.script.append("(IDictionary<object,object>) ");
                            }
                            this.convertToScript(instArg);
                        }
                        this.script.append(",");
                    } else if (methodName.equals("tx")) {
                        String command = this.resolveSymbol(instruction.getArguments()[0].toString());
                        this.script.append(").").append(command).append("()");
                    } else if (methodName.equals("call")) {
                        instArgs = instruction.getArguments();
                        if (instArgs.length > 0) {
                            this.convertToScript(instArgs[0]);
                            this.script.append(",");
                        }
                        if (instArgs.length > 1) {
                            if (instArgs[1] instanceof Traversal || instArgs[1] instanceof Bytecode) {
                                this.script.append("(ITraversal) ");
                            } else {
                                this.script.append("(IDictionary<object,object>) ");
                            }
                            this.convertToScript(instArgs[1]);
                            this.script.append(",");
                        }
                        if (instArgs.length > 2) {
                            this.script.append("(ITraversal) ");
                            this.convertToScript(instArgs[2]);
                            this.script.append(",");
                        }
                    } else if (methodName.equals("option") && instruction.getArguments().length == 2 && instruction.getArguments()[0] instanceof Merge) {
                        instArgs = instruction.getArguments();
                        this.convertToScript(instArgs[0]);
                        this.script.append(", ");
                        if (instArgs[1] instanceof Traversal || instArgs[1] instanceof Bytecode) {
                            this.script.append("(ITraversal) ");
                        } else {
                            this.script.append("(IDictionary<object,object>) ");
                        }
                        this.convertToScript(instArgs[1]);
                        this.script.append(",");
                    } else {
                        instArgs = instruction.getArguments();
                        for (int idx = 0; idx < instArgs.length; ++idx) {
                            Object instArg = instArgs[idx];
                            if (null == instArg) {
                                if (methodName.equals("addV") && idx % 2 == 0 || methodName.equals("hasLabel") && instArgs.length == 1 && idx == 0 || methodName.equals("hasKey") && instArgs.length == 1 && idx == 0) {
                                    this.script.append("(string) ");
                                } else if (methodName.equals("hasValue") && idx == 0) {
                                    this.script.append("(object) ");
                                } else if (methodName.equals("has")) {
                                    if (instArgs.length == 2) {
                                        if (null == instArgs[0] && idx == 0) {
                                            this.script.append("(string)");
                                        } else if ((instArgs[0] instanceof T || instArgs[0] instanceof String) && idx == 1) {
                                            this.script.append("(object) ");
                                        }
                                    } else if (instArgs.length == 3) {
                                        if ((instArgs[0] instanceof T || instArgs[0] instanceof String) && idx == 1) {
                                            this.script.append("(string) ");
                                        } else if ((instArgs[0] instanceof T || instArgs[0] instanceof String) && idx == 2) {
                                            this.script.append("(object) ");
                                        }
                                    }
                                } else if (methodName.equals("property") && instArgs[0] instanceof VertexProperty.Cardinality && instArgs.length == 3) {
                                    this.script.append("(object) ");
                                }
                            }
                            this.convertToScript(instArg);
                            this.script.append(",");
                        }
                    }
                    this.script.setCharAtEnd(')');
                }
                ++instructionPosition;
            }
            return this.script;
        }

        @Override
        protected Script produceScript(P<?> p) {
            if (p instanceof TextP) {
                this.script.append("TextP.").append(SymbolHelper.toCSharp(p.getPredicateName())).append("(");
                this.convertToScript(p.getValue());
            } else if (p instanceof ConnectiveP) {
                List list = ((ConnectiveP)p).getPredicates();
                String connector = p instanceof OrP ? "Or" : "And";
                for (int i = 0; i < list.size(); ++i) {
                    this.produceScript(list.get(i));
                    if (i > 0 && i < list.size() - 1) {
                        this.script.append(")");
                    }
                    if (i >= list.size() - 1) continue;
                    this.script.append(".").append(connector).append("(");
                }
            } else {
                this.script.append("P.").append(SymbolHelper.toCSharp(p.getPredicateName())).append("(");
                this.convertToScript(p.getValue());
            }
            this.script.append(")");
            return this.script;
        }

        protected String resolveSymbol(String methodName) {
            return SymbolHelper.toCSharp(methodName);
        }
    }
}

