/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import org.apache.tinkerpop.gremlin.server.handler.AbstractSession;
import org.apache.tinkerpop.gremlin.server.handler.Session;
import org.apache.tinkerpop.gremlin.server.handler.SessionException;
import org.apache.tinkerpop.gremlin.server.handler.SessionTask;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTaskSession
extends AbstractSession {
    private static final Logger logger = LoggerFactory.getLogger(SingleTaskSession.class);
    protected final SessionTask onlySessionTask;

    public SingleTaskSession(SessionTask onlySessionTask, String sessionId, ConcurrentMap<String, Session> sessions) {
        super(onlySessionTask, sessionId, true, sessions);
        this.onlySessionTask = onlySessionTask;
    }

    @Override
    public boolean isAcceptingTasks() {
        return false;
    }

    @Override
    public void sendTimeoutResponseForUncommencedTask() {
        this.onlySessionTask.sendTimeoutResponse();
    }

    @Override
    public boolean submitTask(SessionTask sessionTask) throws RejectedExecutionException {
        throw new UnsupportedOperationException("SingleWorker doesn't accept tasks beyond the one provided to the constructor");
    }

    @Override
    public void run() {
        this.sessionTaskStarted.set(true);
        this.sessionThread = Thread.currentThread();
        try {
            this.startTransaction(this.onlySessionTask);
            this.process(this.onlySessionTask);
        }
        catch (SessionException we) {
            this.closeReason.compareAndSet(null, AbstractSession.CloseReason.PROCESSING_EXCEPTION);
            logger.warn(we.getMessage(), (Throwable)we);
            this.closeTransactionSafely(this.onlySessionTask, Transaction.Status.ROLLBACK);
            this.onlySessionTask.writeAndFlush(we.getResponseMessage());
        }
        finally {
            this.closeReason.compareAndSet(null, AbstractSession.CloseReason.EXIT_PROCESSING);
            this.close();
        }
    }

    public String toString() {
        return String.format("%s - session: %s", SingleTaskSession.class.getSimpleName(), this.getSessionId());
    }
}

