/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Deleting;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventCallback;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.keyed.KeyedProperty;
import org.apache.tinkerpop.gremlin.structure.util.keyed.KeyedVertexProperty;

public class AddPropertyStep<S extends Element>
extends SideEffectStep<S>
implements Writing<Event.ElementPropertyChangedEvent>,
Deleting<Event.ElementPropertyChangedEvent>,
TraversalParent,
Scoping {
    private Parameters parameters = new Parameters();
    private final VertexProperty.Cardinality cardinality;
    private CallbackRegistry<Event.ElementPropertyChangedEvent> callbackRegistry;

    public AddPropertyStep(Traversal.Admin traversal, VertexProperty.Cardinality cardinality, Object keyObject, Object valueObject) {
        super(traversal);
        this.parameters.set(this, T.key, keyObject, T.value, valueObject);
        this.cardinality = cardinality;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.parameters.getReferencedLabels();
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.parameters.getTraversals();
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        Object k = this.parameters.get(traverser, T.key, () -> {
            throw new IllegalStateException("The AddPropertyStep does not have a provided key: " + this);
        }).get(0);
        if (k instanceof T) {
            throw new IllegalStateException(String.format("T.%s is immutable on existing elements", ((T)k).name()));
        }
        String key = (String)k;
        Object value = this.parameters.get(traverser, T.value, () -> {
            throw new IllegalStateException("The AddPropertyStep does not have a provided value: " + this);
        }).get(0);
        Object[] vertexPropertyKeyValues = this.parameters.getKeyValues(traverser, T.key, T.value);
        Element element = (Element)traverser.get();
        if (this.cardinality != null && !(element instanceof Vertex)) {
            throw new IllegalStateException(String.format("Property cardinality can only be set for a Vertex but the traversal encountered %s for key: %s", element.getClass().getSimpleName(), key));
        }
        VertexProperty.Cardinality cardinality = this.cardinality != null ? this.cardinality : element.graph().features().vertex().getCardinality(key);
        Optional<EventStrategy> optEventStrategy = this.getTraversal().getStrategies().getStrategy(EventStrategy.class);
        boolean eventingIsConfigured = this.callbackRegistry != null && !this.callbackRegistry.getCallbacks().isEmpty() && optEventStrategy.isPresent();
        EventStrategy es = optEventStrategy.orElse(null);
        Property removedProperty = VertexProperty.empty();
        if (eventingIsConfigured) {
            if (element instanceof Vertex) {
                if (cardinality == VertexProperty.Cardinality.set) {
                    Iterator properties = element.properties(key);
                    while (properties.hasNext()) {
                        Property property = properties.next();
                        if (!Objects.equals(property.value(), value)) continue;
                        removedProperty = property;
                        break;
                    }
                } else if (cardinality == VertexProperty.Cardinality.single) {
                    removedProperty = element.property(key);
                }
            } else {
                removedProperty = element.property(key);
            }
            if (removedProperty.isPresent()) {
                removedProperty = es.detach(removedProperty);
            } else {
                Property property = removedProperty = element instanceof Vertex ? new KeyedVertexProperty(key) : new KeyedProperty(key);
            }
        }
        if (element instanceof Vertex) {
            if (null != this.cardinality) {
                ((Vertex)element).property(this.cardinality, key, value, vertexPropertyKeyValues);
            } else if (vertexPropertyKeyValues.length > 0) {
                ((Vertex)element).property(key, value, vertexPropertyKeyValues);
            } else {
                ((Vertex)element).property(key, value);
            }
        } else if (element instanceof Edge) {
            element.property(key, value);
        } else if (element instanceof VertexProperty) {
            element.property(key, value);
        }
        if (eventingIsConfigured) {
            Event.ElementPropertyChangedEvent event;
            if (element instanceof Vertex) {
                event = new Event.VertexPropertyChangedEvent(es.detach((Vertex)element), removedProperty, value, vertexPropertyKeyValues);
            } else if (element instanceof Edge) {
                event = new Event.EdgePropertyChangedEvent(es.detach((Edge)element), removedProperty, value);
            } else if (element instanceof VertexProperty) {
                event = new Event.VertexPropertyPropertyChangedEvent(es.detach((VertexProperty)element), removedProperty, value);
            } else {
                throw new IllegalStateException(String.format("The incoming object cannot be processed by change eventing in %s:  %s", AddPropertyStep.class.getName(), element));
            }
            for (EventCallback<Event.ElementPropertyChangedEvent> c : this.callbackRegistry.getCallbacks()) {
                c.accept(event);
            }
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    public CallbackRegistry<Event.ElementPropertyChangedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.ElementPropertyChangedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode() ^ this.parameters.hashCode();
        return null != this.cardinality ? hash ^ this.cardinality.hashCode() : hash;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.parameters.getTraversals().forEach(this::integrateChild);
    }

    public VertexProperty.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.parameters);
    }

    @Override
    public AddPropertyStep<S> clone() {
        AddPropertyStep clone = (AddPropertyStep)super.clone();
        clone.parameters = this.parameters.clone();
        return clone;
    }
}

