/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.keyed;

import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class KeyedProperty<V>
implements Property<V> {
    private final String key;

    public KeyedProperty(String key) {
        if (null == key || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.key = key;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public V value() throws NoSuchElementException {
        throw Property.Exceptions.propertyDoesNotExist();
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Element element() {
        throw Property.Exceptions.propertyDoesNotExist();
    }

    @Override
    public void remove() {
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyedProperty that = (KeyedProperty)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

