/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;

public interface ProfilingAware {
    public void prepareForProfiling();

    public static final class ProfiledBarrier
    implements Barrier {
        private final Barrier barrier;
        private final ProfileStep profileStep;

        public ProfiledBarrier(Barrier barrier, ProfileStep profileStep) {
            this.barrier = barrier;
            this.profileStep = profileStep;
        }

        @Override
        public void processAllStarts() {
            this.profileStep.start();
            this.barrier.processAllStarts();
            this.profileStep.stop();
        }

        @Override
        public boolean hasNextBarrier() {
            this.profileStep.start();
            boolean b = this.barrier.hasNextBarrier();
            this.profileStep.stop();
            return b;
        }

        public Object nextBarrier() throws NoSuchElementException {
            this.profileStep.start();
            Object o = this.barrier.nextBarrier();
            this.profileStep.stop();
            return o;
        }

        public void addBarrier(Object barrier) {
            this.barrier.addBarrier(barrier);
        }

        @Override
        public MemoryComputeKey getMemoryComputeKey() {
            return this.barrier.getMemoryComputeKey();
        }

        @Override
        public void done() {
            this.barrier.done();
        }
    }
}

