/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.ConstantChecksum;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public final class ChecksumUtil {
    private static final String CONSTANT_CHECKSUM = "CONSTANT";

    private ChecksumUtil() {
    }

    public static String checksumHeaderName(ChecksumAlgorithm checksumAlgorithm) {
        return "x-amz-checksum-" + checksumAlgorithm.algorithmId().toLowerCase(Locale.US);
    }

    public static SdkChecksum fromChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        String algorithmId = checksumAlgorithm.algorithmId();
        if (CONSTANT_CHECKSUM.equals(algorithmId)) {
            return new ConstantChecksum(((ConstantChecksumAlgorithm)checksumAlgorithm).value);
        }
        SdkChecksum checksum = SdkChecksum.forAlgorithm((ChecksumAlgorithm)checksumAlgorithm);
        if (checksum != null) {
            return checksum;
        }
        throw new UnsupportedOperationException("Checksum not supported for " + algorithmId);
    }

    public static void readAll(InputStream inputStream) {
        FunctionalUtils.invokeSafely(() -> {
            byte[] buffer = new byte[4096];
            while (inputStream.read(buffer) > -1) {
            }
        });
    }

    public static byte[] longToByte(Long input) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(input);
        return buffer.array();
    }

    public static class ConstantChecksumAlgorithm
    implements ChecksumAlgorithm {
        private final String value;

        public ConstantChecksumAlgorithm(String value) {
            this.value = value;
        }

        public String algorithmId() {
            return ChecksumUtil.CONSTANT_CHECKSUM;
        }
    }
}

