/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.lambda;

import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinLang;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.AbstractLambdaTraversal;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class CardinalityValueTraversal
extends AbstractLambdaTraversal {
    private final VertexProperty.Cardinality cardinality;
    private final Object value;
    private final GremlinLang gremlinLang;

    public CardinalityValueTraversal(VertexProperty.Cardinality cardinality, Object value) {
        this.cardinality = cardinality;
        this.value = value;
        this.gremlinLang = new GremlinLang(CardinalityValueTraversal.class.getSimpleName(), cardinality.name(), value);
    }

    @Override
    public GremlinLang getGremlinLang() {
        return this.gremlinLang;
    }

    public VertexProperty.Cardinality getCardinality() {
        return this.cardinality;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "[" + (Object)((Object)this.cardinality) + ", " + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CardinalityValueTraversal)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CardinalityValueTraversal that = (CardinalityValueTraversal)o;
        if (this.cardinality != that.cardinality) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cardinality.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

