/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.bval.jsr.ConstraintDefaults;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.metadata.AnnotationDeclaredValidatorMappingProvider;
import org.apache.bval.jsr.metadata.CompositeValidatorMappingProvider;
import org.apache.bval.jsr.metadata.DualValidationMappingProvider;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

public class ConstraintCached {
    private final ConcurrentMap<Class<? extends Annotation>, Set<ConstraintValidatorInfo<?>>> constraintValidatorInfo = new ConcurrentHashMap();
    private final ConcurrentMap<ConstraintD<?>, ConstraintValidator<?, ?>> validators = new ConcurrentHashMap();
    private final List<ValidatorMappingProvider> customValidatorMappingProviders = new ArrayList<ValidatorMappingProvider>();
    private final Lazy<ValidatorMappingProvider> validatorMappingProvider = new Lazy<ValidatorMappingProvider>(this::createValidatorMappingProvider);

    public ConcurrentMap<ConstraintD<?>, ConstraintValidator<?, ?>> getValidators() {
        return this.validators;
    }

    public void add(ValidatorMappingProvider validatorMappingProvider) {
        this.customValidatorMappingProviders.add(validatorMappingProvider);
        this.validatorMappingProvider.reset((ValidatorMappingProvider)((Object)((Supplier<ValidatorMappingProvider>)this::createValidatorMappingProvider)));
    }

    public <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getConstraintValidatorClasses(Class<A> constraintType) {
        Set<ConstraintValidatorInfo<A>> infos = this.infos(constraintType);
        return infos == null ? Collections.emptyList() : infos.stream().map(ConstraintValidatorInfo::getType).collect(ToUnmodifiable.list());
    }

    public <A extends Annotation> Set<ConstraintValidatorInfo<A>> getConstraintValidatorInfo(Class<A> constraintType) {
        return Collections.unmodifiableSet(this.infos(constraintType));
    }

    private <A extends Annotation> Set<ConstraintValidatorInfo<A>> infos(Class<A> constraintType) {
        return this.constraintValidatorInfo.computeIfAbsent(constraintType, c -> this.validatorMappingProvider.get().getValidatorMapping(c).getValidatorTypes().stream().map(ConstraintValidatorInfo::new).collect(Collectors.toSet()));
    }

    private ValidatorMappingProvider createValidatorMappingProvider() {
        ValidatorMappingProvider configured;
        if (this.customValidatorMappingProviders.isEmpty()) {
            configured = AnnotationDeclaredValidatorMappingProvider.INSTANCE;
        } else {
            ValidatorMappingProvider custom = this.customValidatorMappingProviders.size() == 1 ? this.customValidatorMappingProviders.get(0) : new CompositeValidatorMappingProvider(this.customValidatorMappingProviders);
            configured = new DualValidationMappingProvider(AnnotationDeclaredValidatorMappingProvider.INSTANCE, custom);
        }
        return new DualValidationMappingProvider(ConstraintDefaults.INSTANCE, configured);
    }

    public static final class ConstraintValidatorInfo<T extends Annotation> {
        private static final Set<ValidationTarget> DEFAULT_VALIDATION_TARGETS = Collections.singleton(ValidationTarget.ANNOTATED_ELEMENT);
        private final Class<? extends ConstraintValidator<T, ?>> type;
        private Set<ValidationTarget> supportedTargets;

        ConstraintValidatorInfo(Class<? extends ConstraintValidator<T, ?>> type) {
            this.type = Validate.notNull(type);
            SupportedValidationTarget svt = type.getAnnotation(SupportedValidationTarget.class);
            Set<ValidationTarget> set = this.supportedTargets = svt == null ? DEFAULT_VALIDATION_TARGETS : Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(svt.value())));
            if (this.supportedTargets.isEmpty()) {
                Exceptions.raise(ConstraintDefinitionException::new, "Illegally specified 0-length %s value on %s", SupportedValidationTarget.class.getSimpleName(), type);
            }
        }

        public Class<? extends ConstraintValidator<T, ?>> getType() {
            return this.type;
        }

        public Set<ValidationTarget> getSupportedTargets() {
            return this.supportedTargets;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ConstraintValidatorInfo && ((ConstraintValidatorInfo)obj).type.equals(this.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }
    }
}

