/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.om.Retrievable;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.TurbineIntake;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.ValueParser;
import org.apache.turbine.util.pool.Recyclable;

public class IntakeTool
implements ApplicationTool,
Recyclable {
    private static Log log = LogFactory.getLog((Class)IntakeTool.class);
    public static final String DEFAULT_KEY = "_0";
    public static final String INTAKE_GRP = "intake-grp";
    private HashMap groups;
    private ValueParser pp;
    HashMap declaredGroups = new HashMap();
    StringBuffer allGroupsSB = new StringBuffer(256);
    StringBuffer groupSB = new StringBuffer(128);
    private Map pullMap;
    private boolean disposed;

    public IntakeTool() {
        String[] groupNames = TurbineIntake.getGroupNames();
        int groupCount = 0;
        if (groupNames != null) {
            groupCount = groupNames.length;
        }
        this.groups = new HashMap((int)(1.25 * (double)groupCount + 1.0));
        this.pullMap = new HashMap((int)(1.25 * (double)groupCount + 1.0));
        for (int i = groupCount - 1; i >= 0; --i) {
            this.pullMap.put(groupNames[i], new PullHelper(groupNames[i]));
        }
    }

    public void init(Object runData) {
        int i;
        this.pp = ((RunData)runData).getParameters();
        String[] groupKeys = this.pp.getStrings(INTAKE_GRP);
        String[] groupNames = null;
        if (groupKeys == null || groupKeys.length == 0) {
            groupNames = TurbineIntake.getGroupNames();
        } else {
            groupNames = new String[groupKeys.length];
            for (i = groupKeys.length - 1; i >= 0; --i) {
                groupNames[i] = TurbineIntake.getGroupName(groupKeys[i]);
            }
        }
        for (i = groupNames.length - 1; i >= 0; --i) {
            try {
                ArrayList foundGroups = TurbineIntake.getGroup(groupNames[i]).getObjects(this.pp);
                if (foundGroups == null) continue;
                Iterator iter = foundGroups.iterator();
                while (iter.hasNext()) {
                    Group group = (Group)iter.next();
                    this.groups.put(group.getObjectKey(), group);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void addGroupsToParameters(ValueParser vp) {
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
                this.declaredGroups.put(group.getIntakeGroupName(), null);
                vp.add(INTAKE_GRP, group.getGID());
            }
            vp.add(group.getGID(), group.getOID());
        }
        this.declaredGroups.clear();
    }

    public String declareGroups() {
        this.allGroupsSB.setLength(0);
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            this.declareGroup((Group)i.next(), this.allGroupsSB);
        }
        return this.allGroupsSB.toString();
    }

    public String declareGroup(Group group) {
        this.groupSB.setLength(0);
        this.declareGroup(group, this.groupSB);
        return this.groupSB.toString();
    }

    public void declareGroup(Group group, StringBuffer sb) {
        if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
            this.declaredGroups.put(group.getIntakeGroupName(), null);
            sb.append("<input type=\"hidden\" name=\"").append(INTAKE_GRP).append("\" value=\"").append(group.getGID()).append("\"/>\n");
        }
        group.appendHtmlFormInput(sb);
    }

    public void newForm() {
        this.declaredGroups.clear();
        Iterator i = this.groups.values().iterator();
        while (i.hasNext()) {
            ((Group)i.next()).resetDeclared();
        }
    }

    public void refresh() {
    }

    public PullHelper get(String groupName) throws IntakeException {
        return (PullHelper)this.pullMap.get(groupName);
    }

    public PullHelper get(String groupName, boolean throwExceptions) throws IntakeException {
        return (PullHelper)this.pullMap.get(groupName);
    }

    public boolean isAllValid() {
        boolean allValid = true;
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            allValid &= group.isAllValid();
        }
        return allValid;
    }

    public Group get(String groupName, String key) throws IntakeException {
        if (groupName == null) {
            throw new IntakeException("Intake.get: groupName == null");
        }
        if (key == null) {
            throw new IntakeException("Intake.get: key == null");
        }
        PullHelper ph = this.get(groupName);
        return ph == null ? null : ph.setKey(key);
    }

    public Group get(String groupName, String key, boolean create) throws IntakeException {
        if (groupName == null) {
            throw new IntakeException("Intake.get: groupName == null");
        }
        if (key == null) {
            throw new IntakeException("Intake.get: key == null");
        }
        PullHelper ph = this.get(groupName);
        return ph == null ? null : ph.setKey(key, create);
    }

    public void remove(Group group) {
        if (group != null) {
            this.groups.remove(group.getObjectKey());
            group.removeFromRequest();
            String[] groupKeys = this.pp.getStrings(INTAKE_GRP);
            this.pp.remove(INTAKE_GRP);
            if (groupKeys != null) {
                for (int i = 0; i < groupKeys.length; ++i) {
                    if (groupKeys[i].equals(group.getGID())) continue;
                    this.pp.add(INTAKE_GRP, groupKeys[i]);
                }
            }
            try {
                TurbineIntake.releaseGroup(group);
            }
            catch (TurbineException se) {
                log.error((Object)("Tried to release unknown group " + group.getIntakeGroupName()));
            }
        }
    }

    public void removeAll() {
        Object[] allGroups = this.groups.values().toArray();
        for (int i = allGroups.length - 1; i >= 0; --i) {
            Group group = (Group)allGroups[i];
            this.remove(group);
        }
    }

    public Map getGroups() {
        return this.groups;
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            try {
                TurbineIntake.releaseGroup(g);
            }
            catch (TurbineException se) {
                log.error((Object)("Tried to release unknown group " + g.getIntakeGroupName()));
            }
        }
        this.groups.clear();
        this.declaredGroups.clear();
        this.pp = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public class PullHelper {
        String groupName;

        private PullHelper(String groupName) {
            this.groupName = groupName;
        }

        public Group getDefault() throws IntakeException {
            return this.setKey(IntakeTool.DEFAULT_KEY);
        }

        public Group setKey(String key) throws IntakeException {
            return this.setKey(key, true);
        }

        public Group setKey(String key, boolean create) throws IntakeException {
            Group g = null;
            String inputKey = TurbineIntake.getGroupKey(this.groupName) + key;
            if (IntakeTool.this.groups.containsKey(inputKey)) {
                g = (Group)IntakeTool.this.groups.get(inputKey);
            } else if (create) {
                g = TurbineIntake.getGroup(this.groupName);
                IntakeTool.this.groups.put(inputKey, g);
                g.init(key, IntakeTool.this.pp);
            }
            return g;
        }

        public Group mapTo(Retrievable obj) throws IntakeException {
            Group g = null;
            try {
                String inputKey = TurbineIntake.getGroupKey(this.groupName) + obj.getQueryKey();
                if (IntakeTool.this.groups.containsKey(inputKey)) {
                    g = (Group)IntakeTool.this.groups.get(inputKey);
                } else {
                    g = TurbineIntake.getGroup(this.groupName);
                    IntakeTool.this.groups.put(inputKey, g);
                }
                return g.init(obj);
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
    }
}

