/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class DoubleValidator
extends NumberValidator {
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public DoubleValidator(Map paramMap) throws InvalidMaskException {
        this.invalidNumberMessage = "Entry was not a valid Double";
        this.init(paramMap);
    }

    public DoubleValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Double.parseDouble(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Double.parseDouble(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(Field field) throws ValidationException {
        Locale locale = field.getLocale();
        if (field.isMultiValued()) {
            String[] stringValues = (String[])field.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], locale);
            }
        } else {
            this.assertValidity((String)field.getTestValue(), locale);
        }
    }

    public void assertValidity(String testValue, Locale locale) throws ValidationException {
        super.assertValidity(testValue);
        double d = 0.0;
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            NumberFormat nf = NumberFormat.getInstance(locale);
            try {
                d = nf.parse(testValue).doubleValue();
            }
            catch (ParseException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (d < this.minValue) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (d > this.maxValue) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double value) {
        this.minValue = value;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double value) {
        this.maxValue = value;
    }
}

