/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.mimetype;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.mimetype.MimeTypeService;
import org.apache.turbine.services.mimetype.util.CharSetMap;
import org.apache.turbine.services.mimetype.util.MimeType;
import org.apache.turbine.services.mimetype.util.MimeTypeMap;
import org.apache.turbine.services.servlet.TurbineServlet;

public class TurbineMimeTypeService
extends TurbineBaseService
implements MimeTypeService {
    public static final String MIME_TYPES = "mime.types";
    public static final String CHARSETS = "charsets";
    private MimeTypeMap mimeTypeMap;
    private CharSetMap charSetMap;

    public void init() throws InitializationException {
        String path = null;
        Configuration conf = this.getConfiguration();
        if (conf != null && (path = conf.getString(MIME_TYPES)) != null) {
            path = TurbineServlet.getRealPath(path);
        }
        if (path != null) {
            try {
                this.mimeTypeMap = new MimeTypeMap(path);
            }
            catch (IOException x) {
                throw new InitializationException(path, x);
            }
        } else {
            this.mimeTypeMap = new MimeTypeMap();
        }
        if (conf != null && (path = conf.getString(CHARSETS)) != null) {
            path = TurbineServlet.getRealPath(path);
        }
        if (path != null) {
            try {
                this.charSetMap = new CharSetMap(path);
            }
            catch (IOException x) {
                throw new InitializationException(path, x);
            }
        } else {
            this.charSetMap = new CharSetMap();
        }
        this.setInit(true);
    }

    public void setContentType(String spec) {
        this.mimeTypeMap.setContentType(spec);
    }

    public String getContentType(File file) {
        return this.mimeTypeMap.getContentType(file);
    }

    public String getContentType(String name) {
        return this.mimeTypeMap.getContentType(name);
    }

    public String getContentType(String ext, String def) {
        return this.mimeTypeMap.getContentType(ext, def);
    }

    public MimeType getMimeContentType(File file) {
        return this.mimeTypeMap.getMimeContentType(file);
    }

    public MimeType getMimeContentType(String name) {
        return this.mimeTypeMap.getMimeContentType(name);
    }

    public MimeType getMimeContentType(String ext, String def) {
        return this.mimeTypeMap.getMimeContentType(ext, def);
    }

    public String getDefaultExtension(String type) {
        return this.mimeTypeMap.getDefaultExtension(type);
    }

    public String getDefaultExtension(MimeType mime) {
        return this.mimeTypeMap.getDefaultExtension(mime);
    }

    public void setCharSet(String key, String charset) {
        this.charSetMap.setCharSet(key, charset);
    }

    public String getCharSet(Locale locale) {
        return this.charSetMap.getCharSet(locale);
    }

    public String getCharSet(Locale locale, String variant) {
        return this.charSetMap.getCharSet(locale, variant);
    }

    public String getCharSet(String key) {
        return this.charSetMap.getCharSet(key);
    }

    public String getCharSet(String key, String def) {
        return this.charSetMap.getCharSet(key, def);
    }
}

