/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.StringKey;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.ldap.LDAPSecurityConstants;

public class LDAPUser
extends BaseObject
implements User {
    private static final long serialVersionUID = 3953123276619326752L;
    private static Log log = LogFactory.getLog((Class)LDAPUser.class);
    private Date createDate = new Date();
    private Date lastAccessDate = null;
    private int timeout = 15;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = new Hashtable(10);

    public LDAPUser() {
        this.permStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public void setLDAPAttributes(Attributes attribs) throws NamingException {
        Attribute attr;
        String attrName = LDAPSecurityConstants.getUserIdAttribute();
        if (attrName != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            try {
                this.setPrimaryKey((ObjectKey)new StringKey(attr.get().toString()));
            }
            catch (Exception ex) {
                log.error((Object)"Exception caught:", (Throwable)ex);
            }
        }
        if ((attrName = LDAPSecurityConstants.getNameAttribute()) != null) {
            attr = attribs.get(attrName);
            if (attr != null && attr.get() != null) {
                this.setUserName(attr.get().toString());
            }
        } else {
            log.error((Object)"There is no LDAP attribute for the username.");
        }
        if ((attrName = LDAPSecurityConstants.getFirstNameAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setFirstName(attr.get().toString());
        }
        if ((attrName = LDAPSecurityConstants.getLastNameAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setLastName(attr.get().toString());
        }
        if ((attrName = LDAPSecurityConstants.getEmailAttribute()) != null && (attr = attribs.get(attrName)) != null && attr.get() != null) {
            this.setEmail(attr.get().toString());
        }
    }

    public Attributes getLDAPAttributes() throws NamingException {
        BasicAttribute attr;
        String value;
        BasicAttributes attribs = new BasicAttributes();
        String attrName = "objectClass";
        if (attrName != null && (value = "turbineUser") != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getUserIdAttribute()) != null && (value = this.getPrimaryKey()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getNameAttribute()) != null && (value = this.getName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getFirstNameAttribute()) != null && (value = this.getFirstName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getLastNameAttribute()) != null && (value = this.getLastName()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getEmailAttribute()) != null && (value = this.getEmail()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        if ((attrName = LDAPSecurityConstants.getPasswordAttribute()) != null && (value = this.getPassword()) != null) {
            attr = new BasicAttribute(attrName, value);
            attribs.put(attr);
        }
        return attribs;
    }

    public String getDN() {
        String filterAttribute = LDAPSecurityConstants.getNameAttribute();
        String userBaseSearch = LDAPSecurityConstants.getBaseSearch();
        String userName = this.getName();
        String dn = filterAttribute + "=" + userName + "," + userBaseSearch;
        return dn;
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String getConfirmed() {
        String tmp = null;
        tmp = (String)this.getPerm("CONFIRM_VALUE");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public String getEmail() {
        String tmp = null;
        tmp = (String)this.getPerm("EMAIL");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    public String getPassword() {
        return (String)this.getPerm("PASSWORD_VALUE");
    }

    public Object getPerm(String name) {
        return this.permStorage.get(name);
    }

    public Object getPerm(String name, Object def) {
        try {
            Object val = this.permStorage.get(name);
            if (val == null) {
                return def;
            }
            return val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable();
        }
        return this.permStorage;
    }

    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.tempStorage.get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUserName() {
        return this.getName();
    }

    public String getFirstName() {
        String tmp = null;
        tmp = (String)this.getPerm("FIRST_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public String getLastName() {
        String tmp = null;
        tmp = (String)this.getPerm("LAST_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public boolean hasLoggedIn() {
        Boolean tmp = this.getHasLoggedIn();
        return tmp != null && tmp != false;
    }

    public boolean isConfirmed() {
        return ((String)this.getTemp("CONFIRM_VALUE", "")).equals("CONFIRMED");
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    public void setConfirmed(String confirm) {
        this.getPerm("CONFIRM_VALUE", confirm);
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public void setEmail(String email) {
        this.setPerm("EMAIL", email);
    }

    public void setFirstName(String fname) {
        this.setPerm("FIRST_NAME", fname);
    }

    public void setLastLogin(Date date) {
        this.setPerm("LAST_LOGIN", date);
    }

    public void setLastName(String lname) {
        this.setPerm("LAST_NAME", lname);
    }

    public void setPassword(String password) {
        this.setPerm("PASSWORD_VALUE", password);
    }

    public void setPerm(String name, Object value) {
        this.permStorage.put(name, value);
    }

    public void setPermStorage(Hashtable stuff) {
        this.permStorage = stuff;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public void setTempStorage(Hashtable storage) {
        this.tempStorage = storage;
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    public void setTemp(String name, Object value) {
        this.tempStorage.put(name, value);
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public void setUserName(String username) {
        this.setPerm("LOGIN_NAME", username);
    }

    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveUser(this);
            }
        }
        catch (Exception e) {
            log.error((Object)("BaseUser.valueUnbobund(): " + e.getMessage()));
            log.error((Object)e);
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    public String getName() {
        String tmp = null;
        tmp = (String)this.getPerm("LOGIN_NAME");
        if (tmp != null && tmp.length() == 0) {
            tmp = null;
        }
        return tmp;
    }

    public void setName(String name) {
    }

    public int getId() {
        return 0;
    }

    public Integer getIdAsObj() {
        return new Integer(0);
    }

    public void setId(int id) {
    }

    public void save() throws Exception {
        if (TurbineSecurity.accountExists(this)) {
            TurbineSecurity.saveUser(this);
        } else {
            TurbineSecurity.addUser(this, this.getPassword());
        }
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }
}

