/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.TorqueUser;
import org.apache.turbine.services.security.torque.UserPeerManagerConstants;
import org.apache.turbine.util.security.DataBackendException;

public class UserPeerManager
implements UserPeerManagerConstants {
    private static final long serialVersionUID = 6943046259921811593L;
    private static Class userPeerClass = null;
    private static Class userObject = null;
    private static String tableName = null;
    private static String nameColumn = null;
    private static String idColumn = null;
    private static String passwordColumn = null;
    private static String firstNameColumn = null;
    private static String lastNameColumn = null;
    private static String emailColumn = null;
    private static String confirmColumn = null;
    private static String createDateColumn = null;
    private static String lastLoginColumn = null;
    private static String objectdataColumn = null;
    private static PropertyDescriptor namePropDesc = null;
    private static PropertyDescriptor idPropDesc = null;
    private static PropertyDescriptor passwordPropDesc = null;
    private static PropertyDescriptor firstNamePropDesc = null;
    private static PropertyDescriptor lastNamePropDesc = null;
    private static PropertyDescriptor emailPropDesc = null;
    private static PropertyDescriptor confirmPropDesc = null;
    private static PropertyDescriptor createDatePropDesc = null;
    private static PropertyDescriptor lastLoginPropDesc = null;
    private static PropertyDescriptor objectdataPropDesc = null;
    static Log log = LogFactory.getLog((Class)UserPeerManager.class);

    public static void init(Configuration conf) throws InitializationException {
        block14: {
            String userPeerClassName = conf.getString("torque.userPeer.class", USER_PEER_CLASS_DEFAULT);
            String userObjectName = null;
            try {
                userPeerClass = Class.forName(userPeerClassName);
                tableName = (String)userPeerClass.getField("TABLE_NAME").get(null);
                userObject = UserPeerManager.getPersistenceClass();
                userObjectName = conf.getString("torque.user.class", userObject.getName());
                userObject = Class.forName(userObjectName);
                nameColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.name", "LOGIN_NAME")).get(null);
                idColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.id", "USER_ID")).get(null);
                passwordColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.password", "PASSWORD_VALUE")).get(null);
                firstNameColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.firstname", "FIRST_NAME")).get(null);
                lastNameColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.lastname", "LAST_NAME")).get(null);
                emailColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.email", "EMAIL")).get(null);
                confirmColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.confirm", "CONFIRM_VALUE")).get(null);
                createDateColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.createdate", "CREATED")).get(null);
                lastLoginColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.lastlogin", "LAST_LOGIN")).get(null);
                objectdataColumn = (String)userPeerClass.getField(conf.getString("torque.userPeer.column.objectdata", "OBJECTDATA")).get(null);
                namePropDesc = new PropertyDescriptor(conf.getString("torque.user.property.name", "UserName"), userObject);
                idPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.id", "UserId"), userObject);
                passwordPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.password", "Password"), userObject);
                firstNamePropDesc = new PropertyDescriptor(conf.getString("torque.user.property.firstname", "FirstName"), userObject);
                lastNamePropDesc = new PropertyDescriptor(conf.getString("torque.user.property.lastname", "LastName"), userObject);
                emailPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.email", "Email"), userObject);
                confirmPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.confirm", "Confirmed"), userObject);
                createDatePropDesc = new PropertyDescriptor(conf.getString("torque.user.property.createdate", "CreateDate"), userObject);
                lastLoginPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.lastlogin", "LastLogin"), userObject);
                objectdataPropDesc = new PropertyDescriptor(conf.getString("torque.user.property.objectdata", "Objectdata"), userObject);
            }
            catch (Exception e) {
                if (userPeerClassName == null || userPeerClass == null) {
                    throw new InitializationException("Could not find UserPeer class (" + userPeerClassName + ")", e);
                }
                if (tableName == null) {
                    throw new InitializationException("Failed to get the table name from the Peer object", e);
                }
                if (userObject == null || userObjectName == null) {
                    throw new InitializationException("Failed to get the object type from the Peer object", e);
                }
                if (nameColumn == null || namePropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no name column information!", e);
                }
                if (idColumn == null || idPropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no id column information!", e);
                }
                if (passwordColumn == null || passwordPropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no password column information!", e);
                }
                if (firstNameColumn == null || firstNamePropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no firstName column information!", e);
                }
                if (lastNameColumn == null || lastNamePropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no lastName column information!", e);
                }
                if (emailColumn == null || emailPropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no email column information!", e);
                }
                if (confirmColumn == null || confirmPropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no confirm column information!", e);
                }
                if (createDateColumn == null || createDatePropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no createDate column information!", e);
                }
                if (lastLoginColumn == null || lastLoginPropDesc == null) {
                    throw new InitializationException("UserPeer " + userPeerClassName + " has no lastLogin column information!", e);
                }
                if (objectdataColumn != null && objectdataPropDesc != null) break block14;
                throw new InitializationException("UserPeer " + userPeerClassName + " has no objectdata column information!", e);
            }
        }
    }

    public static String getTableName() {
        return tableName;
    }

    public static String getNameColumn() {
        return nameColumn;
    }

    public static String getIdColumn() {
        return idColumn;
    }

    public static String getPasswordColumn() {
        return passwordColumn;
    }

    public static String getFirstNameColumn() {
        return firstNameColumn;
    }

    public static String getLastNameColumn() {
        return lastNameColumn;
    }

    public static String getEmailColumn() {
        return emailColumn;
    }

    public static String getConfirmColumn() {
        return confirmColumn;
    }

    public static String getCreateDateColumn() {
        return createDateColumn;
    }

    public static String getLastLoginColumn() {
        return lastLoginColumn;
    }

    public static String getObjectdataColumn() {
        return objectdataColumn;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(UserPeerManager.getTableName());
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public String getFullColumnName(String name) {
        return UserPeerManager.getColumnName(name);
    }

    public static Persistent newPersistentInstance() {
        Persistent obj = null;
        if (userObject == null) {
            return obj;
        }
        try {
            obj = (Persistent)userObject.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a user object", (Throwable)e);
            obj = null;
        }
        return obj;
    }

    public static boolean checkExists(User user) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(UserPeerManager.getIdColumn());
        criteria.add(UserPeerManager.getNameColumn(), (Object)user.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple users named '" + user.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static List selectAllUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.addAscendingOrderByColumn(UserPeerManager.getLastNameColumn());
        criteria.addAscendingOrderByColumn(UserPeerManager.getFirstNameColumn());
        criteria.setIgnoreCase(true);
        return UserPeerManager.doSelect(criteria);
    }

    public static List selectAllConfirmedUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getConfirmColumn(), (Object)"CONFIRMED");
        criteria.addAscendingOrderByColumn(UserPeerManager.getLastNameColumn());
        criteria.addAscendingOrderByColumn(UserPeerManager.getFirstNameColumn());
        criteria.setIgnoreCase(true);
        return UserPeerManager.doSelect(criteria);
    }

    public static Criteria buildCriteria(User user) {
        Criteria crit;
        try {
            Class[] clazz = new Class[]{userObject};
            Object[] params = new Object[]{((TorqueUser)user).getPersistentObj()};
            crit = (Criteria)userPeerClass.getMethod("buildCriteria", clazz).invoke(null, params);
        }
        catch (Exception e) {
            crit = null;
        }
        return crit;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            userPeerClass.getMethod("doUpdate", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doUpdate failed", (Throwable)e);
        }
    }

    public static void doInsert(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            userPeerClass.getMethod("doInsert", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doInsert failed", (Throwable)e);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        List list;
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            list = (List)userPeerClass.getMethod("doSelect", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doSelect failed", (Throwable)e);
        }
        ArrayList<User> newList = new ArrayList<User>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            User u = UserPeerManager.getNewUser((Persistent)it.next());
            newList.add(u);
        }
        return newList;
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            userPeerClass.getMethod("doDelete", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doDelete failed", (Throwable)e);
        }
    }

    public static void setUserName(Persistent obj, String name) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{name};
            namePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserName(Persistent obj) {
        return UserPeerManager.getName(obj);
    }

    public static String getName(Persistent obj) {
        String name = null;
        if (obj == null) {
            return null;
        }
        try {
            name = (String)namePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return name;
    }

    public static void setUserPassword(Persistent obj, String password) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{password};
            passwordPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserPassword(Persistent obj) {
        String password = null;
        if (obj == null) {
            return null;
        }
        try {
            password = (String)passwordPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return password;
    }

    public static void setUserFirstName(Persistent obj, String firstName) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{firstName};
            firstNamePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserFirstName(Persistent obj) {
        String firstName = null;
        if (obj == null) {
            return null;
        }
        try {
            firstName = (String)firstNamePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return firstName;
    }

    public static void setUserLastName(Persistent obj, String lastName) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{lastName};
            lastNamePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserLastName(Persistent obj) {
        String lastName = null;
        if (obj == null) {
            return null;
        }
        try {
            lastName = (String)lastNamePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return lastName;
    }

    public static void setUserEmail(Persistent obj, String email) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{email};
            emailPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserEmail(Persistent obj) {
        String email = null;
        if (obj == null) {
            return null;
        }
        try {
            email = (String)emailPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return email;
    }

    public static void setUserConfirmed(Persistent obj, String confirm) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{confirm};
            confirmPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getUserConfirmed(Persistent obj) {
        String confirm = null;
        if (obj == null) {
            return null;
        }
        try {
            confirm = (String)confirmPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return confirm;
    }

    public static void setUserCreateDate(Persistent obj, Date createDate) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{createDate};
            createDatePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Date getUserCreateDate(Persistent obj) {
        Date createDate = null;
        if (obj == null) {
            return null;
        }
        try {
            createDate = (Date)createDatePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return createDate;
    }

    public static void setUserLastLogin(Persistent obj, Date lastLogin) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{lastLogin};
            lastLoginPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Date getUserLastLogin(Persistent obj) {
        Date lastLogin = null;
        if (obj == null) {
            return null;
        }
        try {
            lastLogin = (Date)lastLoginPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return lastLogin;
    }

    public static void setUserObjectdata(Persistent obj, byte[] objectdata) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{objectdata};
            objectdataPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static byte[] getUserObjectdata(Persistent obj) {
        byte[] objectdata = null;
        if (obj == null) {
            return null;
        }
        try {
            objectdata = (byte[])objectdataPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return objectdata;
    }

    public static void setId(Persistent obj, int id) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{Integer.TYPE};
            idPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Integer getIdAsObj(Persistent obj) {
        Integer id = null;
        if (obj == null) {
            return new Integer(0);
        }
        try {
            id = (Integer)idPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be an User Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return id;
    }

    private static Class getPersistenceClass() {
        Class persistenceClass = null;
        try {
            Object[] params = new Object[]{};
            persistenceClass = (Class)userPeerClass.getMethod("getOMClass", null).invoke(null, params);
        }
        catch (Exception e) {
            persistenceClass = null;
        }
        return persistenceClass;
    }

    public static User getNewUser(Persistent p) {
        User u = null;
        try {
            Class userWrapperClass = TurbineSecurity.getUserClass();
            Class[] clazz = new Class[]{Persistent.class};
            Object[] params = new Object[]{p};
            u = (User)userWrapperClass.getConstructor(clazz).newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a new user from supplied persistent: ", (Throwable)e);
        }
        return u;
    }
}

