/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.set.CompositeSet;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.services.upload.UploadService;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.BaseValueParser;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.pool.Recyclable;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser,
Recyclable {
    private static Log log = LogFactory.getLog((Class)DefaultParameterParser.class);
    private HttpServletRequest request = null;
    private byte[] uploadData = null;
    private Map fileParameters = new HashMap();
    private static UploadService uploadService = null;
    private static boolean uploadServiceIsAvailable = false;

    public DefaultParameterParser() {
        this.configureUploadService();
    }

    public DefaultParameterParser(String characterEncoding) {
        super(characterEncoding);
        this.configureUploadService();
    }

    private void configureUploadService() {
        uploadServiceIsAvailable = TurbineUpload.isAvailable();
        if (uploadServiceIsAvailable) {
            uploadService = TurbineUpload.getService();
        }
    }

    public void dispose() {
        this.request = null;
        this.uploadData = null;
        this.fileParameters.clear();
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        String paramName;
        this.clear();
        this.uploadData = null;
        String enc = request.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "ISO-8859-1");
        String contentType = request.getHeader("Content-type");
        if (uploadServiceIsAvailable && uploadService.getAutomatic() && contentType != null && contentType.startsWith("multipart/form-data")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Running the Turbine Upload Service");
            }
            try {
                TurbineUpload.parseRequest(request, this);
            }
            catch (TurbineException e) {
                log.error((Object)"File upload failed", (Throwable)((Object)e));
            }
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            paramName = (String)names.nextElement();
            this.add(paramName, request.getParameterValues(paramName));
        }
        try {
            boolean isNameTok = true;
            paramName = null;
            String paramValue = null;
            StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
            while (st.hasMoreTokens()) {
                if (isNameTok) {
                    paramName = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                    isNameTok = false;
                    continue;
                }
                paramValue = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                if (paramName.length() > 0) {
                    this.add(paramName, paramValue);
                }
                isNameTok = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.request = request;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Parameters found in the Request:");
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                log.debug((Object)("Key: " + key + " -> " + this.getString(key)));
            }
        }
    }

    public void setUploadData(byte[] uploadData) {
        this.uploadData = uploadData;
    }

    public byte[] getUploadData() {
        return this.uploadData;
    }

    public void append(String name, FileItem item) {
        this.add(name, item);
    }

    public void add(String name, FileItem item) {
        Object[] items = this.getFileItemParam(name);
        items = (FileItem[])ArrayUtils.add((Object[])items, (Object)item);
        this.putFileItemParam(name, (FileItem[])items);
    }

    public Set keySet() {
        return new CompositeSet(new Set[]{super.keySet(), this.fileParameters.keySet()});
    }

    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        return this.fileParameters.containsKey(this.convert(String.valueOf(key)));
    }

    public FileItem getFileItem(String name) {
        FileItem[] value = this.getFileItemParam(name);
        return value == null || value.length == 0 ? null : value[0];
    }

    public FileItem[] getFileItems(String name) {
        return this.getFileItemParam(name);
    }

    protected void putFileItemParam(String name, FileItem[] value) {
        String key = this.convert(name);
        if (key != null) {
            this.fileParameters.put(key, value);
        }
    }

    protected FileItem[] getFileItemParam(String name) {
        String key = this.convert(name);
        return key != null ? (FileItem[])this.fileParameters.get(key) : null;
    }

    protected Object[] getToStringParam(String name) {
        if (super.containsKey(name)) {
            return this.getParam(name);
        }
        return this.getFileItemParam(name);
    }
}

