/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import org.apache.oro.text.regex.MatchResult;

final class Perl5MatchResult
implements MatchResult {
    int _matchBeginOffset;
    int[] _beginGroupOffset;
    int[] _endGroupOffset;
    String _match;

    public final int length() {
        return this._match.length();
    }

    public final int groups() {
        return this._beginGroupOffset.length;
    }

    public final String group(int group) {
        if (group < this._beginGroupOffset.length) {
            int begin = this._beginGroupOffset[group];
            int end = this._endGroupOffset[group];
            int length = this._match.length();
            if (begin >= 0 && end >= 0) {
                if (begin < length && end <= length && end > begin) {
                    return this._match.substring(begin, end);
                }
                if (begin <= end) {
                    return "";
                }
            }
        }
        return null;
    }

    public final int begin(int group) {
        if (group < this._beginGroupOffset.length) {
            int begin = this._beginGroupOffset[group];
            int end = this._endGroupOffset[group];
            if (begin >= 0 && end >= 0) {
                return begin;
            }
        }
        return -1;
    }

    public final int end(int group) {
        if (group < this._beginGroupOffset.length) {
            int begin = this._beginGroupOffset[group];
            int end = this._endGroupOffset[group];
            if (begin >= 0 && end >= 0) {
                return end;
            }
        }
        return -1;
    }

    public final int beginOffset(int group) {
        if (group < this._beginGroupOffset.length) {
            int begin = this._beginGroupOffset[group];
            int end = this._endGroupOffset[group];
            if (begin >= 0 && end >= 0) {
                return this._matchBeginOffset + begin;
            }
        }
        return -1;
    }

    public final int endOffset(int group) {
        if (group < this._endGroupOffset.length) {
            int begin = this._beginGroupOffset[group];
            int end = this._endGroupOffset[group];
            if (begin >= 0 && end >= 0) {
                return this._matchBeginOffset + end;
            }
        }
        return -1;
    }

    public final String toString() {
        return this.group(0);
    }

    Perl5MatchResult(int groups) {
        this._beginGroupOffset = new int[groups];
        this._endGroupOffset = new int[groups];
    }
}

