/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentFactory;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;

public class ThreadSafeComponentHandler
extends ComponentHandler {
    private Component m_instance;
    private final DefaultComponentFactory m_factory;
    private boolean m_initialized = false;
    private boolean m_disposed = false;

    protected ThreadSafeComponentHandler(String role, Class componentClass, Configuration config, ComponentManager manager, Context context, RoleManager roles, LogkitLoggerManager logkit) throws Exception {
        this(new DefaultComponentFactory(role, componentClass, config, manager, context, roles, logkit), config);
    }

    public ThreadSafeComponentHandler(DefaultComponentFactory factory, Configuration config) throws Exception {
        this.m_factory = factory;
    }

    protected ThreadSafeComponentHandler(Component component) throws Exception {
        this.m_instance = component;
        this.m_factory = null;
    }

    public void initialize() throws Exception {
        if (this.m_initialized) {
            return;
        }
        if (null != this.m_factory) {
            this.m_factory.setLogger(this.getLogkitLogger());
            this.m_factory.enableLogging(this.getLogger());
        }
        if (this.m_instance == null) {
            this.m_instance = (Component)this.m_factory.newInstance();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (this.m_factory != null) {
                this.getLogger().debug("ComponentHandler initialized for: " + this.m_factory.getCreatedClass().getName());
            } else {
                this.getLogger().debug("ComponentHandler initialized for: " + this.m_instance.getClass().getName());
            }
        }
        this.m_initialized = true;
    }

    protected Component doGet() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        return this.m_instance;
    }

    protected void doPut(Component component) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
        }
    }

    public void dispose() {
        block6: {
            try {
                if (null != this.m_factory) {
                    this.m_factory.decommission(this.m_instance);
                } else {
                    if (this.m_instance instanceof Startable) {
                        ((Startable)this.m_instance).stop();
                    }
                    if (this.m_instance instanceof Disposable) {
                        ((Disposable)this.m_instance).dispose();
                    }
                }
                this.m_instance = null;
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block6;
                this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
            }
        }
        this.m_disposed = true;
    }
}

