/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.jce.crypto.HexConverter;

public final class CryptoUtil {
    private static final int BUFFER_SIZE = 1024;

    public static void encrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.encrypt(CryptoUtil.getCryptoStreamFactory(), source, target, password);
    }

    public static void encrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = CryptoUtil.createInputStream(source);
        OutputStream os = CryptoUtil.createOutputStream(target);
        OutputStream eos = factory.getOutputStream(os, password);
        CryptoUtil.copy(is, eos);
    }

    public static void decrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        CryptoUtil.decrypt(CryptoUtil.getCryptoStreamFactory(), source, target, password);
    }

    public static void decrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = CryptoUtil.createInputStream(source);
        OutputStream os = CryptoUtil.createOutputStream(target);
        InputStream dis = factory.getInputStream(is, password);
        CryptoUtil.copy(dis, os);
    }

    public static String encryptString(String plainText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.encryptString(CryptoUtil.getCryptoStreamFactory(), plainText, password);
    }

    public static String encryptString(CryptoStreamFactory factory, String plainText, char[] password) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        CryptoUtil.encrypt(factory, plainText, bais, password);
        return HexConverter.toString(bais.toByteArray());
    }

    public static String decryptString(String cipherText, char[] password) throws GeneralSecurityException, IOException {
        return CryptoUtil.decryptString(CryptoUtil.getCryptoStreamFactory(), cipherText, password);
    }

    public static String decryptString(CryptoStreamFactory factory, String cipherText, char[] password) throws GeneralSecurityException, IOException {
        byte[] buffer = HexConverter.toBytes(cipherText);
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        CryptoUtil.decrypt(factory, buffer, bais, password);
        return new String(bais.toByteArray(), "utf-8");
    }

    private static InputStream createInputStream(Object source) throws IOException {
        InputStream is = null;
        if (source instanceof String) {
            byte[] content = ((String)source).getBytes("utf-8");
            is = new ByteArrayInputStream(content);
        } else if (source instanceof File) {
            is = new FileInputStream((File)source);
        } else if (source instanceof byte[]) {
            is = new ByteArrayInputStream((byte[])source);
        } else if (source instanceof char[]) {
            byte[] content = new String((char[])source).getBytes("utf-8");
            is = new ByteArrayInputStream(content);
        } else if (source instanceof ByteArrayOutputStream) {
            byte[] content = ((ByteArrayOutputStream)source).toByteArray();
            is = new ByteArrayInputStream(content);
        } else {
            is = (InputStream)source;
        }
        return is;
    }

    private static OutputStream createOutputStream(Object target) throws IOException {
        OutputStream os = null;
        os = target instanceof File ? new FileOutputStream((File)target) : (OutputStream)target;
        return os;
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int n = 0;
        int total = 0;
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
            total += n;
        }
        is.close();
        os.flush();
        os.close();
    }

    public static CryptoStreamFactory getCryptoStreamFactory() {
        return CryptoStreamFactoryImpl.getInstance();
    }
}

