/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.fulcrum.jce.crypto.CryptoUtil;

public class Main {
    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                Main.printHelp();
                throw new IllegalArgumentException("Invalid command line");
            }
            String operationMode = args[0];
            if (operationMode.equals("file")) {
                Main.processFiles(args);
            } else if (operationMode.equals("string")) {
                Main.processString(args);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void printHelp() {
        System.out.println("Main file [enc|dec] passwd source [target]");
        System.out.println("Main string [enc|dec] passwd ");
    }

    public static void processFiles(String[] args) throws Exception {
        String cipherMode = args[1];
        char[] password = args[2].toCharArray();
        File sourceFile = new File(args[3]);
        File targetFile = null;
        targetFile = args.length == 4 ? sourceFile : new File(args[4]);
        Main.processFile(cipherMode, password, sourceFile, targetFile);
    }

    public static void processFile(String cipherMode, char[] password, File sourceFile, File targetFile) throws Exception {
        FileInputStream fis = new FileInputStream(sourceFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (cipherMode.equals("dec")) {
            System.out.println("Decrypting " + sourceFile.getAbsolutePath());
            CryptoUtil.decrypt(fis, baos, password);
            fis.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            FileOutputStream fos = new FileOutputStream(targetFile);
            CryptoUtil.copy(bais, fos);
            bais.close();
            fos.close();
        } else if (cipherMode.equals("enc")) {
            System.out.println("Enrypting " + sourceFile.getAbsolutePath());
            CryptoUtil.encrypt(fis, baos, password);
            fis.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            FileOutputStream fos = new FileOutputStream(targetFile);
            CryptoUtil.copy(bais, fos);
            bais.close();
            fos.close();
        } else {
            String msg = "Don't know what to do with : " + cipherMode;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void processString(String[] args) throws Exception {
        String cipherMode = args[1];
        char[] password = args[2].toCharArray();
        String value = args[3];
        String result = null;
        result = cipherMode.equals("dec") ? CryptoUtil.decryptString(value, password) : CryptoUtil.encryptString(value, password);
        System.out.println(result);
    }
}

