/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileServicesDB
implements ServicesDB {
    public static String fileName = "/etc/services";

    FileServicesDB() {
    }

    public static final ServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ServicesDB load() {
        try {
            NetDBParser parser2 = FileServicesDB.parseServicesFile();
            try {
                parser2.iterator().next();
            }
            finally {
                parser2.close();
            }
            return new FileServicesDB();
        }
        catch (Throwable t) {
            return null;
        }
    }

    static final NetDBParser parseServicesFile() {
        try {
            return new NetDBParser(new FileReader(new File(fileName)));
        }
        catch (FileNotFoundException ex) {
            return new NetDBParser(new StringReader(""));
        }
    }

    private static final Service parseServicesEntry(NetDBEntry e) {
        int port;
        String[] portproto = e.data.split("/");
        if (portproto.length < 2) {
            return null;
        }
        try {
            port = Integer.parseInt(portproto[0], 10);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new Service(e.name, port, portproto[1], e.aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Service parse(Filter filter) {
        NetDBParser parser2 = FileServicesDB.parseServicesFile();
        try {
            for (NetDBEntry e : parser2) {
                Service s = FileServicesDB.parseServicesEntry(e);
                if (s == null || !filter.filter(s)) continue;
                Service service = s;
                return service;
            }
        }
        finally {
            try {
                parser2.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    @Override
    public Service getServiceByName(final String name, final String proto) {
        return this.parse(new Filter(){

            public boolean filter(Service s) {
                if (!s.proto.equals(proto) && proto != null) {
                    return false;
                }
                if (s.getName().equals(name)) {
                    return true;
                }
                for (String alias2 : s.getAliases()) {
                    if (!alias2.equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Service getServiceByPort(final Integer port, final String proto) {
        return this.parse(new Filter(){

            public boolean filter(Service s) {
                return s.getPort() == port.intValue() && (s.proto.equals(proto) || proto == null);
            }
        });
    }

    @Override
    public Collection<Service> getAllServices() {
        final LinkedList allServices = new LinkedList();
        this.parse(new Filter(){

            public boolean filter(Service s) {
                allServices.add(s);
                return false;
            }
        });
        return Collections.unmodifiableList(allServices);
    }

    static /* synthetic */ ServicesDB access$000() {
        return FileServicesDB.load();
    }

    private static interface Filter {
        public boolean filter(Service var1);
    }

    private static final class SingletonHolder {
        public static final ServicesDB INSTANCE = FileServicesDB.access$000();

        private SingletonHolder() {
        }
    }
}

