/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.FileAndShortName;
import org.apache.uima.taeconfigurator.editors.ui.TypeImportSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.CommonInputDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.ExportImportablePartDialog;
import org.apache.uima.taeconfigurator.files.MultiResourceSelectionDialog;
import org.apache.uima.util.InvalidXMLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;

public abstract class ImportSection
extends AbstractSection {
    protected static final long TABLE_HOVER_REQUERY_TIME = 15000L;
    protected TableItem lastTableHoverItem = null;
    protected long lLastTableHoverMillis = -1L;
    protected String sLastTableHoverHelp = "";
    protected boolean bDisableToolTipHelp = false;
    private static final String TABLE_INDICATOR_BY_NAME = "By Name";
    private static final String TABLE_INDICATOR_BY_LOCATION = "By Location";
    protected Button addButton;
    private Button removeButton;
    private Button setDataPathButton;
    Table importTable;

    protected abstract Import[] getModelImportArray();

    protected abstract void setModelImportArray(Import[] var1);

    protected abstract boolean isValidImport(String var1, String var2);

    protected abstract void finishImportChangeAction();

    protected abstract String getDescriptionFromImport(String var1) throws InvalidXMLException, IOException;

    protected abstract boolean isAppropriate();

    protected abstract void clearModelBaseValue();

    public ImportSection(MultiPageEditor aEditor, Composite parent, String title, String description) {
        super(aEditor, parent, title, description);
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.newComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        Composite buttonContainer = this.new2ColumnComposite(sectionClient);
        ((GridData)buttonContainer.getLayoutData()).grabExcessVerticalSpace = false;
        ((GridData)buttonContainer.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)buttonContainer.getLayoutData()).horizontalAlignment = 131072;
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add an import");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected import.");
        this.setDataPathButton = this.newPushButton(buttonContainer, "Set DataPath", "Click here to view or set the data path to use when resolving imports by name.");
        this.importTable = this.newTable(sectionClient, 65536, -1);
        this.newTableColumn(this.importTable).setText("Kind");
        this.newTableColumn(this.importTable).setText("Location/Name");
        this.importTable.setHeaderVisible(true);
        this.packTable(this.importTable);
        this.importTable.addListener(32, (Listener)this);
        this.importTable.addListener(3, (Listener)this);
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        Import[] importItems;
        super.refresh();
        this.importTable.removeAll();
        if (this.isAppropriate() && (importItems = this.getModelImportArray()) != null) {
            for (int i = 0; i < importItems.length; ++i) {
                if (importItems[i] == null) continue;
                TableItem tableItem = new TableItem(this.importTable, 0);
                if (importItems[i].getLocation() != null) {
                    tableItem.setText(0, TABLE_INDICATOR_BY_LOCATION);
                    tableItem.setText(1, importItems[i].getLocation());
                    continue;
                }
                tableItem.setText(0, TABLE_INDICATOR_BY_NAME);
                tableItem.setText(1, importItems[i].getName());
            }
            this.packTable(this.importTable);
        }
        this.enable();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addButton) {
            this.handleAdd();
        } else if (event.widget == this.removeButton) {
            this.handleRemove();
        } else if (event.widget == this.setDataPathButton) {
            this.handleSetDataPath();
        } else if (event.type == 3 && event.button == 3) {
            this.handleTableContextMenuRequest(event);
        } else if (event.type == 32 && !this.bDisableToolTipHelp) {
            this.handleTableHoverHelp(event);
        } else if (event.type == 2) {
            if (event.character == '\u007f') {
                this.handleRemove();
            }
        } else if (event.widget == this.importTable && event.type == 13) {
            this.enable();
        }
    }

    public void handleRemove() {
        int nSelectedIndex = this.importTable.getSelectionIndex();
        Object[] oldImports = this.getModelImportArray();
        this.setModelImportArray((Import[])Utility.removeElementFromArray(oldImports, oldImports[nSelectedIndex], Import.class));
        if (!this.isValidImport("Error Removing Import", "An error was caused by removing an import.")) {
            this.setModelImportArray((Import[])oldImports);
            return;
        }
        this.refresh();
        this.importTable.setSelection(nSelectedIndex - 1);
        this.enable();
        this.finishImportChangeAction();
        this.setFileDirty();
    }

    private void handleSetDataPath() {
        CommonInputDialog dialog = new CommonInputDialog(this, "Set DataPath", "The DataPath is a series of locations which will be used when looking up imports and external resources.\nEnter a series of absolute path names, separated by the character used to separate classpath names on this platform.", 16, CDEpropertyPage.getDataPath(this.editor.getProject()));
        if (dialog.open() == 1) {
            return;
        }
        CDEpropertyPage.setDataPath(this.editor.getProject(), dialog.getValue());
    }

    private void handleAdd() {
        Shell shell = this.getSection().getShell();
        MultiResourceSelectionDialog dialog = new MultiResourceSelectionDialog(shell, (IAdaptable)this.editor.getFile().getProject().getParent(), "Select one or more descriptor files to import:", this.editor.getFile().getLocation(), this.editor);
        dialog.setTitle("Import File(s) Selection");
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length == 0) {
            return;
        }
        if (!this.addImports(results, dialog.isImportByName)) {
            return;
        }
        this.refresh();
        this.finishImportChangeAction();
        this.setFileDirty();
    }

    public boolean addImports(Object[] locations, boolean isByName) {
        Import[] currentImports = this.getModelImportArray();
        int nCountCurrentImports = currentImports == null ? 0 : currentImports.length;
        int numberToAdd = locations.length;
        Import[] newImports = new Import[nCountCurrentImports + numberToAdd];
        if (null != currentImports) {
            System.arraycopy(currentImports, 0, newImports, 0, nCountCurrentImports);
        }
        for (int i = 0; i < locations.length; ++i) {
            FileAndShortName fsn = new FileAndShortName(locations[i]);
            Import imp = this.createImport(fsn.fileName, isByName);
            if (this.alreadyImported(imp)) {
                return false;
            }
            newImports[nCountCurrentImports + i] = imp;
        }
        this.setModelImportArray(newImports);
        if (!this.isValidImport("Error Adding Import(s)", "An error was caused by adding Import(s); operation cancelled.  Please correct the error and retry.")) {
            this.setModelImportArray(currentImports);
            return false;
        }
        return true;
    }

    private boolean alreadyImported(Import imp) {
        String currentFileBeingEdited = this.editor.getFile().getLocation().toString();
        if ((currentFileBeingEdited = this.editor.getDescriptorRelativePath(currentFileBeingEdited)).equals(imp.getLocation())) {
            Utility.popMessage("Error - importing self", MessageFormat.format("The import {0} is the same as the current file being edited. A file can''t be imported into itself.", imp.getLocation()), 1);
            return true;
        }
        Import[] currentImports = this.getModelImportArray();
        if (null == currentImports) {
            return false;
        }
        for (int i = 0; i < currentImports.length; ++i) {
            if (!currentImports[i].equals((Object)imp)) continue;
            Utility.popMessage("Error - duplicate import", MessageFormat.format("The import {0} is already present", null != imp.getName() ? imp.getName() : imp.getLocation()), 1);
            return true;
        }
        return false;
    }

    @Override
    public void enable() {
        int nSelectionIndex = this.importTable.getSelectionIndex();
        boolean addEnable = this instanceof TypeImportSection ? !this.isAggregate() : true;
        this.addButton.setEnabled(addEnable);
        this.removeButton.setEnabled(nSelectionIndex > -1);
    }

    private void handleTableContextMenuRequest(Event event) {
        TableItem item = this.importTable.getItem(new Point(event.x, event.y));
        int nSelectedIndex = ImportSection.getIndex(item);
        this.bDisableToolTipHelp = true;
        this.requestPopUpOverImport(this.getModelImportArray()[nSelectedIndex], (Control)this.importTable, event);
        this.bDisableToolTipHelp = false;
    }

    private void handleTableHoverHelp(Event event) {
        TableItem item = this.importTable.getItem(new Point(event.x, event.y));
        if (null != item) {
            Object sDesc;
            long lCurrentTimeInMillis = System.currentTimeMillis();
            if (item == this.lastTableHoverItem && lCurrentTimeInMillis - this.lLastTableHoverMillis < 15000L) {
                sDesc = this.sLastTableHoverHelp;
            } else {
                int itemIndex = (event.y - this.importTable.getHeaderHeight()) / this.importTable.getItemHeight();
                String thisFile = item.getText(1);
                sDesc = thisFile + " ";
                Import[] importItems = this.getModelImportArray();
                if (itemIndex < 0 || itemIndex >= importItems.length) {
                    System.err.println("***ERROR Item index hover out of range" + itemIndex + ", size of array = " + importItems.length);
                    System.err.println(this.getClass().getName());
                    return;
                }
                Import importItem = this.getModelImportArray()[itemIndex];
                String absolutePath = this.editor.getAbsolutePathFromImport(importItem);
                String description = null;
                try {
                    description = this.getDescriptionFromImport(absolutePath);
                }
                catch (InvalidXMLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (null != description && !description.equals("")) {
                    sDesc = (String)sDesc + "\n\n" + ImportSection.parseToFitInToolTips(description);
                }
                this.lastTableHoverItem = item;
                this.lLastTableHoverMillis = System.currentTimeMillis();
                this.sLastTableHoverHelp = sDesc;
            }
            this.importTable.setToolTipText((String)sDesc);
        } else {
            this.importTable.setToolTipText("");
        }
    }

    protected void exportImportablePart(String xmlStartElement, String partTemplate) {
        String xmlEndElement = xmlStartElement.replaceFirst("<", "</");
        ExportImportablePartDialog dialog = new ExportImportablePartDialog(this);
        if (dialog.open() == 1) {
            return;
        }
        PrintWriter printWriter = this.setupToPrintFile(dialog.genFilePath);
        if (null != printWriter) {
            String wholeModel = this.editor.prettyPrintModel();
            int start = wholeModel.indexOf(xmlStartElement);
            int end = wholeModel.lastIndexOf(xmlEndElement);
            if (start < 0 || end < 0) {
                throw new InternalErrorCDE("invalid state");
            }
            printWriter.println(MessageFormat.format(partTemplate, dialog.baseFileName, wholeModel.substring(start += xmlStartElement.length(), end) + "\n"));
            printWriter.close();
            this.clearModelBaseValue();
            this.setFileDirty();
            Import imp = this.createImport(dialog.genFilePath, dialog.isImportByName);
            this.setModelImportArray((Import[])Utility.addElementToArray(this.getModelImportArray(), imp, Import.class));
            this.isValidImport("Error Exporting a part and Importing it", "An unexpected error was caused by the export operation");
            this.refresh();
            Object file = this.editor.getIFileOrFile(dialog.genFilePath);
            if (file instanceof IFile) {
                try {
                    IFile ifile = (IFile)file;
                    ifile.refreshLocal(1, null);
                    ((IFile)file).setPersistentProperty(new QualifiedName("org.apache.uima.desceditor", "ipc"), this.editor.getFile().getLocation().toString());
                }
                catch (CoreException e) {
                    throw new InternalErrorCDE("unexpected exception", e);
                }
            }
        }
    }
}

