/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.launching;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.ruta.action.LogAction;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.launching.IConfigurableRunner;
import org.apache.uima.ruta.ide.launching.IRutaInterpreterRunnerConfig;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.xml.sax.SAXException;

public class RutaInterpreterRunner
extends AbstractInterpreterRunner
implements IConfigurableRunner {
    public static final IRutaInterpreterRunnerConfig DEFAULT_CONFIG = new IRutaInterpreterRunnerConfig(){

        @Override
        public void adjustRunnerConfiguration(VMRunnerConfiguration vconfig, InterpreterConfig iconfig, ILaunch launch, IJavaProject project) {
        }

        @Override
        public String[] computeClassPath(InterpreterConfig config, ILaunch launch, IJavaProject project) throws Exception {
            return RutaInterpreterRunner.getClassPath(project);
        }

        @Override
        public String[] getProgramArguments(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return new String[0];
        }

        @Override
        public String getRunnerClassName(InterpreterConfig config, ILaunch launch, IJavaProject project) {
            return "RutaRunner";
        }
    };
    private IRutaInterpreterRunnerConfig config = DEFAULT_CONFIG;

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RutaInterpreterRunner.doRunImpl(config, launch, this.config, monitor);
    }

    private static Handler initConsoleLink(String module) {
        final MessageConsole console = RutaInterpreterRunner.findConsole(module);
        final MessageConsoleStream out = console.newMessageStream();
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                String[] split;
                String message = record.getMessage();
                if (message.equals("\\n")) {
                    out.println();
                }
                for (String string : split = message.split("\\\\n")) {
                    out.println(string);
                }
                console.activate();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Logger.getLogger(LogAction.LOGGER_NAME).addHandler(handler);
        return handler;
    }

    private static void clearConsoleLink(Handler handler) {
        Logger.getLogger(LogAction.LOGGER_NAME).removeHandler(handler);
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        for (int i = 0; i < existing.length; ++i) {
            if (!name.equals(existing[i].getName())) continue;
            return (MessageConsole)existing[i];
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static List<File> getFiles(File dir, boolean recusive) {
        ArrayList<File> result = new ArrayList<File>();
        for (File each : dir.listFiles()) {
            if (each.getName().endsWith(".svn")) continue;
            result.add(each);
            if (!each.isDirectory() || !recusive) continue;
            result.addAll(RutaInterpreterRunner.getFiles(each, recusive));
        }
        return result;
    }

    public static void doRunImpl(InterpreterConfig config, ILaunch launch, IRutaInterpreterRunnerConfig iconfig, IProgressMonitor monitor) throws CoreException {
        IPreferenceStore store;
        boolean clearOutput;
        String launchMode = launch.getLaunchMode();
        IScriptProject proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)launch.getLaunchConfiguration());
        IPath projectPath = proj.getResource().getLocation();
        IPath inputDirPath = projectPath.append(RutaProjectUtils.getDefaultInputLocation());
        IPath outputDirPath = projectPath.append(RutaProjectUtils.getDefaultOutputLocation());
        ClassLoader classLoader = RutaProjectUtils.getClassLoader((IProject)proj.getProject());
        String engine = RutaProjectUtils.getAnalysisEngineDescriptorPath((IPath)config.getScriptFilePath(), (IProject)proj.getProject(), (ClassLoader)classLoader).toPortableString();
        IPath rootPath = RutaProjectUtils.getDescriptorRootPath((IProject)proj.getProject());
        File inputDir = inputDirPath.makeAbsolute().toFile();
        File outputDir = outputDirPath.makeAbsolute().toFile();
        if (!inputDir.exists()) {
            inputDir.mkdirs();
            IFolder folder = proj.getProject().getFolder(RutaProjectUtils.getDefaultInputLocation());
            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        IFolder outputFolder = proj.getProject().getFolder(RutaProjectUtils.getDefaultOutputLocation());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
            outputFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        if (clearOutput = (store = RutaIdeUIPlugin.getDefault().getPreferenceStore()).getBoolean("ProjectClearOutput")) {
            List<File> outputFiles = RutaInterpreterRunner.getFiles(outputDir, false);
            for (File file : outputFiles) {
                file.delete();
            }
            outputFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        List<File> inputFiles = RutaInterpreterRunner.getFiles(inputDir, false);
        int ticks = inputFiles.size() * 2 + 1;
        SubProgressMonitor mon = new SubProgressMonitor(monitor, ticks);
        mon.setTaskName("Initializing");
        Handler handler = RutaInterpreterRunner.initConsoleLink(config.getScriptFilePath().lastSegment());
        CAS cas = null;
        AnalysisEngine ae = null;
        try {
            File specFile = new File(engine);
            XMLInputSource in = new XMLInputSource(specFile);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            resMgr.setDataPath(rootPath.toPortableString());
            ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier, (ResourceManager)resMgr, null);
        }
        catch (Exception e) {
            String message = e.getMessage();
            DLTKCore.error((String)message, (Throwable)e);
            RutaInterpreterRunner.clearConsoleLink(handler);
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide.ui", 100, message, (Throwable)e));
        }
        try {
            if ("debug".equals(launchMode)) {
                ae.setConfigParameterValue("debug", (Object)true);
                ae.setConfigParameterValue("debugWithMatches", (Object)true);
                ae.setConfigParameterValue("profile", (Object)true);
                ae.setConfigParameterValue("statistics", (Object)true);
                ae.setConfigParameterValue("createdBy", (Object)true);
                ae.reconfigure();
            }
        }
        catch (Exception e) {
            RutaInterpreterRunner.clearConsoleLink(handler);
            String message = e.getMessage();
            DLTKCore.error((String)message, (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide.ui", 100, message, (Throwable)e));
        }
        mon.worked(1);
        for (File each : inputFiles) {
            mon.setTaskName("Processing " + each.getName());
            if (mon.isCanceled()) break;
            try {
                if (cas == null) {
                    cas = ae.newCAS();
                } else {
                    cas.reset();
                }
                if (each.getName().endsWith("xmi")) {
                    XmiCasDeserializer.deserialize((InputStream)new FileInputStream(each), (CAS)cas, (boolean)true);
                } else {
                    cas.setDocumentText(RutaInterpreterRunner.getText(each));
                }
                if (mon.isCanceled()) break;
                RutaEngine.removeSourceDocumentInformation((CAS)cas);
                RutaEngine.addSourceDocumentInformation((CAS)cas, (File)each);
                ae.process(cas);
                mon.worked(1);
                if (mon.isCanceled()) break;
                File outputFile = new File(outputDir, each.getName() + ".xmi");
                mon.setTaskName("Saving " + outputFile.getName());
                RutaInterpreterRunner.writeXmi(cas, outputFile);
                mon.worked(1);
            }
            catch (Exception e) {
                if (cas != null) {
                    cas.release();
                }
                if (ae != null) {
                    ae.destroy();
                }
                RutaInterpreterRunner.clearConsoleLink(handler);
                String message = e.getMessage();
                DLTKCore.error((String)message, (Throwable)e);
                throw new CoreException((IStatus)new Status(4, "org.apache.uima.ruta.ide.ui", 100, message, (Throwable)e));
            }
        }
        if (cas != null) {
            cas.release();
        }
        if (ae != null) {
            ae.destroy();
        }
        IFolder folder = outputFolder;
        folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        RutaInterpreterRunner.clearConsoleLink(handler);
        mon.done();
    }

    private static String getText(File each) {
        try {
            return FileUtil.loadTextFile((File)each, (String)"UTF-8");
        }
        catch (IOException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    public static String[] getClassPath(IJavaProject myJavaProject) {
        String[] newClassPath = new String[]{};
        return newClassPath;
    }

    protected static String[] computeBaseClassPath(IJavaProject myJavaProject) throws CoreException {
        if (!myJavaProject.exists()) {
            return new String[0];
        }
        return JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)myJavaProject);
    }

    protected String constructProgramString(InterpreterConfig config) {
        return "";
    }

    public RutaInterpreterRunner(IInterpreterInstall install) {
        super(install);
    }

    protected String getProcessType() {
        return "rutaInterpreter";
    }

    @Override
    public void setRunnerConfig(IRutaInterpreterRunnerConfig config) {
        this.config = config;
    }
}

