/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.testing.evaluator.ICasEvaluator;
import org.apache.uima.ruta.testing.ui.views.TestCasData;
import org.apache.uima.ruta.testing.ui.views.TestPageBookView;
import org.apache.uima.ruta.testing.ui.views.TestViewPage;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.TypeEvalData;
import org.apache.uima.ruta.testing.ui.views.util.EvalDataProcessor;
import org.apache.uima.ruta.type.EvalAnnotation;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xml.sax.SAXException;

public class RerunActionHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TestPageBookView debugView = (TestPageBookView)HandlerUtil.getActivePart((ExecutionEvent)event);
        TestViewPage debugPage = (TestViewPage)debugView.getCurrentPage();
        String viewCasName = debugPage.getSelectedViewCasName();
        String scriptName = debugPage.getResource().getLocation().lastSegment();
        RerunHandlerJob job = new RerunHandlerJob(event, scriptName, viewCasName, debugPage.getExcludedTypes(), debugPage.getIncludedTypes());
        job.addJobChangeListener((IJobChangeListener)new DebugJobChangeAdapter(debugPage){});
        job.schedule();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS aCas, File file) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file);
            XmiCasSerializer.serialize((CAS)aCas, (OutputStream)out);
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void calculateEvaluatData(TestCasData data, CAS resultCas) {
        TypeEvalData newData;
        int oldCount;
        TypeEvalData element;
        Type originalType;
        Annotation original;
        EvalAnnotation a;
        data.setEvaluationStatus(true);
        TypeSystem ts = resultCas.getTypeSystem();
        Type falsePositiveType = ts.getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = ts.getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = ts.getType("org.apache.uima.ruta.type.TruePositive");
        int falsePositiveCount = resultCas.getAnnotationIndex(falsePositiveType).size();
        int falseNegativeCount = resultCas.getAnnotationIndex(falseNegativeType).size();
        int truePositiveCount = resultCas.getAnnotationIndex(truePositiveType).size();
        data.setTruePositiveCount(truePositiveCount);
        data.setFalsePositiveCount(falsePositiveCount);
        data.setFalseNegativeCount(falseNegativeCount);
        HashMap<String, TypeEvalData> map = new HashMap<String, TypeEvalData>();
        AnnotationIndex index = resultCas.getAnnotationIndex(truePositiveType);
        FSIterator iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getTruePositives();
                element.setTruePositives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 1, 0, 0);
            map.put(originalType.getName(), newData);
        }
        index = resultCas.getAnnotationIndex(falsePositiveType);
        iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getFalsePositives();
                element.setFalsePositives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 0, 1, 0);
            map.put(originalType.getName(), newData);
        }
        index = resultCas.getAnnotationIndex(falseNegativeType);
        iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getFalseNegatives();
                element.setFalseNegatives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 0, 0, 1);
            map.put(originalType.getName(), newData);
        }
        data.setTypeEvalData(map);
    }

    private class DebugJobChangeAdapter
    extends JobChangeAdapter {
        private TestViewPage page;

        DebugJobChangeAdapter(TestViewPage page) {
            this.page = page;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                this.page.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugJobChangeAdapter.this.page.updateInfoPanel();
                    }
                });
            }
        }
    }

    private class RerunHandlerJob
    extends Job {
        ExecutionEvent event;
        private final String viewCasName;
        private List<String> excludedTypes;
        private List<String> includedTypes;

        RerunHandlerJob(ExecutionEvent event, String scriptName, String viewCasName, List<String> excludedTypes, List<String> includedTypes) {
            super("Testing " + scriptName + "...");
            this.event = event;
            this.viewCasName = viewCasName;
            this.excludedTypes = excludedTypes;
            this.includedTypes = includedTypes;
            this.setUser(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestPageBookView testPageView = (TestPageBookView)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            TestViewPage debugPage = (TestViewPage)testPageView.getCurrentPage();
            debugPage.saveState();
            testPageView.showBusy(true);
            IResource r = debugPage.getResource();
            IFile fScript = (IFile)r;
            IProject project = r.getProject();
            IPath engineDescriptorPath = RutaProjectUtils.getEngineDescriptorPath((IPath)r.getLocation(), (IProject)project);
            IPath typeSystemDescriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)fScript.getLocation(), (IProject)project);
            ArrayList testCasData = (ArrayList)debugPage.getViewer().getInput();
            int numFiles = testCasData.size();
            monitor.beginTask("Running evaluation, please wait", numFiles);
            IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
            boolean javaSupportMode = store.getBoolean("EXTEND_CLASSPATH");
            if (!javaSupportMode) {
                IStatus status = this.evalRutaOnlyScript(monitor, testPageView, debugPage, fScript, project, engineDescriptorPath, testCasData);
                if (status.getSeverity() == 4) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openWarning((Shell)shell, (String)"Error", (String)status.getMessage());
                }
                return status;
            }
            IStatus status = this.evalRutaWithClassPathScript(monitor, testPageView, debugPage, fScript, project, typeSystemDescriptorPath, testCasData);
            return status;
        }

        private IStatus evalRutaWithClassPathScript(IProgressMonitor monitor, TestPageBookView testPageView, TestViewPage debugPage, IFile fScript, IProject project, IPath typeSystemDescriptorPath, ArrayList<TestCasData> testCasData) {
            IPath cleanInputPath = project.getLocation().append(RutaProjectUtils.getDefaultTestLocation()).append(RutaProjectUtils.getDefaultCleanTestLocation());
            this.clearFolder(project, cleanInputPath);
            this.writeCleanInputFiles(testCasData, project, typeSystemDescriptorPath, cleanInputPath, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IPath runTestPath = project.getLocation().append(RutaProjectUtils.getDefaultTestLocation()).append(RutaProjectUtils.getDefaultTempTestLocation());
            this.clearFolder(project, runTestPath);
            this.runWithJVM(monitor, fScript, cleanInputPath, runTestPath);
            try {
                XMLInputSource in = new XMLInputSource(typeSystemDescriptorPath.toPortableString());
                TypeSystemDescription tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(in);
                CAS runCas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, null);
                CAS goldCas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, null);
                for (TestCasData td : testCasData) {
                    runCas.reset();
                    goldCas.reset();
                    IPath path2RunFile = runTestPath.append(td.getPath().toFile().getName());
                    String runFilePath = path2RunFile.toPortableString();
                    File runFile = new File(runFilePath);
                    this.deserializeCASs(goldCas, td, runCas, runFile);
                    runCas = runCas.getView(this.viewCasName);
                    goldCas = goldCas.getView(this.viewCasName);
                    this.evalLogicAndUpdateGUI(monitor, testPageView, debugPage, fScript, project, runCas, goldCas, td);
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
                monitor.done();
                testPageView.showBusy(false);
                return new Status(4, "org.apache.uima.ruta.addons", "Error during testing. See Error View for details.");
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private void runWithJVM(IProgressMonitor monitor, IFile scriptFile, IPath cleanInputPath, IPath runOutputPath) {
            monitor.setTaskName(String.format("Processing script \"%s\" [w classpatch ext.].", scriptFile.getName()));
            IProject project = scriptFile.getProject();
            String inputDirPath = null;
            String outputDirPath = null;
            if (cleanInputPath == null) {
                return;
            }
            inputDirPath = cleanInputPath.toFile().getAbsolutePath();
            if (runOutputPath == null) {
                return;
            }
            outputDirPath = runOutputPath.toFile().getAbsolutePath();
            IPath descriptorPath = RutaProjectUtils.getEngineDescriptorPath((IPath)scriptFile.getLocation(), (IProject)project);
            String descriptorAbsolutePath = descriptorPath.toFile().getAbsolutePath();
            try {
                ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = mgr.getLaunchConfigurationType("org.apache.uima.ruta.ide.launching.RutaLaunchConfigurationType");
                ILaunchConfigurationWorkingCopy copy = type.newInstance(null, scriptFile.getName() + ".Testing");
                copy.setAttribute("org.apache.uima.ruta.ide.launching.inputFolder", inputDirPath);
                copy.setAttribute("org.apache.uima.ruta.ide.launching.outputFolder", outputDirPath);
                copy.setAttribute("-descriptor", descriptorAbsolutePath);
                copy.setAttribute("project", project.getName());
                ILaunchConfiguration lc = copy.doSave();
                String mode = "run";
                Launch launch = new Launch(lc, mode, null);
                ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
                ILaunch launched = launchConfiguration.launch("run", monitor);
                while (!launched.isTerminated()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        RutaAddonsPlugin.error(e);
                    }
                }
            }
            catch (CoreException e) {
                RutaAddonsPlugin.error(e);
            }
        }

        private void clearFolder(IProject project, IPath folderPath) {
            FileUtils.deleteAllFiles((File)folderPath.toFile());
            try {
                project.getFolder(folderPath.makeRelativeTo(project.getLocation())).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deserializeCASs(CAS tdCas, TestCasData td, CAS casA, File fileA) throws FileNotFoundException, SAXException, IOException {
            if (!fileA.exists()) {
                throw new FileNotFoundException(fileA.getAbsolutePath());
            }
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(td.getPath().toPortableString()));
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)tdCas, (boolean)true);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            try {
                inputStream = new FileInputStream(fileA);
                XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)casA, (boolean)true);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCleanInputFiles(List<TestCasData> testCasData, IProject project, IPath tsDescriptorPath, IPath cleanInputPath, IProgressMonitor monitor) {
            try {
                XMLInputSource in = new XMLInputSource(tsDescriptorPath.toPortableString());
                TypeSystemDescription tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(in);
                CAS cleanCas = this.getEmptyCas(tsd);
                for (TestCasData td : testCasData) {
                    cleanCas.reset();
                    FileInputStream inputStreamRun = null;
                    try {
                        inputStreamRun = new FileInputStream(new File(td.getPath().toPortableString()));
                        XmiCasDeserializer.deserialize((InputStream)inputStreamRun, (CAS)cleanCas, (boolean)true);
                    }
                    finally {
                        if (inputStreamRun != null) {
                            inputStreamRun.close();
                        }
                    }
                    cleanCas = cleanCas.getView(this.viewCasName);
                    this.prepareCas(cleanCas);
                    IPath path2CleanFile = this.computeCleanPath(cleanInputPath, td);
                    String fPath = path2CleanFile.toPortableString();
                    File cleanFile = new File(fPath);
                    RerunActionHandler.writeXmi(cleanCas, cleanFile);
                    td.setResultPath(path2CleanFile);
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                cleanCas.release();
                project.getFolder(cleanInputPath.makeRelativeTo(project.getLocation())).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
            }
        }

        private IPath computeCleanPath(IPath cleanInputPath, TestCasData td) {
            return cleanInputPath.append(td.getPath().removeFileExtension().lastSegment() + ".xmi");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IStatus evalRutaOnlyScript(IProgressMonitor monitor, TestPageBookView testPageView, TestViewPage debugPage, IFile fScript, IProject project, IPath engineDescriptorPath, ArrayList<TestCasData> testCasData) {
            try {
                XMLInputSource in = new XMLInputSource(engineDescriptorPath.toPortableString());
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
                String desc = null;
                desc = engineDescriptorPath.toPortableString();
                XMLInputSource in2 = new XMLInputSource(desc);
                XMLizable descriptor = UIMAFramework.getXMLParser().parse(in2);
                CAS runCas = this.getEmptyCas(descriptor);
                CAS testCas = this.getEmptyCas(descriptor);
                for (TestCasData td : testCasData) {
                    runCas.reset();
                    testCas.reset();
                    String elementName = fScript.getLocation().lastSegment();
                    monitor.setTaskName("Processing [w/o classpatch ext.] " + td.getPath().lastSegment());
                    int lastIndexOf = elementName.lastIndexOf(".ruta");
                    if (lastIndexOf != -1) {
                        elementName = elementName.substring(0, lastIndexOf);
                    }
                    FileInputStream inputStreamTest = null;
                    try {
                        inputStreamTest = new FileInputStream(new File(td.getPath().toPortableString()));
                        XmiCasDeserializer.deserialize((InputStream)inputStreamTest, (CAS)testCas, (boolean)true);
                    }
                    finally {
                        if (inputStreamTest != null) {
                            inputStreamTest.close();
                        }
                    }
                    FileInputStream inputStreamRun = null;
                    try {
                        inputStreamRun = new FileInputStream(new File(td.getPath().toPortableString()));
                        XmiCasDeserializer.deserialize((InputStream)inputStreamRun, (CAS)runCas, (boolean)true);
                    }
                    finally {
                        if (inputStreamRun != null) {
                            inputStreamRun.close();
                        }
                    }
                    testCas = testCas.getView(this.viewCasName);
                    runCas = runCas.getView(this.viewCasName);
                    this.prepareCas(runCas);
                    ae.process(runCas);
                    this.evalLogicAndUpdateGUI(monitor, testPageView, debugPage, fScript, project, runCas, testCas, td);
                    if (!monitor.isCanceled()) continue;
                    ae.destroy();
                    return Status.CANCEL_STATUS;
                }
                ae.destroy();
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
                monitor.done();
                testPageView.showBusy(false);
                return new Status(4, "org.apache.uima.ruta.addons", "Error during testing. See Error View for details.");
            }
            monitor.done();
            testPageView.showBusy(false);
            return Status.OK_STATUS;
        }

        private void prepareCas(CAS cas) {
            if (!this.includedTypes.isEmpty()) {
                this.excludedTypes = new ArrayList<String>();
                List types = cas.getTypeSystem().getProperlySubsumedTypes(cas.getAnnotationType());
                for (Type type : types) {
                    if (this.includedTypes.contains(type.getName())) continue;
                    this.excludedTypes.add(type.getName());
                }
            }
            if (this.includedTypes.isEmpty() && this.excludedTypes.isEmpty()) {
                String documentText = cas.getDocumentText();
                cas.reset();
                cas.setDocumentText(documentText);
            } else {
                LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
                AnnotationIndex annotationIndex = cas.getAnnotationIndex();
                for (AnnotationFS annotationFS : annotationIndex) {
                    Type type = annotationFS.getType();
                    String typeName = type.getName();
                    if (!this.includedTypes.contains(typeName) && this.excludedTypes.contains(typeName)) continue;
                    toRemove.add(annotationFS);
                }
                System.out.println();
                for (AnnotationFS each : toRemove) {
                    if (cas.getDocumentAnnotation().equals(each)) continue;
                    cas.removeFsFromIndexes((FeatureStructure)each);
                }
            }
        }

        private void evalLogicAndUpdateGUI(IProgressMonitor monitor, TestPageBookView testPageView, final TestViewPage debugPage, IFile fScript, IProject project, CAS runCas, CAS goldCas, TestCasData td) throws AnalysisEngineProcessException, CASException, IOException, SAXException, CoreException {
            IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
            String factoryName = store.getString("EVALUATOR_FACTORY");
            ICasEvaluator evaluator = RutaAddonsPlugin.getCasEvaluatorFactoryById(factoryName).createEvaluator();
            boolean includeSubtypes = store.getBoolean("INCLUDE_SUBTYPES");
            boolean useAllTypes = store.getBoolean("ALL_TYPES");
            CAS resultCas = evaluator.evaluate(goldCas, runCas, this.excludedTypes, includeSubtypes, useAllTypes);
            IPath path2Test = td.getPath().removeLastSegments(1);
            monitor.setTaskName("Actually evaluating " + td.getPath().lastSegment());
            IPath estimatedTestPath = project.getFullPath().append(RutaProjectUtils.getDefaultTestLocation());
            IPath path2recource = fScript.getFullPath();
            IPath projectRelativePath2Script = path2recource.removeFirstSegments(2);
            IPath estimatedTestFolderPath = estimatedTestPath.append(projectRelativePath2Script.removeFileExtension());
            IPath path2Result = path2Test.append("results");
            IPath path2ResultFile = path2Result.append(td.getPath().removeFileExtension().lastSegment() + ".result.xmi");
            if (!path2Test.toOSString().contains(estimatedTestFolderPath.toOSString())) {
                path2Result = project.getLocation().append(RutaProjectUtils.getDefaultTestLocation()).append(RutaProjectUtils.getDefaultTempTestLocation());
                path2ResultFile = path2Result.append(td.getPath().removeFileExtension().lastSegment() + ".result.xmi");
            }
            File resultFile = new File(path2ResultFile.toPortableString());
            RerunActionHandler.writeXmi(resultCas, resultFile);
            td.setResultPath(path2ResultFile);
            EvalDataProcessor.calculateEvaluatData(td, resultCas);
            testPageView.getDefaultPage().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    debugPage.getViewer().refresh();
                }
            });
            monitor.worked(1);
            project.getFolder(path2Result.makeRelativeTo(project.getLocation())).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            runCas.release();
            goldCas.release();
            resultCas.release();
        }

        private CAS getEmptyCas(Object descriptor) throws ResourceInitializationException, InvalidXMLException {
            CAS testCas = null;
            if (descriptor instanceof AnalysisEngineDescription) {
                testCas = CasCreationUtils.createCas((AnalysisEngineDescription)((AnalysisEngineDescription)descriptor));
            } else if (descriptor instanceof TypeSystemDescription) {
                TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
                tsDesc.resolveImports();
                testCas = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
            }
            return testCas;
        }
    }
}

