/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.query.ui;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.extensions.IRutaActionExtension;
import org.apache.uima.ruta.extensions.IRutaBlockExtension;
import org.apache.uima.ruta.extensions.IRutaBooleanFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaConditionExtension;
import org.apache.uima.ruta.extensions.IRutaNumberFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaStringFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaTypeFunctionExtension;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.query.ui.QueryComposite;
import org.apache.uima.ruta.query.ui.QueryResult;
import org.apache.uima.ruta.query.ui.QueryView;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.ui.handlers.HandlerUtil;

public class QueryActionHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        QueryView queryView = (QueryView)HandlerUtil.getActivePart((ExecutionEvent)event);
        QueryComposite queryComposite = queryView.getComposite();
        String dir = queryComposite.getDataDirectory();
        String fileNameFilter = queryComposite.getFileFilter();
        String typesystem = queryComposite.getTypeSystem();
        String script = queryComposite.getScript();
        boolean recurive = queryComposite.isRecursive();
        QueryHandlerJob job = new QueryHandlerJob(event, dir, fileNameFilter, typesystem, script, recurive);
        job.addJobChangeListener((IJobChangeListener)new QueryJobChangeAdapter(queryComposite){});
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    private class QueryHandlerJob
    extends Job {
        ExecutionEvent event;
        private boolean recursive;
        private String rules;
        private String typeSystemLocation;
        private String dataLocation;
        private final String fileNameFilter;

        QueryHandlerJob(ExecutionEvent event, String dir, String fileNameFilter, String typeSystem, String rules, boolean recurive) {
            super(String.format("Query in \"%s\" [filter: \"%s\"] ...", dir, fileNameFilter));
            this.event = event;
            this.dataLocation = dir;
            this.fileNameFilter = fileNameFilter;
            this.typeSystemLocation = typeSystem;
            this.rules = rules;
            this.recursive = recurive;
            this.setUser(true);
        }

        private String getText(File each) {
            try {
                return FileUtils.file2String((File)each, (String)"UTF-8");
            }
            catch (IOException e) {
                DLTKCore.error((String)e.getMessage(), (Throwable)e);
                return "";
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            QueryView queryView = (QueryView)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            final QueryComposite queryComposite = queryView.getComposite();
            queryView.showBusy(true);
            monitor.beginTask("Initializing analysis engine...", 1);
            queryComposite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    queryComposite.setResult(null);
                }
            });
            int files = 0;
            int found = 0;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            final ArrayList<QueryResult> result = new ArrayList<QueryResult>();
            String script = "PACKAGE query;\n\n";
            script = script + this.rules;
            try {
                URL aedesc = RutaEngine.class.getResource("BasicEngine.xml");
                XMLInputSource inae = new XMLInputSource(aedesc);
                IFile iFile = QueryComposite.getIFile(this.typeSystemLocation);
                IProject project = iFile.getProject();
                ClassLoader classLoader = RutaProjectUtils.getClassLoader((IProject)project);
                ResourceManager_impl resMgr = new ResourceManager_impl(classLoader);
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(inae);
                AnalysisEngineDescription aed = (AnalysisEngineDescription)specifier;
                TypeSystemDescription basicTypeSystem = aed.getAnalysisEngineMetaData().getTypeSystem();
                if (!StringUtils.isEmpty((CharSequence)this.typeSystemLocation)) {
                    String tsLocation = this.typeSystemLocation;
                    ArrayList<TypeSystemDescription> tsds = new ArrayList<TypeSystemDescription>();
                    tsds.add(basicTypeSystem);
                    if (this.typeSystemLocation.endsWith(".ruta")) {
                        IPath scriptPath = iFile.getLocation();
                        IPath descriptorRootPath = RutaProjectUtils.getDescriptorRootPath((IProject)project);
                        resMgr.setDataPath(descriptorRootPath.toPortableString());
                        IPath path = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)scriptPath, (IProject)project, (ClassLoader)classLoader);
                        tsLocation = path.toPortableString();
                    }
                    File tsFile = new File(tsLocation);
                    XMLInputSource ints = new XMLInputSource(tsFile);
                    TypeSystemDescription importTSD = UIMAFramework.getXMLParser().parseTypeSystemDescription(ints);
                    importTSD.resolveImports((ResourceManager)resMgr);
                    tsds.add(importTSD);
                    TypeSystemDescription mergeTypeSystems = CasCreationUtils.mergeTypeSystems(tsds);
                    aed.getAnalysisEngineMetaData().setTypeSystem(mergeTypeSystems);
                }
                aed.resolveImports((ResourceManager)resMgr);
                AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aed, (ResourceManager)resMgr, null);
                File tempFile = File.createTempFile("RutaQuery", ".ruta");
                tempFile.deleteOnExit();
                FileUtils.saveString2File((String)script, (File)tempFile, (String)"UTF-8");
                String portableString = Path.fromOSString((String)tempFile.getParentFile().getPath()).toPortableString();
                ae.setConfigParameterValue("scriptPaths", (Object)new String[]{portableString});
                String name = tempFile.getName().substring(0, tempFile.getName().length() - 5);
                ae.setConfigParameterValue("mainScript", (Object)name);
                ae.setConfigParameterValue("debug", (Object)true);
                ae.setConfigParameterValue("debugWithMatches", (Object)true);
                ae.setConfigParameterValue("profile", (Object)false);
                ae.setConfigParameterValue("statistics", (Object)false);
                IRutaConditionExtension[] conditionExtensions = RutaExtensionManager.getDefault().getRutaConditionExtensions();
                IRutaActionExtension[] actionExtensions = RutaExtensionManager.getDefault().getRutaActionExtensions();
                IRutaBooleanFunctionExtension[] booleanFunctionExtensions = RutaExtensionManager.getDefault().getRutaBooleanFunctionExtensions();
                IRutaNumberFunctionExtension[] numberFunctionExtensions = RutaExtensionManager.getDefault().getRutaNumberFunctionExtensions();
                IRutaStringFunctionExtension[] stringFunctionExtensions = RutaExtensionManager.getDefault().getRutaStringFunctionExtensions();
                IRutaTypeFunctionExtension[] typeFunctionExtensions = RutaExtensionManager.getDefault().getRutaTypeFunctionExtensions();
                IRutaBlockExtension[] blockExtensions = RutaExtensionManager.getDefault().getRutaBlockExtensions();
                ArrayList<String> languageExtensions = new ArrayList<String>();
                for (IRutaConditionExtension iRutaConditionExtension : conditionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : actionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : booleanFunctionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : numberFunctionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : stringFunctionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : typeFunctionExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                for (IRutaConditionExtension iRutaConditionExtension : blockExtensions) {
                    languageExtensions.add(iRutaConditionExtension.getClass().getName());
                }
                ae.setConfigParameterValue("additionalExtensions", (Object)languageExtensions.toArray(new String[0]));
                ae.reconfigure();
                CAS cas = ae.newCAS();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    if (ae != null) {
                        ae.destroy();
                    }
                    if (cas != null) {
                        cas.release();
                    }
                    return Status.CANCEL_STATUS;
                }
                File dir = new File(this.dataLocation);
                List<File> inputFiles = this.getFiles(dir, this.recursive);
                monitor.beginTask("Query in " + dir.getName() + "...", inputFiles.size());
                for (File each : inputFiles) {
                    monitor.setTaskName("Query in " + each.getName() + "...");
                    if (monitor.isCanceled()) {
                        if (ae != null) {
                            ae.destroy();
                        }
                        if (cas != null) {
                            cas.release();
                        }
                        return Status.CANCEL_STATUS;
                    }
                    cas.reset();
                    if (each.getName().endsWith("xmi")) {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(each), (CAS)cas, (boolean)true);
                    } else {
                        cas.setDocumentText(this.getText(each));
                    }
                    Type matchedType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugMatchedRuleMatch");
                    Type ruleApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugRuleApply");
                    Type blockApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugBlockApply");
                    this.removeDebugAnnotations(cas, matchedType, ruleApplyType, blockApplyType);
                    ae.process(cas);
                    Feature innerApplyFeature = blockApplyType.getFeatureByBaseName("innerApply");
                    Feature ruleApplyFeature = blockApplyType.getFeatureByBaseName("rules");
                    FSIterator iterator = cas.getAnnotationIndex(blockApplyType).iterator();
                    boolean foundOne = false;
                    while (iterator.isValid()) {
                        if (monitor.isCanceled()) {
                            if (ae != null) {
                                ae.destroy();
                            }
                            if (cas != null) {
                                cas.release();
                            }
                            return Status.CANCEL_STATUS;
                        }
                        AnnotationFS fs = (AnnotationFS)iterator.get();
                        int find = this.findRuleMatches(result, fs, each, queryComposite, matchedType, ruleApplyType, blockApplyType, innerApplyFeature, ruleApplyFeature);
                        iterator.moveToNext();
                        found += find;
                        if (!foundOne && find > 0) {
                            foundOne = true;
                        }
                        final int constFound = found;
                        final int constFiles = ++files;
                        queryComposite.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                queryComposite.setResult(result);
                                queryComposite.setResultInfo(constFound, constFiles);
                            }
                        });
                    }
                    monitor.worked(1);
                }
                cas.release();
                ae.destroy();
                monitor.done();
            }
            catch (Exception e) {
                queryComposite.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        queryComposite.setRutaQuerySyntaxError(true);
                    }
                });
                RutaAddonsPlugin.error(e);
            }
            return Status.OK_STATUS;
        }

        public List<File> getFiles(File dir, boolean recusive) {
            ArrayList<File> result = new ArrayList<File>();
            if (this.fileNameFilter == null) {
                return result;
            }
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches(QueryHandlerJob.this.fileNameFilter, pathname.getName());
                }
            };
            for (File each : dir.listFiles(fileFilter)) {
                result.add(each);
            }
            if (recusive) {
                for (File subdir : dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    result.addAll(this.getFiles(subdir, recusive));
                }
            }
            return result;
        }

        private void removeDebugAnnotations(CAS cas, Type matchedType, Type ruleApplyType, Type blockApplyType) {
            ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
            AnnotationIndex annotationIndex = cas.getAnnotationIndex(blockApplyType);
            for (AnnotationFS annotationFS : annotationIndex) {
                toRemove.add(annotationFS);
            }
            annotationIndex = cas.getAnnotationIndex(ruleApplyType);
            for (AnnotationFS annotationFS : annotationIndex) {
                toRemove.add(annotationFS);
            }
            annotationIndex = cas.getAnnotationIndex(matchedType);
            for (AnnotationFS annotationFS : annotationIndex) {
                toRemove.add(annotationFS);
            }
            for (AnnotationFS annotationFS : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)annotationFS);
            }
        }

        public int findRuleMatches(List<QueryResult> result, AnnotationFS fs, File file, QueryComposite queryComposite, Type matchedType, Type ruleApplyType, Type blockApplyType, Feature innerApplyFeature, Feature ruleApplyFeature) {
            int ret = 0;
            if (fs.getType().equals(blockApplyType)) {
                FeatureStructure featureValue = fs.getFeatureValue(innerApplyFeature);
                FSArray array = (FSArray)featureValue;
                for (int i = 0; i < array.size(); ++i) {
                    AnnotationFS eachApply = (AnnotationFS)array.get(i);
                    ret += this.findRuleMatches(result, eachApply, file, queryComposite, matchedType, ruleApplyType, blockApplyType, innerApplyFeature, ruleApplyFeature);
                }
            } else if (fs.getType().equals(ruleApplyType)) {
                FeatureStructure featureValue = fs.getFeatureValue(ruleApplyFeature);
                FSArray array = (FSArray)featureValue;
                for (int i = 0; i < array.size(); ++i) {
                    AnnotationFS eachApply = (AnnotationFS)array.get(i);
                    ret += this.findRuleMatches(result, eachApply, file, queryComposite, matchedType, ruleApplyType, blockApplyType, innerApplyFeature, ruleApplyFeature);
                }
            } else if (fs.getType().equals(matchedType)) {
                result.add(new QueryResult(fs.getBegin(), fs.getEnd(), fs.getCoveredText(), file));
                ++ret;
            }
            return ret;
        }
    }

    private class QueryJobChangeAdapter
    extends JobChangeAdapter {
        private QueryComposite composite;

        QueryJobChangeAdapter(QueryComposite composite) {
            this.composite = composite;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                this.composite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QueryJobChangeAdapter.this.composite.update();
                    }
                });
            }
        }
    }
}

