/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.RutaKeywordsManager;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.core.extensions.IIDEActionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEBooleanFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEConditionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDENumberFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDEStringFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IIDETypeFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IRutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.core.extensions.IRutaExtension;
import org.apache.uima.ruta.ide.parser.ast.FeatureMatchExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.apache.uima.ruta.ide.parser.ast.RutaRegExpRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRuleElement;
import org.apache.uima.ruta.ide.parser.ast.RutaStringExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaStructureAction;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeConstants;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.ruta.ide.validator.RutaCheckerDefaultProblem;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

public class RutaVarRefChecker
implements IBuildParticipant,
IBuildParticipantExtension {
    private IScriptProject project;

    public boolean beginBuild(int buildType) {
        return true;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        this.project = context.getSourceModule().getScriptProject();
        Object mdObj = context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (!(mdObj instanceof ModuleDeclaration)) {
            return;
        }
        ModuleDeclaration md = (ModuleDeclaration)mdObj;
        IProblemReporter problemReporter = context.getProblemReporter();
        ISourceModule smod = context.getSourceModule();
        ISourceLineTracker linetracker = context.getLineTracker();
        try {
            VarRefVisitor visitor = new VarRefVisitor(problemReporter, linetracker, smod);
            md.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VarRefVisitor
    extends ASTVisitor {
        private final String implicitString = "Implicit";
        private final Stack<Map<String, Integer>> knownLocalVariables;
        private Set<String> knownLocalTypeNames;
        private IProblemReporter rep;
        private ISourceModule currentFile;
        private ISourceLineTracker linetracker;
        private static final String errMsgHead = "Variable \"";
        private static final String errMsgTailDefault = " defined in this script or block!";
        private RutaCheckerProblemFactory problemFactory;
        private TypeSystemDescription description;
        private String matchedType;
        private Set<String> completeTypes;
        private Set<String> shortTypes;
        private Map<String, IIDEActionExtension> actionExtensions;
        private Map<String, IIDEConditionExtension> conditionExtensions;
        private Map<String, IIDEBooleanFunctionExtension> booleanFunctionExtensions;
        private Map<String, IIDENumberFunctionExtension> numberFunctionExtensions;
        private Map<String, IIDEStringFunctionExtension> stringFunctionExtensions;
        private Map<String, IIDETypeFunctionExtension> typeFunctionExtensions;

        public VarRefVisitor(IProblemReporter rep, ISourceLineTracker linetracker, ISourceModule curFile) {
            IIDETypeFunctionExtension[] tfextensions;
            IIDEStringFunctionExtension[] sfextensions;
            IIDEBooleanFunctionExtension[] bfextensions;
            IIDENumberFunctionExtension[] nfextensions;
            IIDEActionExtension[] aextensions;
            IIDEConditionExtension[] cextensions;
            this.linetracker = linetracker;
            this.rep = rep;
            this.knownLocalVariables = new Stack();
            this.knownLocalVariables.push(new HashMap());
            this.currentFile = curFile;
            this.knownLocalTypeNames = new HashSet<String>();
            this.problemFactory = new RutaCheckerProblemFactory(this.currentFile.getElementName(), linetracker);
            this.conditionExtensions = new HashMap<String, IIDEConditionExtension>();
            this.actionExtensions = new HashMap<String, IIDEActionExtension>();
            this.numberFunctionExtensions = new HashMap<String, IIDENumberFunctionExtension>();
            this.booleanFunctionExtensions = new HashMap<String, IIDEBooleanFunctionExtension>();
            this.stringFunctionExtensions = new HashMap<String, IIDEStringFunctionExtension>();
            this.typeFunctionExtensions = new HashMap<String, IIDETypeFunctionExtension>();
            for (IIDEConditionExtension each : cextensions = RutaExtensionManager.getDefault().getIDEConditionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.conditionExtensions.put(string, each);
                }
            }
            for (IIDEActionExtension each : aextensions = RutaExtensionManager.getDefault().getIDEActionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.actionExtensions.put(string, each);
                }
            }
            for (IIDENumberFunctionExtension each : nfextensions = RutaExtensionManager.getDefault().getIDENumberFunctionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.numberFunctionExtensions.put(string, each);
                }
            }
            for (IIDEBooleanFunctionExtension each : bfextensions = RutaExtensionManager.getDefault().getIDEBooleanFunctionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.booleanFunctionExtensions.put(string, each);
                }
            }
            for (IIDEStringFunctionExtension each : sfextensions = RutaExtensionManager.getDefault().getIDEStringFunctionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.stringFunctionExtensions.put(string, each);
                }
            }
            for (IIDETypeFunctionExtension each : tfextensions = RutaExtensionManager.getDefault().getIDETypeFunctionExtensions()) {
                String[] knownExtensions;
                for (String string : knownExtensions = each.getKnownExtensions()) {
                    this.typeFunctionExtensions.put(string, each);
                }
            }
            try {
                this.description = this.getTypeSystemOfScript();
            }
            catch (InvalidXMLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            this.completeTypes = new TreeSet<String>();
            this.shortTypes = new TreeSet<String>();
            if (this.description != null) {
                TypeDescription[] types;
                for (TypeDescription typeDescription : types = this.description.getTypes()) {
                    this.completeTypes.add(typeDescription.getName());
                    this.shortTypes.add(this.getShortName(typeDescription.getName()));
                }
            }
        }

        private String isFeatureMatch(String text) {
            String t;
            for (String each : this.shortTypes) {
                t = this.checkFeatureMatch(text, each);
                if (t == null) continue;
                return t;
            }
            for (String each : this.completeTypes) {
                t = this.checkFeatureMatch(text, each);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        private String checkFeatureMatch(String name, String type) {
            if (name.startsWith(type)) {
                boolean foundAll = true;
                if (name.length() > type.length()) {
                    String tail = name.substring(type.length() + 1);
                    String[] split = tail.split("[.]");
                    String typeToCheck = type;
                    for (String feat : split) {
                        if (foundAll &= (typeToCheck = this.checkFSFeatureOfType(feat, typeToCheck)) != null) continue;
                        return null;
                    }
                    return typeToCheck;
                }
                return type;
            }
            return null;
        }

        private String checkFSFeatureOfType(String feat, String type) {
            FeatureDescription[] features;
            TypeDescription t;
            if (type.indexOf(".") == -1) {
                for (String each : this.completeTypes) {
                    String[] split = each.split("[.]");
                    if (!split[split.length - 1].equals(type)) continue;
                    type = each;
                    break;
                }
            }
            if ((t = this.description.getType(type)) == null) {
                return null;
            }
            for (FeatureDescription featureDescription : features = t.getFeatures()) {
                String name = featureDescription.getName();
                String rangeTypeName = featureDescription.getRangeTypeName();
                boolean isFS = this.isFeatureStructure(rangeTypeName);
                if (!name.equals(feat) || !isFS) continue;
                return rangeTypeName;
            }
            return null;
        }

        private boolean isFeatureStructure(String rangeTypeName) {
            if (rangeTypeName.equals("uima.tcas.Annotation") || rangeTypeName.equals("uima.cas.TOP")) {
                return true;
            }
            TypeDescription type = this.description.getType(rangeTypeName);
            if (type == null) {
                return false;
            }
            String supertypeName = type.getSupertypeName();
            if (supertypeName != null) {
                return this.isFeatureStructure(supertypeName);
            }
            return false;
        }

        public boolean endvisit(Expression s) throws Exception {
            if (s instanceof RutaRuleElement) {
                this.matchedType = null;
            }
            return super.endvisit(s);
        }

        public boolean endvisit(MethodDeclaration s) throws Exception {
            if (s instanceof RutaBlock) {
                this.knownLocalVariables.pop();
            }
            return super.endvisit(s);
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            if (s instanceof RutaBlock) {
                this.knownLocalVariables.push(new HashMap());
            }
            return true;
        }

        public boolean visit(Statement s) throws Exception {
            if (s instanceof RutaTypeDeclaration) {
                this.knownLocalTypeNames.add(((RutaTypeDeclaration)s).getName());
                return false;
            }
            if (s instanceof RutaVariableDeclaration) {
                RutaVariableDeclaration newVar = (RutaVariableDeclaration)s;
                if (this.knowsVariable(newVar.getName())) {
                    IProblem problem = this.problemFactory.createIdConflictsWithVariableProblem((RutaAbstractDeclaration)newVar);
                    this.rep.reportProblem(problem);
                    return false;
                }
                if (this.knownLocalTypeNames.contains(newVar.getName())) {
                    IProblem problem = this.problemFactory.createIdConflictsWithTypeProblem((RutaAbstractDeclaration)newVar);
                    this.rep.reportProblem(problem);
                    return false;
                }
                this.knownLocalVariables.peek().put(newVar.getName(), newVar.getKind());
                return false;
            }
            if (s instanceof RutaRegExpRule) {
                RutaRegExpRule rule = (RutaRegExpRule)s;
                Map faMap = rule.getFeats();
                Set typeEntrySet = faMap.entrySet();
                for (Map.Entry entry : typeEntrySet) {
                    Expression struct = (Expression)entry.getKey();
                    String structure = "";
                    if (struct != null) {
                        structure = this.currentFile.getSource().substring(struct.sourceStart(), struct.sourceEnd());
                    }
                    Map fmap = (Map)entry.getValue();
                    Set keySet = fmap.keySet();
                    for (Expression fkey : keySet) {
                        if (!(fkey instanceof RutaExpression) || fkey.getKind() != 0x200000) continue;
                        String feat = fkey.toString();
                        boolean findFeature = this.findFeature(structure, feat = this.getFeatureName(fkey, feat));
                        if (findFeature) continue;
                        IProblem problem = this.problemFactory.createUnknownFeatureProblem(fkey, structure);
                        this.rep.reportProblem(problem);
                    }
                }
            }
            return true;
        }

        private boolean knowsVariable(String name) {
            for (Map map : this.knownLocalVariables) {
                if (!map.containsKey(name)) continue;
                return true;
            }
            return false;
        }

        private Integer getVariableType(String name) {
            for (Map map : this.knownLocalVariables) {
                Integer integer = (Integer)map.get(name);
                if (integer == null) continue;
                return integer;
            }
            return 0;
        }

        public boolean visit(Expression s) throws Exception {
            IProblem problem;
            String feat;
            List<String> asList;
            String[] keywords;
            if (s instanceof RutaRuleElement) {
                RutaRuleElement re = (RutaRuleElement)s;
                Expression head = re.getHead();
                if (head instanceof FeatureMatchExpression) {
                    FeatureMatchExpression fme = (FeatureMatchExpression)head;
                    String text = fme.getFeature().getText();
                    int lastIndexOf = text.lastIndexOf(46);
                    String twf = text.substring(0, lastIndexOf);
                    this.matchedType = this.isFeatureMatch(twf);
                } else if (head != null) {
                    String type;
                    this.matchedType = type = this.currentFile.getSource().substring(head.sourceStart(), head.sourceEnd());
                }
            }
            if (s instanceof RutaVariableReference) {
                RutaVariableReference ref = (RutaVariableReference)s;
                if ((ref.getType() & 0x800000) != 0) {
                    return false;
                }
                if (!this.isVariableDeclared(ref)) {
                    return false;
                }
                this.checkTypeOfReference(ref);
                return false;
            }
            if (s instanceof RutaAction) {
                List childs;
                IRutaExtension extension;
                RutaAction tma = (RutaAction)s;
                String actionName = this.currentFile.getSource().substring(tma.getNameStart(), tma.getNameEnd());
                keywords = RutaKeywordsManager.getKeywords((int)5);
                asList = Arrays.asList(keywords);
                if (!(StringUtils.isEmpty((CharSequence)actionName) || "-".equals(actionName) || asList.contains(actionName) || "Implicit".equals(tma.getName()))) {
                    IProblem problem2 = this.problemFactory.createUnknownActionProblem(tma);
                    this.rep.reportProblem(problem2);
                }
                if ((extension = (IRutaExtension)this.actionExtensions.get(actionName)) != null) {
                    extension.checkSyntax((Expression)tma, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                }
                if (tma.getName().equals("GETFEATURE") || tma.getName().equals("SETFEATURE")) {
                    childs = tma.getChilds();
                    RutaStringExpression stringExpr = (RutaStringExpression)childs.get(0);
                    feat = stringExpr.toString();
                    boolean featureFound = this.findFeature(this.matchedType, feat = this.getFeatureName((Expression)stringExpr, feat));
                    if (!featureFound) {
                        problem = this.problemFactory.createUnknownFeatureProblem((Expression)stringExpr, this.matchedType);
                        this.rep.reportProblem(problem);
                    }
                }
                if (tma.getKind() == 10051) {
                    childs = tma.getChilds();
                    try {
                        RutaVariableReference ref = (RutaVariableReference)childs.get(0);
                        RutaExpression expr = (RutaExpression)childs.get(1);
                        int type = expr.getKind();
                        if (ref.getType() == 0x1000000) {
                            ref.setType(type);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        return false;
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                }
                if (s instanceof RutaStructureAction) {
                    RutaStructureAction sa = (RutaStructureAction)s;
                    Expression struct = sa.getStructure();
                    String structure = null;
                    if (struct != null) {
                        structure = this.currentFile.getSource().substring(struct.sourceStart(), struct.sourceEnd());
                    }
                    Map assignments = sa.getAssignments();
                    String action = this.currentFile.getSource().substring(sa.getNameStart(), sa.getNameEnd());
                    if (assignments != null && !action.equals("TRIE")) {
                        for (Expression each : assignments.keySet()) {
                            String feat2 = each.toString();
                            boolean featureFound = this.findFeature(structure, feat2 = this.getFeatureName(each, feat2));
                            if (featureFound) continue;
                            IProblem problem3 = this.problemFactory.createUnknownFeatureProblem(each, structure);
                            this.rep.reportProblem(problem3);
                        }
                    }
                }
            }
            if (s instanceof RutaCondition) {
                IRutaExtension extension;
                RutaCondition cond = (RutaCondition)s;
                String conditionName = this.currentFile.getSource().substring(cond.getNameStart(), cond.getNameEnd());
                keywords = RutaKeywordsManager.getKeywords((int)4);
                asList = Arrays.asList(keywords);
                if (!(StringUtils.isEmpty((CharSequence)conditionName) || "-".equals(conditionName) || asList.contains(conditionName) || "Implicit".equals(cond.getName()))) {
                    IProblem problem4 = this.problemFactory.createUnknownConditionProblem(cond);
                    this.rep.reportProblem(problem4);
                }
                if ((extension = (IRutaExtension)this.conditionExtensions.get(conditionName)) != null) {
                    extension.checkSyntax((Expression)cond, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                }
                if (conditionName.equals("FEATURE") && this.matchedType != null) {
                    List args = cond.getChilds();
                    RutaStringExpression se = (RutaStringExpression)args.get(0);
                    feat = se.toString();
                    boolean featureFound = this.findFeature(this.matchedType, feat = this.getFeatureName((Expression)se, feat));
                    if (!featureFound) {
                        problem = this.problemFactory.createUnknownFeatureProblem((Expression)se, this.matchedType);
                        this.rep.reportProblem(problem);
                    }
                }
            }
            if (s instanceof RutaFunction) {
                IRutaExtension extension;
                RutaFunction f = (RutaFunction)s;
                String name = f.getName();
                if (s.getKind() == 0x800000) {
                    extension = (IRutaExtension)this.typeFunctionExtensions.get(name);
                    if (extension != null) {
                        extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                    }
                } else if (s.getKind() == 0x400000) {
                    extension = (IRutaExtension)this.booleanFunctionExtensions.get(name);
                    if (extension != null) {
                        extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                    }
                } else if (s.getKind() == 262144) {
                    extension = (IRutaExtension)this.numberFunctionExtensions.get(name);
                    if (extension != null) {
                        extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                    }
                } else if (s.getKind() == 0x200000 && (extension = (IRutaExtension)this.stringFunctionExtensions.get(name)) != null) {
                    extension.checkSyntax(s, (IRutaCheckerProblemFactory)this.problemFactory, this.rep);
                }
            }
            return true;
        }

        private String getFeatureName(Expression e, String feat) {
            Object object2;
            List childs2;
            Object object;
            List childs = e.getChilds();
            if (childs != null && !childs.isEmpty() && (object = childs.get(0)) instanceof ASTListNode && (childs2 = ((ASTListNode)object).getChilds()) != null && !childs2.isEmpty() && (object2 = childs2.get(0)) instanceof StringLiteral) {
                StringLiteral sl = (StringLiteral)object2;
                feat = sl.getValue().replaceAll("\"", "");
            }
            return feat;
        }

        private boolean findFeature(String structure, String feat) {
            String typeName;
            if (this.description == null) {
                return true;
            }
            if (structure == null) {
                return false;
            }
            if ((structure.equals("Document") || structure.equals("DocumentAnnotation") || structure.equals("uima.tcas.DocumentAnnotation")) && feat.equals("language")) {
                return true;
            }
            boolean featureFound = false;
            TypeDescription[] descriptions = this.description.getTypes();
            HashMap<String, TypeDescription> typeMap = new HashMap<String, TypeDescription>();
            for (TypeDescription typeDescription : descriptions) {
                typeName = typeDescription.getName();
                typeMap.put(typeName, typeDescription);
            }
            for (TypeDescription typeDescription : descriptions) {
                typeName = typeDescription.getName();
                String shortName = this.getShortName(typeName);
                if (typeName.equals(structure) || shortName.equals(structure)) {
                    Collection<FeatureDescription> allFeatures = this.getAllDeclaredFeatures(typeDescription, typeMap);
                    for (FeatureDescription featureDescription : allFeatures) {
                        String featureName = featureDescription.getName();
                        if (!featureName.equals(feat)) continue;
                        featureFound = true;
                        break;
                    }
                }
                if (featureFound) break;
            }
            return featureFound;
        }

        private String getShortName(String typeName) {
            String[] nameSpace = typeName.split("[.]");
            return nameSpace[nameSpace.length - 1];
        }

        private Collection<FeatureDescription> getAllDeclaredFeatures(TypeDescription typeDescription, Map<String, TypeDescription> typeMap) {
            HashSet<FeatureDescription> result = new HashSet<FeatureDescription>();
            if (typeDescription == null) {
                return result;
            }
            FeatureDescription[] features = typeDescription.getFeatures();
            if (features == null) {
                return result;
            }
            result.addAll(Arrays.asList(features));
            String supertypeName = typeDescription.getSupertypeName();
            if (supertypeName != null) {
                TypeDescription parent = typeMap.get(supertypeName);
                result.addAll(this.getAllDeclaredFeatures(parent, typeMap));
            }
            return result;
        }

        private TypeSystemDescription getTypeSystemOfScript() throws InvalidXMLException, IOException {
            IPath descriptorPath = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)this.currentFile.getPath().removeFirstSegments(1), (IProject)RutaVarRefChecker.this.project.getProject());
            TypeSystemDescription typeSysDescr = null;
            typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(descriptorPath.toPortableString()));
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            IFolder folder = RutaVarRefChecker.this.project.getProject().getFolder(RutaProjectUtils.getDefaultDescriptorLocation());
            resMgr.setDataPath(folder.getLocation().toPortableString());
            typeSysDescr.resolveImports(resMgr);
            return typeSysDescr;
        }

        private boolean checkTypeOfReference(RutaVariableReference ref) throws IllegalAccessException {
            Integer vt = this.getVariableType(ref.getName());
            if (vt == null) {
                throw new IllegalAccessException(ref.getName() + " not declared.");
            }
            int variableType = vt;
            int requiredType = ref.getType();
            if ((requiredType & 0x1000000) != 0) {
                return true;
            }
            if ((variableType & requiredType) == 0) {
                String errMsg = errMsgHead + ref.getName() + "\" has type " + (String)RutaTypeConstants.typeStringOfInt.get(variableType) + ". \nBut type " + (String)RutaTypeConstants.typeStringOfInt.get(requiredType) + " required.";
                RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.currentFile.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
                this.rep.reportProblem((IProblem)problem);
                return false;
            }
            return true;
        }

        private boolean isVariableDeclared(RutaVariableReference ref) {
            if (!this.knowsVariable(ref.getName())) {
                if (this.knownLocalTypeNames.contains(ref.getName())) {
                    String errMsg = "\"" + ref.getName() + "\" declared as a ANNOTATION_TYPE. Variable of type " + (String)RutaTypeConstants.typeStringOfInt.get(ref.getType()) + " required.";
                    RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.currentFile.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
                    this.rep.reportProblem((IProblem)problem);
                    return false;
                }
                String errMsg = errMsgHead + ref.getName() + "\" not" + errMsgTailDefault;
                RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.currentFile.getElementName(), errMsg, (ASTNode)ref, this.linetracker.getLineNumberOfOffset(ref.sourceStart()));
                this.rep.reportProblem((IProblem)problem);
                return false;
            }
            return true;
        }
    }
}

