/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.ruta.ide.RutaIdeUIPlugin;
import org.apache.uima.ruta.ide.parser.ast.RutaStatement;
import org.apache.uima.ruta.ide.ui.RutaPartitions;
import org.apache.uima.ruta.ide.ui.text.RutaPartitionScanner;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RutaFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private List fBlockExcludeList = new ArrayList();
    private int fBlockFolding = 0;
    private List fBlockIncludeList = new ArrayList();
    private boolean fInitCollapseBlocks = true;
    private boolean fInitCollapseComments = true;
    private boolean fInitCollapseNamespaces = true;

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ISourceParser pp = null;
        pp = DLTKLanguageManager.getSourceParser((String)"org.apache.uima.ruta.ide.nature");
        ModuleDeclaration md = (ModuleDeclaration)pp.parse((IModuleSource)new ModuleSource(code), null);
        List statements = md.getStatements();
        if (statements == null) {
            return new AbstractASTFoldingStructureProvider.CodeBlock[0];
        }
        ArrayList result = new ArrayList();
        this.traverse(result, statements, offset, code);
        return result.toArray(new AbstractASTFoldingStructureProvider.CodeBlock[result.size()]);
    }

    private void checkStatement(String code, int offset, List result, Statement sst) {
        if (sst instanceof RutaStatement) {
            RutaStatement statement = (RutaStatement)sst;
            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
            Iterator si = statement.getExpressions().iterator();
        }
    }

    private void traverse(List result, List statements, int offset, String code) {
        for (ASTNode node : statements) {
            TypeDeclaration statement;
            if (node instanceof RutaStatement) {
                this.checkStatement(code, offset, result, (Statement)node);
                continue;
            }
            if (node instanceof TypeDeclaration) {
                statement = (TypeDeclaration)node;
                result.add(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
                this.traverse(result, statement.getStatements(), offset, code);
                continue;
            }
            if (!(node instanceof MethodDeclaration)) continue;
            statement = (MethodDeclaration)node;
            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
            this.traverse(result, statement.getStatements(), offset, code);
        }
    }

    protected String getCommentPartition() {
        return "__ruta_comment";
    }

    protected ILog getLog() {
        return RutaIdeUIPlugin.getDefault().getLog();
    }

    protected String getPartition() {
        return "__ruta_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new RutaPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return RutaPartitions.RUTA_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.apache.uima.ruta.ide.nature";
    }

    protected void initializePreferences(IPreferenceStore store) {
        int i;
        super.initializePreferences(store);
        this.fBlockFolding = store.getInt("editor_folding_blocks");
        String t = store.getString("editor_folding_exclude_list");
        String[] items = t.split(",");
        this.fBlockExcludeList.clear();
        for (i = 0; i < items.length; ++i) {
            if (items[i].trim().length() <= 0) continue;
            this.fBlockExcludeList.add(items[i]);
        }
        t = store.getString("editor_folding_include_list");
        items = t.split(",");
        this.fBlockIncludeList.clear();
        for (i = 0; i < items.length; ++i) {
            if (items[i].trim().length() <= 0) continue;
            this.fBlockIncludeList.add(items[i]);
        }
        this.fFoldNewLines = store.getBoolean("editor_folding_comments_lines");
        this.fInitCollapseBlocks = store.getBoolean("editor_folding_init_blocks");
        this.fInitCollapseComments = store.getBoolean("editor_folding_init_comments");
        this.fInitCollapseNamespaces = store.getBoolean("editor_folding_init_namespaces");
    }

    protected boolean initiallyCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (s instanceof RutaStatement) {
            RutaStatement statement = (RutaStatement)s;
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            if (name.equals("namespace")) {
                return ctx.allowCollapsing() && this.fInitCollapseNamespaces;
            }
            return ctx.allowCollapsing() && this.fInitCollapseBlocks;
        }
        return false;
    }

    protected boolean initiallyCollapseComments(AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return ctx.allowCollapsing() && this.fInitCollapseComments;
    }

    protected boolean canFold(String name) {
        switch (this.fBlockFolding) {
            case 0: {
                return name.equals("proc") || name.equals("namespace");
            }
            case 1: {
                return this.fBlockIncludeList.contains(name);
            }
            case 2: {
                return !this.fBlockExcludeList.contains(name);
            }
        }
        return false;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (s instanceof TypeDeclaration) {
            return this.canFold("namespace");
        }
        if (s instanceof MethodDeclaration) {
            return this.canFold("proc");
        }
        if (s instanceof RutaStatement) {
            RutaStatement statement = (RutaStatement)s;
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            return this.canFold(name);
        }
        return false;
    }
}

